/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.util.CheckClassAdapter;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.debug.ASTWriter;
import jdk.nashorn.internal.ir.debug.PrintVisitor;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.parser.Parser;
import jdk.nashorn.internal.runtime.CodeInstaller;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.NashornLoader;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptEnvironment;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptLoader;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.StructureLoader;
import jdk.nashorn.internal.runtime.Version;
import jdk.nashorn.internal.runtime.options.Options;

public final class Context {
    public static final boolean DEBUG = Options.getBooleanProperty("nashorn.debug");
    private static final ThreadLocal<ScriptObject> currentGlobal = new ThreadLocal();
    private final ScriptEnvironment env;
    final boolean _strict;
    private final ClassLoader appLoader;
    private final ClassLoader classPathLoader;
    private final ScriptLoader scriptLoader;
    private final ErrorManager errors;
    private static final ClassLoader myLoader = Context.class.getClassLoader();
    private static final StructureLoader sharedLoader = AccessController.doPrivileged(new PrivilegedAction<StructureLoader>(){

        @Override
        public StructureLoader run() {
            return new StructureLoader(myLoader, null);
        }
    });

    public static ScriptObject getGlobal() {
        return Context.getGlobalTrusted();
    }

    public static void setGlobal(ScriptObject global) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("nashorn.setGlobal"));
        }
        if (global != null && !(global instanceof Global)) {
            throw new IllegalArgumentException("global is not an instance of Global!");
        }
        Context.setGlobalTrusted(global);
    }

    public static Context getContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("nashorn.getContext"));
        }
        return Context.getContextTrusted();
    }

    public static PrintWriter getCurrentErr() {
        ScriptObject global = Context.getGlobalTrusted();
        return global != null ? global.getContext().getErr() : new PrintWriter(System.err);
    }

    public static void err(String str) {
        Context.err(str, true);
    }

    public static void err(String str, boolean crlf) {
        PrintWriter err = Context.getCurrentErr();
        if (err != null) {
            if (crlf) {
                err.println(str);
            } else {
                err.print(str);
            }
        }
    }

    public Context(Options options, ErrorManager errors, ClassLoader appLoader) {
        this(options, errors, new PrintWriter(System.out, true), new PrintWriter(System.err, true), appLoader);
    }

    public Context(Options options, ErrorManager errors, PrintWriter out, PrintWriter err, ClassLoader appLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("nashorn.createContext"));
        }
        this.env = new ScriptEnvironment(options, out, err);
        this._strict = this.env._strict;
        this.appLoader = appLoader;
        this.scriptLoader = this.env._loader_per_compile ? null : this.createNewLoader();
        this.errors = errors;
        String classPath = options.getString("classpath");
        if (!this.env._compile_only && classPath != null && !classPath.isEmpty()) {
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("createClassLoader"));
            }
            this.classPathLoader = NashornLoader.createClassLoader(classPath);
        } else {
            this.classPathLoader = null;
        }
        if (this.env._version) {
            this.getErr().println("nashorn " + Version.version());
        }
        if (this.env._fullversion) {
            this.getErr().println("nashorn full version " + Version.fullVersion());
        }
    }

    public ErrorManager getErrorManager() {
        return this.errors;
    }

    public ScriptEnvironment getEnv() {
        return this.env;
    }

    public PrintWriter getOut() {
        return this.env.getOut();
    }

    public PrintWriter getErr() {
        return this.env.getErr();
    }

    public static PropertyMap getGlobalMap() {
        return Context.getGlobalTrusted().getMap();
    }

    public ScriptFunction compileScript(Source source, ScriptObject scope) {
        return this.compileScript(source, scope, this.errors);
    }

    public Object eval(ScriptObject initialScope, String string, Object callThis, Object location, boolean strict) {
        String file = location == ScriptRuntime.UNDEFINED || location == null ? "<eval>" : location.toString();
        Source source = new Source(file, string);
        boolean directEval = location != ScriptRuntime.UNDEFINED;
        ScriptObject global = Context.getGlobalTrusted();
        ScriptObject scope = initialScope;
        boolean strictFlag = directEval && strict;
        Class<?> clazz = null;
        try {
            clazz = this.compile(source, new ThrowErrorManager(), strictFlag);
        }
        catch (ParserException e) {
            e.throwAsEcmaException(global);
            return null;
        }
        if (!strictFlag) {
            try {
                strictFlag = clazz.getField(CompilerConstants.STRICT_MODE.symbolName()).getBoolean(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                strictFlag = false;
            }
        }
        if (strictFlag) {
            ScriptObject strictEvalScope = ((GlobalObject)((Object)global)).newObject();
            strictEvalScope.setIsScope();
            strictEvalScope.setProto(scope);
            scope = strictEvalScope;
        }
        ScriptFunction func = Context.getRunScriptFunction(clazz, scope);
        Object evalThis = directEval ? (callThis instanceof ScriptObject || strictFlag ? callThis : global) : global;
        return ScriptRuntime.apply(func, evalThis, new Object[0]);
    }

    private static Source loadInternal(final String srcStr, String prefix, String resourcePath) {
        if (srcStr.startsWith(prefix)) {
            final String resource = resourcePath + srcStr.substring(prefix.length());
            return AccessController.doPrivileged(new PrivilegedAction<Source>(){

                @Override
                public Source run() {
                    try {
                        URL resURL = Context.class.getResource(resource);
                        return resURL != null ? new Source(srcStr, resURL) : null;
                    }
                    catch (IOException exp) {
                        return null;
                    }
                }
            });
        }
        return null;
    }

    public Object load(ScriptObject scope, Object from) throws IOException {
        Map map;
        Object src = from instanceof ConsString ? from.toString() : from;
        Source source = null;
        if (src instanceof String) {
            String srcStr = (String)src;
            File file = new File(srcStr);
            if (srcStr.indexOf(58) != -1) {
                source = Context.loadInternal(srcStr, "nashorn:", "resources/");
                if (source == null && (source = Context.loadInternal(srcStr, "fx:", "resources/fx/")) == null) {
                    URL url;
                    try {
                        url = new URL(srcStr);
                    }
                    catch (MalformedURLException e) {
                        url = file.toURI().toURL();
                    }
                    source = new Source(url.toString(), url);
                }
            } else if (file.isFile()) {
                source = new Source(srcStr, file);
            }
        } else if (src instanceof File && ((File)src).isFile()) {
            File file = (File)src;
            source = new Source(file.getName(), file);
        } else if (src instanceof URL) {
            URL url = (URL)src;
            source = new Source(url.toString(), url);
        } else if (src instanceof ScriptObject) {
            ScriptObject sobj = (ScriptObject)src;
            if (sobj.has("script") && sobj.has("name")) {
                String script = JSType.toString(sobj.get("script"));
                String name = JSType.toString(sobj.get("name"));
                source = new Source(name, script);
            }
        } else if (src instanceof Map && (map = (Map)src).containsKey("script") && map.containsKey("name")) {
            String script = JSType.toString(map.get("script"));
            String name = JSType.toString(map.get("name"));
            source = new Source(name, script);
        }
        if (source != null) {
            return this.evaluateSource(source, scope, scope);
        }
        throw ECMAErrors.typeError("cant.load.script", ScriptRuntime.safeToString(from));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadWithNewGlobal(Object from, Object ... args) throws IOException {
        ScriptObject oldGlobal = Context.getGlobalTrusted();
        ScriptObject newGlobal = AccessController.doPrivileged(new PrivilegedAction<ScriptObject>(){

            @Override
            public ScriptObject run() {
                try {
                    return Context.this.createGlobal();
                }
                catch (RuntimeException e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
        });
        Context.setGlobalTrusted(newGlobal);
        Object[] wrapped = args == null ? ScriptRuntime.EMPTY_ARRAY : ScriptObjectMirror.wrapArray(args, newGlobal);
        newGlobal.put("arguments", ((GlobalObject)((Object)newGlobal)).wrapAsObject(wrapped));
        try {
            Object object = ScriptObjectMirror.wrap(this.load(newGlobal, from), newGlobal);
            return object;
        }
        finally {
            Context.setGlobalTrusted(oldGlobal);
        }
    }

    public static Class<?> forStructureClass(String fullName) throws ClassNotFoundException {
        return Class.forName(fullName, true, sharedLoader);
    }

    public Class<?> findClass(final String fullName) throws ClassNotFoundException {
        SecurityManager sm;
        final int index = fullName.lastIndexOf(46);
        if (index != -1 && (sm = System.getSecurityManager()) != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    sm.checkPackageAccess(fullName.substring(0, index));
                    return null;
                }
            }, Context.createNoPermissionsContext());
        }
        if (this.classPathLoader != null) {
            try {
                return Class.forName(fullName, true, this.classPathLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(fullName, true, this.appLoader);
    }

    public static void printStackTrace(Throwable t) {
        if (DEBUG) {
            t.printStackTrace(Context.getCurrentErr());
        }
    }

    public void verify(byte[] bytecode) {
        if (this.env._verify_code && System.getSecurityManager() == null) {
            CheckClassAdapter.verify(new ClassReader(bytecode), this.scriptLoader, false, new PrintWriter(System.err, true));
        }
    }

    public ScriptObject createGlobal() {
        return this.initGlobal(this.newGlobal());
    }

    public ScriptObject newGlobal() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("nashorn.newGlobal"));
        }
        return this.newGlobalTrusted();
    }

    public ScriptObject initGlobal(ScriptObject global) {
        if (!(global instanceof GlobalObject)) {
            throw new IllegalArgumentException("not a global object!");
        }
        if (!this.env._compile_only) {
            ScriptObject oldGlobal = Context.getGlobalTrusted();
            try {
                Context.setGlobalTrusted(global);
                ((GlobalObject)((Object)global)).initBuiltinObjects();
            }
            finally {
                Context.setGlobalTrusted(oldGlobal);
            }
        }
        return global;
    }

    static ScriptObject getGlobalTrusted() {
        return currentGlobal.get();
    }

    static void setGlobalTrusted(ScriptObject global) {
        currentGlobal.set(global);
    }

    static Context getContextTrusted() {
        return Context.getGlobalTrusted().getContext();
    }

    static Context fromClass(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        Context context = null;
        if (loader instanceof NashornLoader) {
            context = ((NashornLoader)loader).getContext();
        }
        return context != null ? context : Context.getContextTrusted();
    }

    private static AccessControlContext createNoPermissionsContext() {
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, new Permissions())});
    }

    private Object evaluateSource(Source source, ScriptObject scope, ScriptObject thiz) {
        ScriptFunction script = null;
        try {
            script = this.compileScript(source, scope, new ThrowErrorManager());
        }
        catch (ParserException e) {
            e.throwAsEcmaException();
        }
        return ScriptRuntime.apply(script, thiz, new Object[0]);
    }

    private static ScriptFunction getRunScriptFunction(Class<?> script, ScriptObject scope) {
        boolean strict;
        if (script == null) {
            return null;
        }
        MethodHandle runMethodHandle = Lookup.MH.findStatic(MethodHandles.lookup(), script, CompilerConstants.RUN_SCRIPT.symbolName(), Lookup.MH.type(Object.class, ScriptFunction.class, Object.class));
        try {
            strict = script.getField(CompilerConstants.STRICT_MODE.symbolName()).getBoolean(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            strict = false;
        }
        return ((GlobalObject)((Object)Context.getGlobalTrusted())).newScriptFunction(CompilerConstants.RUN_SCRIPT.symbolName(), runMethodHandle, scope, strict);
    }

    private ScriptFunction compileScript(Source source, ScriptObject scope, ErrorManager errMan) {
        return Context.getRunScriptFunction(this.compile(source, errMan, this._strict), scope);
    }

    private synchronized Class<?> compile(Source source, ErrorManager errMan, boolean strict) {
        Class<?> script;
        errMan.reset();
        GlobalObject global = null;
        if (this.env._class_cache_size > 0 && (script = (global = (GlobalObject)((Object)Context.getGlobalTrusted())).findCachedClass(source)) != null) {
            Compiler.LOG.fine("Code cache hit for ", source, " avoiding recompile.");
            return script;
        }
        FunctionNode functionNode = new Parser(this.env, source, errMan, strict).parse();
        if (this.errors.hasErrors()) {
            return null;
        }
        if (this.env._print_ast) {
            this.getErr().println(new ASTWriter(functionNode));
        }
        if (this.env._print_parse) {
            this.getErr().println(new PrintVisitor(functionNode));
        }
        if (this.env._parse_only) {
            return null;
        }
        URL url = source.getURL();
        ScriptLoader loader = this.env._loader_per_compile ? this.createNewLoader() : this.scriptLoader;
        CodeSource cs = url == null ? null : new CodeSource(url, (CodeSigner[])null);
        ContextCodeInstaller installer = new ContextCodeInstaller(this, loader, cs);
        Compiler compiler = new Compiler(installer, strict);
        FunctionNode newFunctionNode = compiler.compile(functionNode);
        script = compiler.install(newFunctionNode);
        if (global != null) {
            global.cacheClass(source, script);
        }
        return script;
    }

    private ScriptLoader createNewLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ScriptLoader>(){

            @Override
            public ScriptLoader run() {
                return new ScriptLoader(sharedLoader, Context.this);
            }
        });
    }

    private ScriptObject newGlobalTrusted() {
        return new Global(this);
    }

    public static class ThrowErrorManager
    extends ErrorManager {
        @Override
        public void error(String message) {
            throw new ParserException(message);
        }

        @Override
        public void error(ParserException e) {
            throw e;
        }
    }

    public static class ContextCodeInstaller
    implements CodeInstaller<ScriptEnvironment> {
        private final Context context;
        private final ScriptLoader loader;
        private final CodeSource codeSource;

        private ContextCodeInstaller(Context context, ScriptLoader loader, CodeSource codeSource) {
            this.context = context;
            this.loader = loader;
            this.codeSource = codeSource;
        }

        @Override
        public ScriptEnvironment getOwner() {
            return this.context.env;
        }

        @Override
        public Class<?> install(String className, byte[] bytecode) {
            return this.loader.installClass(className, bytecode, this.codeSource);
        }

        @Override
        public void verify(byte[] code) {
            this.context.verify(code);
        }
    }
}

