/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.codegen.types.Type;

final class CompiledFunction
implements Comparable<CompiledFunction> {
    private final MethodType type;
    private final MethodHandle invoker;
    private MethodHandle constructor;

    CompiledFunction(MethodType type, MethodHandle invoker) {
        this(type, invoker, null);
    }

    CompiledFunction(MethodType type, MethodHandle invoker, MethodHandle constructor) {
        this.type = type;
        this.invoker = invoker;
        this.constructor = constructor;
    }

    public String toString() {
        return "<callSiteType= " + this.type + " invoker=" + this.invoker + " ctor=" + this.constructor + ">";
    }

    MethodHandle getInvoker() {
        return this.invoker;
    }

    MethodHandle getConstructor() {
        return this.constructor;
    }

    void setConstructor(MethodHandle constructor) {
        this.constructor = constructor;
    }

    boolean hasConstructor() {
        return this.constructor != null;
    }

    MethodType type() {
        return this.type;
    }

    @Override
    public int compareTo(CompiledFunction o) {
        return this.weight() - o.weight();
    }

    private int weight() {
        return CompiledFunction.weight(this.type());
    }

    private static int weight(MethodType type) {
        if (CompiledFunction.isVarArgsType(type)) {
            return Integer.MAX_VALUE;
        }
        int weight = Type.typeFor(type.returnType()).getWeight();
        for (Class<?> paramType : type.parameterArray()) {
            int pweight = Type.typeFor(paramType).getWeight() * 2;
            weight += pweight;
        }
        return weight;
    }

    private static boolean isVarArgsType(MethodType type) {
        assert (type.parameterCount() >= 1) : type;
        return type.parameterType(type.parameterCount() - 1) == Object[].class;
    }

    boolean moreGenericThan(CompiledFunction o) {
        return this.weight() > o.weight();
    }

    boolean moreGenericThan(MethodType mt) {
        return this.weight() > CompiledFunction.weight(mt);
    }

    boolean typeCompatible(MethodType mt) {
        Class<?>[] existingParams;
        Class<?>[] wantedParams = mt.parameterArray();
        if (wantedParams.length != (existingParams = this.type().parameterArray()).length && !CompiledFunction.isVarArgsType(mt)) {
            return false;
        }
        int lastParamIndex = Math.min(wantedParams.length, existingParams.length);
        for (int i = 0; i < lastParamIndex; ++i) {
            Type w = Type.typeFor(wantedParams[i]);
            Type e = Type.typeFor(existingParams[i]);
            if (w.isBoolean()) {
                return false;
            }
            if (e.isArray()) {
                return true;
            }
            if (Type.widest(w, e) == e) continue;
            return false;
        }
        return true;
    }
}

