/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Namespace;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BlockLexicalContext;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.LoopNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyKey;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.parser.AbstractParser;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenKind;
import jdk.nashorn.internal.parser.TokenStream;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.JSErrorType;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.ScriptEnvironment;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Timing;

public class Parser
extends AbstractParser {
    private final ScriptEnvironment env;
    private final boolean scripting;
    private List<Statement> functionDeclarations;
    private final BlockLexicalContext lc = new BlockLexicalContext();
    private final Namespace namespace;
    private static final DebugLogger LOG = new DebugLogger("parser");

    public Parser(ScriptEnvironment env, Source source, ErrorManager errors) {
        this(env, source, errors, env._strict);
    }

    public Parser(ScriptEnvironment env, Source source, ErrorManager errors, boolean strict) {
        super(source, errors, strict);
        this.env = env;
        this.namespace = new Namespace(env.getNamespace());
        this.scripting = env._scripting;
    }

    public FunctionNode parse() {
        return this.parse(CompilerConstants.RUN_SCRIPT.symbolName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionNode parse(String scriptName) {
        String end;
        FunctionNode functionNode;
        long t0 = Timing.isEnabled() ? System.currentTimeMillis() : 0L;
        LOG.info(this, " begin for '", scriptName, "'");
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, this.stream, this.scripting && !this.env._no_syntax_extensions);
            this.k = -1;
            this.next();
            functionNode = this.program(scriptName);
            end = this + " end '" + scriptName + "'";
        }
        catch (Exception e) {
            String end2;
            FunctionNode functionNode2;
            try {
                this.handleParseException(e);
                functionNode2 = null;
                end2 = this + " end '" + scriptName + "'";
            }
            catch (Throwable throwable) {
                String end3 = this + " end '" + scriptName + "'";
                if (Timing.isEnabled()) {
                    Timing.accumulateTime(this.toString(), System.currentTimeMillis() - t0);
                    LOG.info(end3, "' in ", System.currentTimeMillis() - t0, " ms");
                } else {
                    LOG.info(end3);
                }
                throw throwable;
            }
            if (Timing.isEnabled()) {
                Timing.accumulateTime(this.toString(), System.currentTimeMillis() - t0);
                LOG.info(end2, "' in ", System.currentTimeMillis() - t0, " ms");
            } else {
                LOG.info(end2);
            }
            return functionNode2;
        }
        if (Timing.isEnabled()) {
            Timing.accumulateTime(this.toString(), System.currentTimeMillis() - t0);
            LOG.info(end, "' in ", System.currentTimeMillis() - t0, " ms");
        } else {
            LOG.info(end);
        }
        return functionNode;
    }

    public List<IdentNode> parseFormalParameterList() {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, this.stream, this.scripting && !this.env._no_syntax_extensions);
            this.k = -1;
            this.next();
            return this.formalParameterList(TokenType.EOF);
        }
        catch (Exception e) {
            this.handleParseException(e);
            return null;
        }
    }

    public FunctionNode parseFunctionBody() {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, this.stream, this.scripting && !this.env._no_syntax_extensions);
            this.k = -1;
            this.next();
            long functionToken = Token.toDesc(TokenType.FUNCTION, 0, this.source.getLength());
            FunctionNode function = this.newFunctionNode(functionToken, new IdentNode(functionToken, Token.descPosition(functionToken), CompilerConstants.RUN_SCRIPT.symbolName()), new ArrayList<IdentNode>(), FunctionNode.Kind.NORMAL);
            this.functionDeclarations = new ArrayList<Statement>();
            this.sourceElements();
            this.addFunctionDeclarations(function);
            this.functionDeclarations = null;
            this.expect(TokenType.EOF);
            function.setFinish(this.source.getLength() - 1);
            function = this.restoreFunctionNode(function, this.token);
            function = function.setBody(this.lc, function.getBody().setNeedsScope(this.lc));
            return function;
        }
        catch (Exception e) {
            this.handleParseException(e);
            return null;
        }
    }

    private void handleParseException(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            message = e.toString();
        }
        if (e instanceof ParserException) {
            this.errors.error((ParserException)e);
        } else {
            this.errors.error(message);
        }
        if (this.env._dump_on_error) {
            e.printStackTrace(this.env.getErr());
        }
    }

    private void recover(Exception e) {
        if (e != null) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            if (e instanceof ParserException) {
                this.errors.error((ParserException)e);
            } else {
                this.errors.error(message);
            }
            if (this.env._dump_on_error) {
                e.printStackTrace(this.env.getErr());
            }
        }
        block4: while (true) {
            switch (this.type) {
                case EOF: {
                    break block4;
                }
                case EOL: 
                case SEMICOLON: 
                case RBRACE: {
                    this.next();
                    break block4;
                }
                default: {
                    this.nextOrEOL();
                    continue block4;
                }
            }
            break;
        }
    }

    private Block newBlock() {
        return this.lc.push(new Block(this.line, this.token, Token.descPosition(this.token), new Statement[0]));
    }

    private FunctionNode newFunctionNode(long startToken, IdentNode ident, List<IdentNode> parameters, FunctionNode.Kind kind) {
        StringBuilder sb = new StringBuilder();
        FunctionNode parentFunction = this.lc.getCurrentFunction();
        if (parentFunction != null && !parentFunction.isProgram()) {
            sb.append(parentFunction.getName()).append('$');
        }
        sb.append(ident != null ? ident.getName() : CompilerConstants.FUNCTION_PREFIX.symbolName());
        String name = this.namespace.uniqueName(sb.toString());
        assert (parentFunction != null || name.equals(CompilerConstants.RUN_SCRIPT.symbolName())) : "name = " + name;
        int flags = 0;
        if (parentFunction == null) {
            flags |= 0x1000;
        }
        if (this.isStrictMode) {
            flags |= 4;
        }
        if (this.env._specialize_calls != null && this.env._specialize_calls.contains(name)) {
            flags |= 0x4000;
        }
        FunctionNode functionNode = new FunctionNode(this.source, this.line, this.token, Token.descPosition(this.token), startToken, this.namespace, ident, name, parameters, kind, flags);
        this.lc.push(functionNode);
        this.newBlock();
        return functionNode;
    }

    private Block restoreBlock(Block block) {
        return this.lc.pop(block);
    }

    private FunctionNode restoreFunctionNode(FunctionNode functionNode, long lastToken) {
        Block newBody = this.restoreBlock(this.lc.getFunctionBody(functionNode));
        return this.lc.pop(functionNode).setBody(this.lc, newBody).setLastToken(this.lc, lastToken).setState(this.lc, this.errors.hasErrors() ? FunctionNode.CompilationState.PARSE_ERROR : FunctionNode.CompilationState.PARSED).snapshot(this.lc);
    }

    private Block getBlock(boolean needsBraces) {
        Block newBlock = this.newBlock();
        try {
            if (needsBraces) {
                this.expect(TokenType.LBRACE);
            }
            this.statementList();
        }
        finally {
            newBlock = this.restoreBlock(newBlock);
        }
        int possibleEnd = Token.descPosition(this.token) + Token.descLength(this.token);
        if (needsBraces) {
            this.expect(TokenType.RBRACE);
        }
        newBlock.setFinish(possibleEnd);
        return newBlock;
    }

    private Block getStatement() {
        if (this.type == TokenType.LBRACE) {
            return this.getBlock(true);
        }
        Block newBlock = this.newBlock();
        try {
            this.statement();
        }
        finally {
            newBlock = this.restoreBlock(newBlock);
        }
        return newBlock;
    }

    private void detectSpecialFunction(IdentNode ident) {
        String name = ident.getName();
        if (CompilerConstants.EVAL.symbolName().equals(name)) {
            Parser.markEval(this.lc);
        }
    }

    private void detectSpecialProperty(IdentNode ident) {
        String name = ident.getName();
        if (CompilerConstants.ARGUMENTS.symbolName().equals(name)) {
            this.lc.setFlag(this.lc.getCurrentFunction(), 8);
        }
    }

    private static boolean checkIdentLValue(IdentNode ident) {
        return Token.descType(ident.getToken()).getKind() != TokenKind.KEYWORD;
    }

    private Node verifyAssignment(long op, Node lhs, Node rhs) {
        TokenType opType = Token.descType(op);
        switch (opType) {
            case ASSIGN: 
            case ASSIGN_ADD: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_SHR: 
            case ASSIGN_SUB: {
                if (!(lhs instanceof AccessNode || lhs instanceof IndexNode || lhs instanceof IdentNode)) {
                    return this.referenceError(lhs, rhs, this.env._early_lvalue_error);
                }
                if (!(lhs instanceof IdentNode)) break;
                if (!Parser.checkIdentLValue((IdentNode)lhs)) {
                    return this.referenceError(lhs, rhs, false);
                }
                this.verifyStrictIdent((IdentNode)lhs, "assignment");
                break;
            }
        }
        return new BinaryNode(op, lhs, rhs);
    }

    private static Node incDecExpression(long firstToken, TokenType tokenType, Node expression, boolean isPostfix) {
        if (isPostfix) {
            return new UnaryNode(Token.recast(firstToken, tokenType == TokenType.DECPREFIX ? TokenType.DECPOSTFIX : TokenType.INCPOSTFIX), expression.getStart(), Token.descPosition(firstToken) + Token.descLength(firstToken), expression);
        }
        return new UnaryNode(firstToken, expression);
    }

    private FunctionNode program(String scriptName) {
        long functionToken = Token.toDesc(TokenType.FUNCTION, 0, this.source.getLength());
        FunctionNode script = this.newFunctionNode(functionToken, new IdentNode(functionToken, Token.descPosition(functionToken), scriptName), new ArrayList<IdentNode>(), FunctionNode.Kind.SCRIPT);
        this.functionDeclarations = new ArrayList<Statement>();
        this.sourceElements();
        this.addFunctionDeclarations(script);
        this.functionDeclarations = null;
        this.expect(TokenType.EOF);
        script.setFinish(this.source.getLength() - 1);
        script = this.restoreFunctionNode(script, this.token);
        script = script.setBody(this.lc, script.getBody().setNeedsScope(this.lc));
        return script;
    }

    private String getDirective(Node stmt) {
        LiteralNode lit;
        long litToken;
        TokenType tt;
        Node expr;
        if (stmt instanceof ExecuteNode && (expr = ((ExecuteNode)stmt).getExpression()) instanceof LiteralNode && ((tt = Token.descType(litToken = (lit = (LiteralNode)expr).getToken())) == TokenType.STRING || tt == TokenType.ESCSTRING)) {
            return this.source.getString(lit.getStart(), Token.descLength(litToken));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourceElements() {
        ArrayList<Statement> directiveStmts = null;
        boolean checkDirective = true;
        boolean oldStrictMode = this.isStrictMode;
        try {
            while (this.type != TokenType.EOF) {
                if (this.type == TokenType.RBRACE) {
                    break;
                }
                try {
                    this.statement(true);
                    if (checkDirective) {
                        Statement lastStatement = this.lc.getLastStatement();
                        String directive = this.getDirective(lastStatement);
                        boolean bl = checkDirective = directive != null;
                        if (checkDirective) {
                            if (!oldStrictMode) {
                                if (directiveStmts == null) {
                                    directiveStmts = new ArrayList<Statement>();
                                }
                                directiveStmts.add(lastStatement);
                            }
                            if ("use strict".equals(directive)) {
                                this.isStrictMode = true;
                                FunctionNode function = this.lc.getCurrentFunction();
                                this.lc.setFlag(this.lc.getCurrentFunction(), 4);
                                if (!oldStrictMode && directiveStmts != null) {
                                    for (Node node : directiveStmts) {
                                        this.getValue(node.getToken());
                                    }
                                    this.verifyStrictIdent(function.getIdent(), "function name");
                                    for (IdentNode identNode : function.getParameters()) {
                                        this.verifyStrictIdent(identNode, "function parameter");
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.recover(e);
                }
                this.stream.commit(this.k);
            }
        }
        finally {
            this.isStrictMode = oldStrictMode;
        }
    }

    private void statement() {
        this.statement(false);
    }

    private void statement(boolean topLevel) {
        if (this.type == TokenType.FUNCTION) {
            this.functionExpression(true, topLevel);
            return;
        }
        switch (this.type) {
            case LBRACE: {
                this.block();
                break;
            }
            case VAR: {
                this.variableStatement(true);
                break;
            }
            case SEMICOLON: {
                this.emptyStatement();
                break;
            }
            case IF: {
                this.ifStatement();
                break;
            }
            case FOR: {
                this.forStatement();
                break;
            }
            case WHILE: {
                this.whileStatement();
                break;
            }
            case DO: {
                this.doStatement();
                break;
            }
            case CONTINUE: {
                this.continueStatement();
                break;
            }
            case BREAK: {
                this.breakStatement();
                break;
            }
            case RETURN: {
                this.returnStatement();
                break;
            }
            case YIELD: {
                this.yieldStatement();
                break;
            }
            case WITH: {
                this.withStatement();
                break;
            }
            case SWITCH: {
                this.switchStatement();
                break;
            }
            case THROW: {
                this.throwStatement();
                break;
            }
            case TRY: {
                this.tryStatement();
                break;
            }
            case DEBUGGER: {
                this.debuggerStatement();
                break;
            }
            case EOF: 
            case RPAREN: 
            case RBRACKET: {
                this.expect(TokenType.SEMICOLON);
                break;
            }
            default: {
                if ((this.type == TokenType.IDENT || this.isNonStrictModeIdent()) && this.T(this.k + 1) == TokenType.COLON) {
                    this.labelStatement();
                    return;
                }
                this.expressionStatement();
            }
        }
    }

    private void block() {
        Block newBlock = this.getBlock(true);
        this.appendStatement(new ExecuteNode(newBlock.getLineNumber(), newBlock.getToken(), this.finish, newBlock));
    }

    private void statementList() {
        block3: while (this.type != TokenType.EOF) {
            switch (this.type) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    break block3;
                }
                default: {
                    this.statement();
                    continue block3;
                }
            }
        }
    }

    private void verifyStrictIdent(IdentNode ident, String contextString) {
        if (this.isStrictMode) {
            switch (ident.getName()) {
                case "eval": 
                case "arguments": {
                    throw this.error(AbstractParser.message("strict.name", ident.getName(), contextString), ident.getToken());
                }
            }
        }
    }

    private List<VarNode> variableStatement(boolean isStatement) {
        this.next();
        ArrayList<VarNode> vars = new ArrayList<VarNode>();
        while (true) {
            int varLine = this.line;
            long varToken = this.token;
            IdentNode name = this.getIdent();
            this.verifyStrictIdent(name, "variable name");
            Node init = null;
            if (this.type == TokenType.ASSIGN) {
                this.next();
                init = this.assignmentExpression(!isStatement);
            }
            VarNode var = new VarNode(varLine, varToken, this.finish, name, init);
            vars.add(var);
            this.appendStatement(var);
            if (this.type != TokenType.COMMARIGHT) break;
            this.next();
        }
        if (isStatement) {
            boolean semicolon = this.type == TokenType.SEMICOLON;
            this.endOfLine();
            if (semicolon) {
                this.lc.getCurrentBlock().setFinish(this.finish);
            }
        }
        return vars;
    }

    private void emptyStatement() {
        if (this.env._empty_statements) {
            this.appendStatement(new EmptyNode(this.line, this.token, Token.descPosition(this.token) + Token.descLength(this.token)));
        }
        this.next();
    }

    private void expressionStatement() {
        int expressionLine = this.line;
        long expressionToken = this.token;
        Node expression = this.expression();
        ExecuteNode executeNode = null;
        if (expression != null) {
            executeNode = new ExecuteNode(expressionLine, expressionToken, this.finish, expression);
            this.appendStatement(executeNode);
        } else {
            this.expect(null);
        }
        this.endOfLine();
        if (executeNode != null) {
            executeNode.setFinish(this.finish);
            this.lc.getCurrentBlock().setFinish(this.finish);
        }
    }

    private void ifStatement() {
        int ifLine = this.line;
        long ifToken = this.token;
        this.next();
        this.expect(TokenType.LPAREN);
        Node test = this.expression();
        this.expect(TokenType.RPAREN);
        Block pass = this.getStatement();
        Block fail = null;
        if (this.type == TokenType.ELSE) {
            this.next();
            fail = this.getStatement();
        }
        this.appendStatement(new IfNode(ifLine, ifToken, fail != null ? fail.getFinish() : pass.getFinish(), test, pass, fail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void forStatement() {
        ForNode forNode = new ForNode(this.line, this.token, Token.descPosition(this.token), null, null, null, null, 1);
        Block outer = this.newBlock();
        this.lc.push(forNode);
        try {
            this.next();
            if (!this.env._no_syntax_extensions && this.type == TokenType.IDENT && "each".equals(this.getValue())) {
                forNode = forNode.setIsForEach(this.lc);
                this.next();
            }
            this.expect(TokenType.LPAREN);
            List<VarNode> vars = null;
            switch (this.type) {
                case VAR: {
                    vars = this.variableStatement(false);
                    break;
                }
                case SEMICOLON: {
                    break;
                }
                default: {
                    Node expression = this.expression(this.unaryExpression(), TokenType.COMMARIGHT.getPrecedence(), true);
                    forNode = forNode.setInit(this.lc, expression);
                }
            }
            switch (this.type) {
                case SEMICOLON: {
                    if (forNode.isForEach()) {
                        throw this.error(AbstractParser.message("for.each.without.in", new String[0]), this.token);
                    }
                    this.expect(TokenType.SEMICOLON);
                    if (this.type != TokenType.SEMICOLON) {
                        forNode = forNode.setTest(this.lc, this.expression());
                    }
                    this.expect(TokenType.SEMICOLON);
                    if (this.type == TokenType.RPAREN) break;
                    forNode = forNode.setModify(this.lc, this.expression());
                    break;
                }
                case IN: {
                    forNode = forNode.setIsForIn(this.lc);
                    if (vars != null) {
                        if (vars.size() != 1) throw this.error(AbstractParser.message("many.vars.in.for.in.loop", new String[0]), vars.get(1).getToken());
                        forNode = forNode.setInit(this.lc, new IdentNode(vars.get(0).getName()));
                    } else {
                        Node init = forNode.getInit();
                        assert (init != null) : "for..in init expression can not be null here";
                        if (!(init instanceof AccessNode || init instanceof IndexNode || init instanceof IdentNode)) {
                            throw this.error(AbstractParser.message("not.lvalue.for.in.loop", new String[0]), init.getToken());
                        }
                        if (init instanceof IdentNode) {
                            if (!Parser.checkIdentLValue((IdentNode)init)) {
                                throw this.error(AbstractParser.message("not.lvalue.for.in.loop", new String[0]), init.getToken());
                            }
                            this.verifyStrictIdent((IdentNode)init, "for-in iterator");
                        }
                    }
                    this.next();
                    forNode = forNode.setModify(this.lc, this.expression());
                    break;
                }
                default: {
                    this.expect(TokenType.SEMICOLON);
                }
            }
            this.expect(TokenType.RPAREN);
            Block body = this.getStatement();
            forNode = forNode.setBody(this.lc, body);
            forNode.setFinish(body.getFinish());
            outer.setFinish(body.getFinish());
            this.appendStatement(forNode);
        }
        finally {
            this.lc.pop(forNode);
            outer = this.restoreBlock(outer);
        }
        this.appendStatement(new ExecuteNode(outer.getLineNumber(), outer.getToken(), outer.getFinish(), outer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whileStatement() {
        int whileLine = this.line;
        long whileToken = this.token;
        this.next();
        WhileNode whileNode = new WhileNode(whileLine, whileToken, Token.descPosition(whileToken), false);
        this.lc.push(whileNode);
        try {
            this.expect(TokenType.LPAREN);
            whileNode = whileNode.setTest(this.lc, this.expression());
            this.expect(TokenType.RPAREN);
            whileNode = whileNode.setBody(this.lc, this.getStatement());
            this.appendStatement(whileNode);
        }
        finally {
            this.lc.pop(whileNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStatement() {
        int doLine = this.line;
        long doToken = this.token;
        this.next();
        WhileNode doWhileNode = new WhileNode(doLine, doToken, Token.descPosition(doToken), true);
        this.lc.push(doWhileNode);
        try {
            doWhileNode = doWhileNode.setBody(this.lc, this.getStatement());
            this.expect(TokenType.WHILE);
            this.expect(TokenType.LPAREN);
            doWhileNode = doWhileNode.setTest(this.lc, this.expression());
            this.expect(TokenType.RPAREN);
            if (this.type == TokenType.SEMICOLON) {
                this.endOfLine();
            }
            doWhileNode.setFinish(this.finish);
            this.appendStatement(doWhileNode);
        }
        finally {
            this.lc.pop(doWhileNode);
        }
    }

    private void continueStatement() {
        int continueLine = this.line;
        long continueToken = this.token;
        this.nextOrEOL();
        LabelNode labelNode = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                IdentNode ident = this.getIdent();
                labelNode = this.lc.findLabel(ident.getName());
                if (labelNode != null) break;
                throw this.error(AbstractParser.message("undefined.label", ident.getName()), ident.getToken());
            }
        }
        IdentNode label = labelNode == null ? null : labelNode.getLabel();
        LoopNode targetNode = this.lc.getContinueTo(label);
        if (targetNode == null) {
            throw this.error(AbstractParser.message("illegal.continue.stmt", new String[0]), continueToken);
        }
        this.endOfLine();
        this.appendStatement(new ContinueNode(continueLine, continueToken, this.finish, label == null ? null : new IdentNode(label)));
    }

    private void breakStatement() {
        int breakLine = this.line;
        long breakToken = this.token;
        this.nextOrEOL();
        LabelNode labelNode = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                IdentNode ident = this.getIdent();
                labelNode = this.lc.findLabel(ident.getName());
                if (labelNode != null) break;
                throw this.error(AbstractParser.message("undefined.label", ident.getName()), ident.getToken());
            }
        }
        IdentNode label = labelNode == null ? null : labelNode.getLabel();
        BreakableNode targetNode = this.lc.getBreakable(label);
        if (targetNode == null) {
            throw this.error(AbstractParser.message("illegal.break.stmt", new String[0]), breakToken);
        }
        this.endOfLine();
        this.appendStatement(new BreakNode(breakLine, breakToken, this.finish, label == null ? null : new IdentNode(label)));
    }

    private void returnStatement() {
        if (this.lc.getCurrentFunction().getKind() == FunctionNode.Kind.SCRIPT) {
            throw this.error(AbstractParser.message("invalid.return", new String[0]));
        }
        int returnLine = this.line;
        long returnToken = this.token;
        this.nextOrEOL();
        Node expression = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        this.endOfLine();
        this.appendStatement(new ReturnNode(returnLine, returnToken, this.finish, expression));
    }

    private void yieldStatement() {
        int yieldLine = this.line;
        long yieldToken = this.token;
        this.nextOrEOL();
        Node expression = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        this.endOfLine();
        this.appendStatement(new ReturnNode(yieldLine, yieldToken, this.finish, expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withStatement() {
        int withLine = this.line;
        long withToken = this.token;
        this.next();
        if (this.isStrictMode) {
            throw this.error(AbstractParser.message("strict.no.with", new String[0]), withToken);
        }
        WithNode withNode = new WithNode(withLine, withToken, this.finish);
        try {
            this.lc.push(withNode);
            this.expect(TokenType.LPAREN);
            withNode = withNode.setExpression(this.lc, this.expression());
            this.expect(TokenType.RPAREN);
            withNode = withNode.setBody(this.lc, this.getStatement());
        }
        finally {
            this.lc.pop(withNode);
        }
        this.appendStatement(withNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchStatement() {
        int switchLine = this.line;
        long switchToken = this.token;
        this.next();
        SwitchNode switchNode = new SwitchNode(switchLine, switchToken, Token.descPosition(switchToken), null, new ArrayList<CaseNode>(), null);
        this.lc.push(switchNode);
        try {
            this.expect(TokenType.LPAREN);
            switchNode = switchNode.setExpression(this.lc, this.expression());
            this.expect(TokenType.RPAREN);
            this.expect(TokenType.LBRACE);
            ArrayList<CaseNode> cases = new ArrayList<CaseNode>();
            CaseNode defaultCase = null;
            while (this.type != TokenType.RBRACE) {
                Node caseExpression = null;
                long caseToken = this.token;
                switch (this.type) {
                    case CASE: {
                        this.next();
                        caseExpression = this.expression();
                        break;
                    }
                    case DEFAULT: {
                        if (defaultCase != null) {
                            throw this.error(AbstractParser.message("duplicate.default.in.switch", new String[0]));
                        }
                        this.next();
                        break;
                    }
                    default: {
                        this.expect(TokenType.CASE);
                    }
                }
                this.expect(TokenType.COLON);
                Block statements = this.getBlock(false);
                CaseNode caseNode = new CaseNode(caseToken, this.finish, caseExpression, statements);
                statements.setFinish(this.finish);
                if (caseExpression == null) {
                    defaultCase = caseNode;
                }
                cases.add(caseNode);
            }
            switchNode = switchNode.setCases((LexicalContext)this.lc, cases, defaultCase);
            this.next();
            switchNode.setFinish(this.finish);
            this.appendStatement(switchNode);
        }
        finally {
            this.lc.pop(switchNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void labelStatement() {
        long labelToken = this.token;
        IdentNode ident = this.getIdent();
        this.expect(TokenType.COLON);
        if (this.lc.findLabel(ident.getName()) != null) {
            throw this.error(AbstractParser.message("duplicate.label", ident.getName()), labelToken);
        }
        LabelNode labelNode = new LabelNode(this.line, labelToken, this.finish, ident, null);
        try {
            this.lc.push(labelNode);
            labelNode = labelNode.setBody(this.lc, this.getStatement());
            labelNode.setFinish(this.finish);
            this.appendStatement(labelNode);
        }
        finally {
            assert (this.lc.peek() instanceof LabelNode);
            this.lc.pop(labelNode);
        }
    }

    private void throwStatement() {
        int throwLine = this.line;
        long throwToken = this.token;
        this.nextOrEOL();
        Node expression = null;
        switch (this.type) {
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        if (expression == null) {
            throw this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
        }
        this.endOfLine();
        this.appendStatement(new ThrowNode(throwLine, throwToken, this.finish, expression, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStatement() {
        int tryLine = this.line;
        long tryToken = this.token;
        this.next();
        Block outer = this.newBlock();
        try {
            Block tryBody = this.getBlock(true);
            ArrayList<Block> catchBlocks = new ArrayList<Block>();
            while (this.type == TokenType.CATCH) {
                int catchLine = this.line;
                long catchToken = this.token;
                this.next();
                this.expect(TokenType.LPAREN);
                IdentNode exception = this.getIdent();
                this.verifyStrictIdent(exception, "catch argument");
                Node ifExpression = null;
                if (this.type == TokenType.IF) {
                    this.next();
                    ifExpression = this.expression();
                }
                this.expect(TokenType.RPAREN);
                Block catchBlock = this.newBlock();
                try {
                    Block catchBody = this.getBlock(true);
                    CatchNode catchNode = new CatchNode(catchLine, catchToken, this.finish, exception, ifExpression, catchBody, 0);
                    this.appendStatement(catchNode);
                }
                finally {
                    catchBlock = this.restoreBlock(catchBlock);
                    catchBlocks.add(catchBlock);
                }
                if (ifExpression != null) continue;
                break;
            }
            Block finallyStatements = null;
            if (this.type == TokenType.FINALLY) {
                this.next();
                finallyStatements = this.getBlock(true);
            }
            if (catchBlocks.isEmpty() && finallyStatements == null) {
                throw this.error(AbstractParser.message("missing.catch.or.finally", new String[0]), tryToken);
            }
            TryNode tryNode = new TryNode(tryLine, tryToken, Token.descPosition(tryToken), tryBody, catchBlocks, finallyStatements);
            assert (this.lc.peek() == outer);
            this.appendStatement(tryNode);
            tryNode.setFinish(this.finish);
            outer.setFinish(this.finish);
        }
        finally {
            outer = this.restoreBlock(outer);
        }
        this.appendStatement(new ExecuteNode(outer.getLineNumber(), outer.getToken(), outer.getFinish(), outer));
    }

    private void debuggerStatement() {
        int debuggerLine = this.line;
        long debuggerToken = this.token;
        this.next();
        this.endOfLine();
        this.appendStatement(new ExecuteNode(debuggerLine, debuggerToken, this.finish, new RuntimeNode(debuggerToken, this.finish, RuntimeNode.Request.DEBUGGER, new ArrayList<Node>())));
    }

    private Node primaryExpression() {
        int primaryLine = this.line;
        long primaryToken = this.token;
        switch (this.type) {
            case THIS: {
                String name = this.type.getName();
                this.next();
                return new IdentNode(primaryToken, this.finish, name);
            }
            case IDENT: {
                IdentNode ident = this.getIdent();
                if (ident == null) break;
                this.detectSpecialProperty(ident);
                return ident;
            }
            case OCTAL: {
                if (this.isStrictMode) {
                    throw this.error(AbstractParser.message("strict.no.octal", new String[0]), this.token);
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case FLOATING: 
            case REGEX: 
            case XML: {
                return this.getLiteral();
            }
            case EXECSTRING: {
                return this.execString(primaryLine, primaryToken);
            }
            case FALSE: {
                this.next();
                return LiteralNode.newInstance(primaryToken, this.finish, false);
            }
            case TRUE: {
                this.next();
                return LiteralNode.newInstance(primaryToken, this.finish, true);
            }
            case NULL: {
                this.next();
                return LiteralNode.newInstance(primaryToken, this.finish);
            }
            case LBRACKET: {
                return this.arrayLiteral();
            }
            case LBRACE: {
                return this.objectLiteral();
            }
            case LPAREN: {
                this.next();
                Node expression = this.expression();
                this.expect(TokenType.RPAREN);
                return expression;
            }
            default: {
                if (this.lexer.scanLiteral(primaryToken, this.type)) {
                    this.next();
                    return this.getLiteral();
                }
                if (!this.isNonStrictModeIdent()) break;
                return this.getIdent();
            }
        }
        return null;
    }

    Node execString(int primaryLine, long primaryToken) {
        IdentNode execIdent = new IdentNode(primaryToken, this.finish, "$EXEC");
        this.next();
        ArrayList<Node> arguments = new ArrayList<Node>();
        this.expect(TokenType.LBRACE);
        arguments.add(this.expression());
        this.expect(TokenType.RBRACE);
        return new CallNode(primaryLine, primaryToken, this.finish, execIdent, arguments);
    }

    private Node arrayLiteral() {
        long arrayToken = this.token;
        this.next();
        ArrayList<Node> elements = new ArrayList<Node>();
        boolean elision = true;
        block4: while (true) {
            switch (this.type) {
                case RBRACKET: {
                    this.next();
                    break block4;
                }
                case COMMARIGHT: {
                    this.next();
                    if (elision) {
                        elements.add(null);
                    }
                    elision = true;
                    continue block4;
                }
                default: {
                    if (!elision) {
                        throw this.error(AbstractParser.message("expected.comma", this.type.getNameOrType()));
                    }
                    Node expression = this.assignmentExpression(false);
                    if (expression != null) {
                        elements.add(expression);
                    } else {
                        this.expect(TokenType.RBRACKET);
                    }
                    elision = false;
                    continue block4;
                }
            }
            break;
        }
        return LiteralNode.newInstance(arrayToken, this.finish, elements);
    }

    private Node objectLiteral() {
        long objectToken = this.token;
        this.next();
        LinkedHashMap<String, PropertyNode> map = new LinkedHashMap<String, PropertyNode>();
        boolean commaSeen = true;
        block4: while (true) {
            switch (this.type) {
                case RBRACE: {
                    this.next();
                    break block4;
                }
                case COMMARIGHT: {
                    if (commaSeen) {
                        throw this.error(AbstractParser.message("expected.property.id", this.type.getNameOrType()));
                    }
                    this.next();
                    commaSeen = true;
                    continue block4;
                }
                default: {
                    boolean isAccessor;
                    if (!commaSeen) {
                        throw this.error(AbstractParser.message("expected.comma", this.type.getNameOrType()));
                    }
                    commaSeen = false;
                    PropertyNode property = this.propertyAssignment();
                    String key = property.getKeyName();
                    PropertyNode existingProperty = (PropertyNode)map.get(key);
                    if (existingProperty == null) {
                        map.put(key, property);
                        continue block4;
                    }
                    Node value = property.getValue();
                    FunctionNode getter = property.getGetter();
                    FunctionNode setter = property.getSetter();
                    Node prevValue = existingProperty.getValue();
                    FunctionNode prevGetter = existingProperty.getGetter();
                    FunctionNode prevSetter = existingProperty.getSetter();
                    boolean redefinitionOk = true;
                    if (this.isStrictMode && value != null && prevValue != null) {
                        redefinitionOk = false;
                    }
                    boolean isPrevAccessor = prevGetter != null || prevSetter != null;
                    boolean bl = isAccessor = getter != null || setter != null;
                    if (prevValue != null && isAccessor) {
                        redefinitionOk = false;
                    }
                    if (isPrevAccessor && value != null) {
                        redefinitionOk = false;
                    }
                    if (isAccessor && isPrevAccessor && (getter != null && prevGetter != null || setter != null && prevSetter != null)) {
                        redefinitionOk = false;
                    }
                    if (!redefinitionOk) {
                        throw this.error(AbstractParser.message("property.redefinition", key), property.getToken());
                    }
                    PropertyNode newProperty = existingProperty;
                    if (value != null) {
                        if (prevValue == null) {
                            newProperty = newProperty.setValue(value);
                            map.put(key, newProperty);
                        } else {
                            long propertyToken = Token.recast(newProperty.getToken(), TokenType.COMMARIGHT);
                            newProperty = newProperty.setValue(new BinaryNode(propertyToken, prevValue, value));
                            map.put(key, newProperty);
                        }
                        newProperty = newProperty.setGetter(null).setSetter(null);
                        map.put(key, newProperty);
                    }
                    if (getter != null) {
                        newProperty = newProperty.setGetter(getter);
                        map.put(key, newProperty);
                    }
                    if (setter == null) continue block4;
                    newProperty = newProperty.setSetter(setter);
                    map.put(key, newProperty);
                    continue block4;
                }
            }
            break;
        }
        return new ObjectNode(objectToken, this.finish, new ArrayList<PropertyNode>(map.values()));
    }

    private PropertyKey propertyName() {
        switch (this.type) {
            case IDENT: {
                return this.getIdent();
            }
            case OCTAL: {
                if (this.isStrictMode) {
                    throw this.error(AbstractParser.message("strict.no.octal", new String[0]), this.token);
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case FLOATING: {
                return this.getLiteral();
            }
        }
        return this.getIdentifierName();
    }

    private PropertyNode propertyAssignment() {
        PropertyKey propertyName;
        long propertyToken = this.token;
        if (this.type == TokenType.IDENT) {
            String ident = (String)this.expectValue(TokenType.IDENT);
            if (this.type != TokenType.COLON) {
                long getSetToken = this.token;
                switch (ident) {
                    case "get": {
                        PropertyKey getIdent = this.propertyName();
                        String getterName = getIdent.getPropertyName();
                        IdentNode getNameNode = new IdentNode(((Node)((Object)getIdent)).getToken(), this.finish, "get " + getterName);
                        this.expect(TokenType.LPAREN);
                        this.expect(TokenType.RPAREN);
                        FunctionNode functionNode = this.functionBody(getSetToken, getNameNode, new ArrayList<IdentNode>(), FunctionNode.Kind.GETTER);
                        return new PropertyNode(propertyToken, this.finish, getIdent, null, functionNode, null);
                    }
                    case "set": {
                        PropertyKey setIdent = this.propertyName();
                        String setterName = setIdent.getPropertyName();
                        IdentNode setNameNode = new IdentNode(((Node)((Object)setIdent)).getToken(), this.finish, "set " + setterName);
                        this.expect(TokenType.LPAREN);
                        IdentNode argIdent = this.getIdent();
                        this.verifyStrictIdent(argIdent, "setter argument");
                        this.expect(TokenType.RPAREN);
                        ArrayList<IdentNode> parameters = new ArrayList<IdentNode>();
                        parameters.add(argIdent);
                        FunctionNode functionNode = this.functionBody(getSetToken, setNameNode, parameters, FunctionNode.Kind.SETTER);
                        return new PropertyNode(propertyToken, this.finish, setIdent, null, null, functionNode);
                    }
                }
            }
            propertyName = new IdentNode(propertyToken, this.finish, ident);
        } else {
            propertyName = this.propertyName();
        }
        this.expect(TokenType.COLON);
        return new PropertyNode(propertyToken, this.finish, propertyName, this.assignmentExpression(false), null, null);
    }

    private Node leftHandSideExpression() {
        List<Node> arguments;
        int callLine = this.line;
        long callToken = this.token;
        Node lhs = this.memberExpression();
        if (this.type == TokenType.LPAREN) {
            arguments = this.argumentList();
            if (lhs instanceof IdentNode) {
                this.detectSpecialFunction((IdentNode)lhs);
            }
            lhs = new CallNode(callLine, callToken, this.finish, lhs, arguments);
        }
        block5: while (true) {
            callLine = this.line;
            callToken = this.token;
            switch (this.type) {
                case LPAREN: {
                    arguments = this.argumentList();
                    lhs = new CallNode(callLine, callToken, this.finish, lhs, arguments);
                    continue block5;
                }
                case LBRACKET: {
                    this.next();
                    Node rhs = this.expression();
                    this.expect(TokenType.RBRACKET);
                    lhs = new IndexNode(callToken, this.finish, lhs, rhs);
                    continue block5;
                }
                case PERIOD: {
                    this.next();
                    IdentNode property = this.getIdentifierName();
                    lhs = new AccessNode(callToken, this.finish, lhs, property);
                    continue block5;
                }
            }
            break;
        }
        return lhs;
    }

    private Node newExpression() {
        long newToken = this.token;
        this.next();
        int callLine = this.line;
        Node constructor = this.memberExpression();
        if (constructor == null) {
            return null;
        }
        List<Node> arguments = this.type == TokenType.LPAREN ? this.argumentList() : new ArrayList<Node>();
        if (!this.env._no_syntax_extensions && this.type == TokenType.LBRACE) {
            arguments.add(this.objectLiteral());
        }
        CallNode callNode = new CallNode(callLine, constructor.getToken(), this.finish, constructor, arguments);
        return new UnaryNode(newToken, (Node)callNode);
    }

    private Node memberExpression() {
        Node lhs;
        switch (this.type) {
            case NEW: {
                lhs = this.newExpression();
                break;
            }
            case FUNCTION: {
                lhs = this.functionExpression(false, false);
                break;
            }
            default: {
                lhs = this.primaryExpression();
            }
        }
        block8: while (true) {
            long callToken = this.token;
            switch (this.type) {
                case LBRACKET: {
                    this.next();
                    Node index = this.expression();
                    this.expect(TokenType.RBRACKET);
                    lhs = new IndexNode(callToken, this.finish, lhs, index);
                    continue block8;
                }
                case PERIOD: {
                    if (lhs == null) {
                        throw this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
                    }
                    this.next();
                    IdentNode property = this.getIdentifierName();
                    lhs = new AccessNode(callToken, this.finish, lhs, property);
                    continue block8;
                }
            }
            break;
        }
        return lhs;
    }

    private List<Node> argumentList() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        this.next();
        boolean first = true;
        while (this.type != TokenType.RPAREN) {
            if (!first) {
                this.expect(TokenType.COMMARIGHT);
            } else {
                first = false;
            }
            nodeList.add(this.assignmentExpression(false));
        }
        this.expect(TokenType.RPAREN);
        return nodeList;
    }

    private Node functionExpression(boolean isStatement, boolean topLevel) {
        long functionToken = this.token;
        int functionLine = this.line;
        this.next();
        IdentNode name = null;
        if (this.type == TokenType.IDENT || this.isNonStrictModeIdent()) {
            name = this.getIdent();
            this.verifyStrictIdent(name, "function name");
        } else if (isStatement && this.env._no_syntax_extensions) {
            this.expect(TokenType.IDENT);
        }
        boolean isAnonymous = false;
        if (name == null) {
            String tmpName = "_L" + this.source.getLine(Token.descPosition(this.token));
            name = new IdentNode(functionToken, Token.descPosition(functionToken), tmpName);
            isAnonymous = true;
        }
        this.expect(TokenType.LPAREN);
        List<IdentNode> parameters = this.formalParameterList();
        this.expect(TokenType.RPAREN);
        FunctionNode functionNode = this.functionBody(functionToken, name, parameters, FunctionNode.Kind.NORMAL);
        if (isStatement) {
            if (topLevel) {
                functionNode = functionNode.setFlag(this.lc, 2);
            } else {
                if (this.isStrictMode) {
                    throw this.error(JSErrorType.SYNTAX_ERROR, AbstractParser.message("strict.no.func.decl.here", new String[0]), functionToken);
                }
                if (this.env._function_statement == ScriptEnvironment.FunctionStatementBehavior.ERROR) {
                    throw this.error(JSErrorType.SYNTAX_ERROR, AbstractParser.message("no.func.decl.here", new String[0]), functionToken);
                }
                if (this.env._function_statement == ScriptEnvironment.FunctionStatementBehavior.WARNING) {
                    this.warning(JSErrorType.SYNTAX_ERROR, AbstractParser.message("no.func.decl.here.warn", new String[0]), functionToken);
                }
            }
            if (CompilerConstants.ARGUMENTS.symbolName().equals(name.getName())) {
                this.lc.setFlag(this.lc.getCurrentFunction(), 256);
            }
        }
        if (isAnonymous) {
            functionNode = functionNode.setFlag(this.lc, 1);
        }
        int arity = parameters.size();
        boolean strict = functionNode.isStrict();
        if (arity > 1) {
            HashSet<String> parametersSet = new HashSet<String>(arity);
            for (int i = arity - 1; i >= 0; --i) {
                IdentNode parameter = parameters.get(i);
                String parameterName = parameter.getName();
                if (CompilerConstants.ARGUMENTS.symbolName().equals(parameterName)) {
                    functionNode = functionNode.setFlag(this.lc, 256);
                }
                if (parametersSet.contains(parameterName)) {
                    if (strict) {
                        throw this.error(AbstractParser.message("strict.param.redefinition", parameterName), parameter.getToken());
                    }
                    parameterName = functionNode.uniqueName(parameterName);
                    long parameterToken = parameter.getToken();
                    parameters.set(i, new IdentNode(parameterToken, Token.descPosition(parameterToken), functionNode.uniqueName(parameterName)));
                }
                parametersSet.add(parameterName);
            }
        } else if (arity == 1 && CompilerConstants.ARGUMENTS.symbolName().equals(parameters.get(0).getName())) {
            functionNode = functionNode.setFlag(this.lc, 256);
        }
        if (isStatement) {
            VarNode varNode = new VarNode(functionLine, functionToken, this.finish, name, functionNode, 1);
            if (topLevel) {
                this.functionDeclarations.add(varNode);
            } else {
                this.appendStatement(varNode);
            }
        }
        return functionNode;
    }

    private List<IdentNode> formalParameterList() {
        return this.formalParameterList(TokenType.RPAREN);
    }

    private List<IdentNode> formalParameterList(TokenType endType) {
        ArrayList<IdentNode> parameters = new ArrayList<IdentNode>();
        boolean first = true;
        while (this.type != endType) {
            if (!first) {
                this.expect(TokenType.COMMARIGHT);
            } else {
                first = false;
            }
            IdentNode ident = this.getIdent();
            this.verifyStrictIdent(ident, "function parameter");
            parameters.add(ident);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode functionBody(long firstToken, IdentNode ident, List<IdentNode> parameters, FunctionNode.Kind kind) {
        FunctionNode functionNode = null;
        long lastToken = 0L;
        try {
            functionNode = this.newFunctionNode(firstToken, ident, parameters, kind);
            if (!this.env._no_syntax_extensions && this.type != TokenType.LBRACE) {
                Node expr = this.assignmentExpression(true);
                assert (this.lc.getCurrentBlock() == this.lc.getFunctionBody(functionNode));
                ReturnNode returnNode = new ReturnNode(functionNode.getLineNumber(), expr.getToken(), this.finish, expr);
                this.appendStatement(returnNode);
                lastToken = this.token;
                functionNode.setFinish(Token.descPosition(this.token) + Token.descLength(this.token));
            } else {
                this.expect(TokenType.LBRACE);
                List<Statement> prevFunctionDecls = this.functionDeclarations;
                this.functionDeclarations = new ArrayList<Statement>();
                try {
                    this.sourceElements();
                    this.addFunctionDeclarations(functionNode);
                }
                finally {
                    this.functionDeclarations = prevFunctionDecls;
                }
                lastToken = this.token;
                this.expect(TokenType.RBRACE);
                functionNode.setFinish(this.finish);
            }
            functionNode = this.restoreFunctionNode(functionNode, lastToken);
        }
        catch (Throwable throwable) {
            functionNode = this.restoreFunctionNode(functionNode, lastToken);
            throw throwable;
        }
        return functionNode;
    }

    private void addFunctionDeclarations(FunctionNode functionNode) {
        assert (this.lc.peek() == this.lc.getFunctionBody(functionNode));
        VarNode lastDecl = null;
        for (int i = this.functionDeclarations.size() - 1; i >= 0; --i) {
            Statement decl = this.functionDeclarations.get(i);
            if (lastDecl == null && decl instanceof VarNode) {
                lastDecl = ((VarNode)decl).setFlag(2);
                decl = lastDecl;
                this.lc.setFlag(functionNode, 8192);
            }
            this.prependStatement(decl);
        }
    }

    private RuntimeNode referenceError(Node lhs, Node rhs, boolean earlyError) {
        if (earlyError) {
            throw this.error(JSErrorType.REFERENCE_ERROR, AbstractParser.message("invalid.lvalue", new String[0]), lhs.getToken());
        }
        ArrayList<Node> args = new ArrayList<Node>();
        args.add(lhs);
        if (rhs == null) {
            args.add(LiteralNode.newInstance(lhs.getToken(), lhs.getFinish()));
        } else {
            args.add(rhs);
        }
        args.add(LiteralNode.newInstance(lhs.getToken(), lhs.getFinish(), lhs.toString()));
        return new RuntimeNode(lhs.getToken(), lhs.getFinish(), RuntimeNode.Request.REFERENCE_ERROR, args);
    }

    private Node unaryExpression() {
        int unaryLine = this.line;
        long unaryToken = this.token;
        switch (this.type) {
            case DELETE: {
                this.next();
                Node expr = this.unaryExpression();
                if (expr instanceof BaseNode || expr instanceof IdentNode) {
                    return new UnaryNode(unaryToken, expr);
                }
                this.appendStatement(new ExecuteNode(unaryLine, unaryToken, this.finish, expr));
                return LiteralNode.newInstance(unaryToken, this.finish, true);
            }
            case VOID: 
            case TYPEOF: 
            case ADD: 
            case SUB: 
            case BIT_NOT: 
            case NOT: {
                this.next();
                Node expr = this.unaryExpression();
                return new UnaryNode(unaryToken, expr);
            }
            case INCPREFIX: 
            case DECPREFIX: {
                TokenType opType = this.type;
                this.next();
                Node lhs = this.leftHandSideExpression();
                if (lhs == null) {
                    throw this.error(AbstractParser.message("expected.lvalue", this.type.getNameOrType()));
                }
                if (!(lhs instanceof AccessNode || lhs instanceof IndexNode || lhs instanceof IdentNode)) {
                    return this.referenceError(lhs, null, this.env._early_lvalue_error);
                }
                if (lhs instanceof IdentNode) {
                    if (!Parser.checkIdentLValue((IdentNode)lhs)) {
                        return this.referenceError(lhs, null, false);
                    }
                    this.verifyStrictIdent((IdentNode)lhs, "operand for " + opType.getName() + " operator");
                }
                return Parser.incDecExpression(unaryToken, opType, lhs, false);
            }
        }
        Node expression = this.leftHandSideExpression();
        if (this.last != TokenType.EOL) {
            switch (this.type) {
                case INCPREFIX: 
                case DECPREFIX: {
                    TokenType opType = this.type;
                    Node lhs = expression;
                    if (lhs == null) {
                        throw this.error(AbstractParser.message("expected.lvalue", this.type.getNameOrType()));
                    }
                    if (!(lhs instanceof AccessNode || lhs instanceof IndexNode || lhs instanceof IdentNode)) {
                        this.next();
                        return this.referenceError(lhs, null, this.env._early_lvalue_error);
                    }
                    if (lhs instanceof IdentNode) {
                        if (!Parser.checkIdentLValue((IdentNode)lhs)) {
                            this.next();
                            return this.referenceError(lhs, null, false);
                        }
                        this.verifyStrictIdent((IdentNode)lhs, "operand for " + opType.getName() + " operator");
                    }
                    expression = Parser.incDecExpression(this.token, this.type, expression, true);
                    this.next();
                    break;
                }
            }
        }
        if (expression == null) {
            throw this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
        }
        return expression;
    }

    private Node expression() {
        return this.expression(this.unaryExpression(), TokenType.COMMARIGHT.getPrecedence(), false);
    }

    private Node expression(Node exprLhs, int minPrecedence, boolean noIn) {
        int precedence = this.type.getPrecedence();
        Node lhs = exprLhs;
        while (this.type.isOperator(noIn) && precedence >= minPrecedence) {
            Node rhs;
            long op = this.token;
            if (this.type == TokenType.TERNARY) {
                this.next();
                rhs = this.expression(this.unaryExpression(), TokenType.ASSIGN.getPrecedence(), false);
                this.expect(TokenType.COLON);
                Node third = this.expression(this.unaryExpression(), TokenType.ASSIGN.getPrecedence(), noIn);
                lhs = new TernaryNode(op, lhs, rhs, third);
            } else {
                this.next();
                rhs = this.unaryExpression();
                int nextPrecedence = this.type.getPrecedence();
                while (this.type.isOperator(noIn) && (nextPrecedence > precedence || nextPrecedence == precedence && !this.type.isLeftAssociative())) {
                    rhs = this.expression(rhs, nextPrecedence, noIn);
                    nextPrecedence = this.type.getPrecedence();
                }
                lhs = this.verifyAssignment(op, lhs, rhs);
            }
            precedence = this.type.getPrecedence();
        }
        return lhs;
    }

    private Node assignmentExpression(boolean noIn) {
        return this.expression(this.unaryExpression(), TokenType.ASSIGN.getPrecedence(), noIn);
    }

    private void endOfLine() {
        switch (this.type) {
            case EOL: 
            case SEMICOLON: {
                this.next();
                break;
            }
            case EOF: 
            case RBRACE: 
            case RPAREN: 
            case RBRACKET: {
                break;
            }
            default: {
                if (this.last == TokenType.EOL) break;
                this.expect(TokenType.SEMICOLON);
            }
        }
    }

    public String toString() {
        return "[JavaScript Parsing]";
    }

    private static void markEval(LexicalContext lc) {
        Iterator<FunctionNode> iter = lc.getFunctions();
        boolean flaggedCurrentFn = false;
        while (iter.hasNext()) {
            FunctionNode fn = iter.next();
            if (!flaggedCurrentFn) {
                lc.setFlag(fn, 32);
                flaggedCurrentFn = true;
            } else {
                lc.setFlag(fn, 64);
            }
            lc.setBlockNeedsScope(lc.getFunctionBody(fn));
        }
    }

    private void prependStatement(Statement statement) {
        this.lc.prependStatement(statement);
    }

    private void appendStatement(Statement statement) {
        this.lc.appendStatement(statement);
    }
}

