/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.util.Collections;
import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

public final class NativeInt32Array
extends ArrayBufferView {
    public static final int BYTES_PER_ELEMENT = 4;
    private static PropertyMap $nasgenmap$;
    private static final ArrayBufferView.Factory FACTORY;

    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeInt32Array.constructorImpl(args, FACTORY);
    }

    NativeInt32Array(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype(Global global) {
        return global.getInt32ArrayPrototype();
    }

    static {
        FACTORY = new ArrayBufferView.Factory(4){

            @Override
            public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new NativeInt32Array(buffer, byteOffset, length);
            }

            @Override
            public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new Int32ArrayData(buffer, byteOffset, length);
            }
        };
        NativeInt32Array.$clinit$();
    }

    public static void $clinit$() {
        $nasgenmap$ = PropertyMap.newMap(Collections.EMPTY_LIST).setIsShared();
    }

    private static final class Int32ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Int32ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 4 + this.byteOffset;
        }

        @Override
        protected int getIntImpl(int index) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            return byteArray[byteIndex] & 0xFF | byteArray[byteIndex + 1] << 8 & 0xFF00 | byteArray[byteIndex + 2] << 16 & 0xFF0000 | byteArray[byteIndex + 3] << 24 & 0xFF000000;
        }

        @Override
        protected void setImpl(int index, int value) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            byteArray[byteIndex] = (byte)(value & 0xFF);
            byteArray[byteIndex + 1] = (byte)(value >>> 8 & 0xFF);
            byteArray[byteIndex + 2] = (byte)(value >>> 16 & 0xFF);
            byteArray[byteIndex + 3] = (byte)(value >>> 24 & 0xFF);
        }
    }
}

