/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.util.Collections;
import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

public final class NativeInt16Array
extends ArrayBufferView {
    private static PropertyMap $nasgenmap$;
    public static final int BYTES_PER_ELEMENT = 2;
    private static final ArrayBufferView.Factory FACTORY;

    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeInt16Array.constructorImpl(args, FACTORY);
    }

    NativeInt16Array(NativeArrayBuffer buffer, int byteOffset, int byteLength) {
        super(buffer, byteOffset, byteLength);
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype(Global global) {
        return global.getInt16ArrayPrototype();
    }

    static {
        FACTORY = new ArrayBufferView.Factory(2){

            @Override
            public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new NativeInt16Array(buffer, byteOffset, length);
            }

            @Override
            public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new Int16ArrayData(buffer, byteOffset, length);
            }
        };
        NativeInt16Array.$clinit$();
    }

    public static void $clinit$() {
        $nasgenmap$ = PropertyMap.newMap(Collections.EMPTY_LIST).setIsShared();
    }

    private static final class Int16ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Int16ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 2 + this.byteOffset;
        }

        @Override
        protected int getIntImpl(int index) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            return byteArray[byteIndex] & 0xFF | byteArray[byteIndex + 1] << 8 & 0xFFFFFF00;
        }

        @Override
        protected void setImpl(int index, int value) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            byteArray[byteIndex] = (byte)(value & 0xFF);
            byteArray[byteIndex + 1] = (byte)(value >>> 8 & 0xFF);
        }
    }
}

