/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

final class NativeArrayBuffer
extends ScriptObject {
    private final byte[] buffer;
    private static PropertyMap $nasgenmap$;

    static PropertyMap getInitialMap() {
        return $nasgenmap$;
    }

    public static Object constructor(boolean newObj, Object self, Object ... args) {
        if (args.length == 0) {
            throw new RuntimeException("missing length argument");
        }
        return new NativeArrayBuffer(JSType.toInt32(args[0]));
    }

    protected NativeArrayBuffer(byte[] byteArray, Global global) {
        super(global.getArrayBufferPrototype(), global.getArrayBufferMap());
        this.buffer = byteArray;
    }

    protected NativeArrayBuffer(byte[] byteArray) {
        this(byteArray, Global.instance());
    }

    protected NativeArrayBuffer(int byteLength) {
        this(new byte[byteLength]);
    }

    protected NativeArrayBuffer(NativeArrayBuffer other, int begin, int end) {
        this(Arrays.copyOfRange(other.buffer, begin, end));
    }

    public static Object byteLength(Object self) {
        return ((NativeArrayBuffer)self).buffer.length;
    }

    public static Object slice(Object self, Object begin0, Object end0) {
        NativeArrayBuffer arrayBuffer = (NativeArrayBuffer)self;
        int begin = JSType.toInt32(begin0);
        int end = end0 != ScriptRuntime.UNDEFINED ? JSType.toInt32(end0) : arrayBuffer.getByteLength();
        begin = NativeArrayBuffer.adjustIndex(begin, arrayBuffer.getByteLength());
        end = NativeArrayBuffer.adjustIndex(end, arrayBuffer.getByteLength());
        return new NativeArrayBuffer((NativeArrayBuffer)self, begin, Math.max(end, begin));
    }

    static int adjustIndex(int index, int length) {
        if (index < 0) {
            return NativeArrayBuffer.clamp(index + length, length);
        }
        return NativeArrayBuffer.clamp(index, length);
    }

    private static int clamp(int index, int length) {
        if (index < 0) {
            return 0;
        }
        if (index > length) {
            return length;
        }
        return index;
    }

    public byte[] getByteArray() {
        return this.buffer;
    }

    public int getByteLength() {
        return this.buffer.length;
    }

    static {
        NativeArrayBuffer.$clinit$();
    }

    public static void $clinit$() {
        ArrayList<Property> arrayList = new ArrayList<Property>(1);
        arrayList.add(AccessorProperty.create("byteLength", 7, cfr_ldc_0(), null));
        $nasgenmap$ = PropertyMap.newMap(arrayList).setIsShared();
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(NativeArrayBuffer.class, "byteLength", MethodType.fromMethodDescriptorString("(Ljava/lang/Object;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }
}

