/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir.debug;

import java.util.List;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

public final class PrintVisitor
extends NodeVisitor<LexicalContext> {
    private static final int TABWIDTH = 4;
    private final StringBuilder sb;
    private int indent;
    private final String EOLN = System.lineSeparator();
    private final boolean printLineNumbers;
    private int lastLineNumber = -1;

    public PrintVisitor() {
        this(true);
    }

    public PrintVisitor(boolean printLineNumbers) {
        super(new LexicalContext());
        this.sb = new StringBuilder();
        this.printLineNumbers = printLineNumbers;
    }

    public PrintVisitor(Node root) {
        this(root, true);
    }

    public PrintVisitor(Node root, boolean printLineNumbers) {
        this(printLineNumbers);
        this.visit(root);
    }

    private void visit(Node root) {
        root.accept(this);
    }

    public String toString() {
        return this.sb.append(this.EOLN).toString();
    }

    private void indent() {
        for (int i = this.indent; i > 0; --i) {
            this.sb.append(' ');
        }
    }

    @Override
    public boolean enterDefault(Node node) {
        node.toString(this.sb);
        return false;
    }

    @Override
    public boolean enterBlock(Block block) {
        this.sb.append(' ');
        this.sb.append('{');
        this.indent += 4;
        List<Statement> statements = block.getStatements();
        for (Node node : statements) {
            if (this.printLineNumbers && node instanceof Statement) {
                int lineNumber = ((Statement)node).getLineNumber();
                this.sb.append('\n');
                if (lineNumber != this.lastLineNumber) {
                    this.indent();
                    this.sb.append("[|").append(lineNumber).append("|];").append('\n');
                }
                this.lastLineNumber = lineNumber;
            }
            this.indent();
            node.accept(this);
            if (node instanceof FunctionNode) continue;
            Symbol symbol = node.getSymbol();
            if (symbol != null) {
                this.sb.append("  [");
                this.sb.append(symbol.toString());
                this.sb.append(']');
            }
            int lastIndex = this.sb.length() - 1;
            char lastChar = this.sb.charAt(lastIndex);
            while (Character.isWhitespace(lastChar) && lastIndex >= 0) {
                lastChar = this.sb.charAt(--lastIndex);
            }
            if (lastChar != '}' && lastChar != ';') {
                this.sb.append(';');
            }
            if (node.hasGoto()) {
                this.sb.append(" [GOTO]");
            }
            if (!node.isTerminal()) continue;
            this.sb.append(" [TERMINAL]");
        }
        this.indent -= 4;
        this.sb.append(this.EOLN);
        this.indent();
        this.sb.append('}');
        return false;
    }

    @Override
    public boolean enterBinaryNode(BinaryNode binaryNode) {
        binaryNode.lhs().accept(this);
        this.sb.append(' ');
        this.sb.append((Object)binaryNode.tokenType());
        this.sb.append(' ');
        binaryNode.rhs().accept(this);
        return false;
    }

    @Override
    public boolean enterExecuteNode(ExecuteNode executeNode) {
        executeNode.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean enterForNode(ForNode forNode) {
        forNode.toString(this.sb);
        forNode.getBody().accept(this);
        return false;
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        functionNode.toString(this.sb);
        this.enterBlock(functionNode.getBody());
        return false;
    }

    @Override
    public boolean enterIfNode(IfNode ifNode) {
        ifNode.toString(this.sb);
        ifNode.getPass().accept(this);
        Block fail = ifNode.getFail();
        if (fail != null) {
            this.sb.append(" else ");
            fail.accept(this);
        }
        return false;
    }

    @Override
    public boolean enterLabelNode(LabelNode labeledNode) {
        this.indent -= 4;
        this.indent();
        this.indent += 4;
        labeledNode.toString(this.sb);
        labeledNode.getBody().accept(this);
        return false;
    }

    @Override
    public boolean enterSplitNode(SplitNode splitNode) {
        splitNode.toString(this.sb);
        this.sb.append(this.EOLN);
        this.indent += 4;
        this.indent();
        return true;
    }

    @Override
    public Node leaveSplitNode(SplitNode splitNode) {
        this.sb.append("</split>");
        this.sb.append(this.EOLN);
        this.indent -= 4;
        this.indent();
        return splitNode;
    }

    @Override
    public boolean enterSwitchNode(SwitchNode switchNode) {
        switchNode.toString(this.sb);
        this.sb.append(" {");
        List<CaseNode> cases = switchNode.getCases();
        for (CaseNode caseNode : cases) {
            this.sb.append(this.EOLN);
            this.indent();
            caseNode.toString(this.sb);
            this.indent += 4;
            caseNode.getBody().accept(this);
            this.indent -= 4;
            this.sb.append(this.EOLN);
        }
        this.sb.append(this.EOLN);
        this.indent();
        this.sb.append("}");
        return false;
    }

    @Override
    public boolean enterTryNode(TryNode tryNode) {
        tryNode.toString(this.sb);
        tryNode.getBody().accept(this);
        List<Block> catchBlocks = tryNode.getCatchBlocks();
        for (Block catchBlock : catchBlocks) {
            CatchNode catchNode = (CatchNode)catchBlock.getStatements().get(0);
            catchNode.toString(this.sb);
            catchNode.getBody().accept(this);
        }
        Block finallyBody = tryNode.getFinallyBody();
        if (finallyBody != null) {
            this.sb.append(" finally ");
            finallyBody.accept(this);
        }
        return false;
    }

    @Override
    public boolean enterVarNode(VarNode varNode) {
        this.sb.append("var ");
        varNode.getName().toString(this.sb);
        Node init = varNode.getInit();
        if (init != null) {
            this.sb.append(" = ");
            init.accept(this);
        }
        return false;
    }

    @Override
    public boolean enterWhileNode(WhileNode whileNode) {
        if (whileNode.isDoWhile()) {
            this.sb.append("do");
            whileNode.getBody().accept(this);
            this.sb.append(' ');
            whileNode.toString(this.sb);
        } else {
            whileNode.toString(this.sb);
            whileNode.getBody().accept(this);
        }
        return false;
    }

    @Override
    public boolean enterWithNode(WithNode withNode) {
        withNode.toString(this.sb);
        withNode.getBody().accept(this);
        return false;
    }
}

