/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class ThrowNode
extends Statement {
    private final Node expression;
    private final int flags;
    public static final int IS_SYNTHETIC_RETHROW = 1;

    public ThrowNode(int lineNumber, long token, int finish, Node expression, int flags) {
        super(lineNumber, token, finish);
        this.expression = expression;
        this.flags = flags;
    }

    private ThrowNode(ThrowNode node, Node expression, int flags) {
        super(node);
        this.expression = expression;
        this.flags = flags;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterThrowNode(this)) {
            return visitor.leaveThrowNode(this.setExpression(this.expression.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("throw ");
        if (this.expression != null) {
            this.expression.toString(sb);
        }
    }

    public Node getExpression() {
        return this.expression;
    }

    public ThrowNode setExpression(Node expression) {
        if (this.expression == expression) {
            return this;
        }
        return new ThrowNode(this, expression, this.flags);
    }

    public boolean isSyntheticRethrow() {
        return (this.flags & 1) == 1;
    }
}

