/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class TernaryNode
extends Node {
    private final Node lhs;
    private final Node rhs;
    private final Node third;

    public TernaryNode(long token, Node lhs, Node rhs, Node third) {
        super(token, third.getFinish());
        this.lhs = lhs;
        this.rhs = rhs;
        this.third = third;
    }

    private TernaryNode(TernaryNode ternaryNode, Node lhs, Node rhs, Node third) {
        super(ternaryNode);
        this.lhs = lhs;
        this.rhs = rhs;
        this.third = third;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterTernaryNode(this)) {
            Node newLhs = this.lhs().accept(visitor);
            Node newRhs = this.rhs().accept(visitor);
            Node newThird = this.third.accept(visitor);
            return visitor.leaveTernaryNode(this.setThird(newThird).setLHS(newLhs).setRHS(newRhs));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean lhsParen = this.tokenType().needsParens(this.lhs().tokenType(), true);
        boolean rhsParen = this.tokenType().needsParens(this.rhs().tokenType(), false);
        boolean thirdParen = this.tokenType().needsParens(this.third().tokenType(), false);
        if (lhsParen) {
            sb.append('(');
        }
        this.lhs().toString(sb);
        if (lhsParen) {
            sb.append(')');
        }
        sb.append(" ? ");
        if (rhsParen) {
            sb.append('(');
        }
        this.rhs().toString(sb);
        if (rhsParen) {
            sb.append(')');
        }
        sb.append(" : ");
        if (thirdParen) {
            sb.append('(');
        }
        this.third().toString(sb);
        if (thirdParen) {
            sb.append(')');
        }
    }

    public Node lhs() {
        return this.lhs;
    }

    public Node rhs() {
        return this.rhs;
    }

    public Node third() {
        return this.third;
    }

    public TernaryNode setLHS(Node lhs) {
        if (this.lhs == lhs) {
            return this;
        }
        return new TernaryNode(this, lhs, this.rhs, this.third);
    }

    public TernaryNode setRHS(Node rhs) {
        if (this.rhs == rhs) {
            return this;
        }
        return new TernaryNode(this, this.lhs, rhs, this.third);
    }

    public TernaryNode setThird(Node third) {
        if (this.third == third) {
            return this;
        }
        return new TernaryNode(this, this.lhs, this.rhs, third);
    }
}

