/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public class SplitNode
extends LexicalContextNode {
    private final String name;
    private final CompileUnit compileUnit;
    private final Node body;

    public SplitNode(int lineNumber, String name, Node body, CompileUnit compileUnit) {
        super(lineNumber, body.getToken(), body.getFinish());
        this.name = name;
        this.body = body;
        this.compileUnit = compileUnit;
    }

    private SplitNode(SplitNode splitNode, Node body) {
        super(splitNode);
        this.name = splitNode.name;
        this.body = body;
        this.compileUnit = splitNode.compileUnit;
    }

    public Node getBody() {
        return this.body;
    }

    private SplitNode setBody(LexicalContext lc, Node body) {
        if (this.body == body) {
            return this;
        }
        return Node.replaceInLexicalContext(lc, this, new SplitNode(this, body));
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterSplitNode(this)) {
            return visitor.leaveSplitNode(this.setBody(lc, this.body.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("<split>(");
        sb.append(this.compileUnit.getClass().getSimpleName());
        sb.append(") ");
        this.body.toString(sb);
    }

    public String getName() {
        return this.name;
    }

    public CompileUnit getCompileUnit() {
        return this.compileUnit;
    }
}

