/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class IndexNode
extends BaseNode {
    private final Node index;

    public IndexNode(long token, int finish, Node base, Node index) {
        super(token, finish, base, false, false);
        this.index = index;
    }

    private IndexNode(IndexNode indexNode, Node base, Node index, boolean isFunction, boolean hasCallSiteType) {
        super(indexNode, base, isFunction, hasCallSiteType);
        this.index = index;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterIndexNode(this)) {
            return visitor.leaveIndexNode(this.setBase(this.base.accept(visitor)).setIndex(this.index.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean needsParen = this.tokenType().needsParens(this.base.tokenType(), true);
        if (this.hasCallSiteType()) {
            sb.append('{');
            String desc = this.getType().getDescriptor();
            sb.append(desc.charAt(desc.length() - 1) == ';' ? "O" : this.getType().getDescriptor());
            sb.append('}');
        }
        if (needsParen) {
            sb.append('(');
        }
        this.base.toString(sb);
        if (needsParen) {
            sb.append(')');
        }
        sb.append('[');
        this.index.toString(sb);
        sb.append(']');
    }

    public Node getIndex() {
        return this.index;
    }

    private IndexNode setBase(Node base) {
        if (this.base == base) {
            return this;
        }
        return new IndexNode(this, base, this.index, this.isFunction(), this.hasCallSiteType());
    }

    public IndexNode setIndex(Node index) {
        if (this.index == index) {
            return this;
        }
        return new IndexNode(this, this.base, index, this.isFunction(), this.hasCallSiteType());
    }

    @Override
    public BaseNode setIsFunction() {
        if (this.isFunction()) {
            return this;
        }
        return new IndexNode(this, this.base, this.index, true, this.hasCallSiteType());
    }

    @Override
    public IndexNode setType(TemporarySymbols ts, LexicalContext lc, Type type) {
        this.logTypeChange(type);
        IndexNode newIndexNode = (IndexNode)this.setSymbol(lc, this.getSymbol().setTypeOverrideShared(type, ts));
        return new IndexNode(newIndexNode, this.base, this.index, this.isFunction(), true);
    }
}

