/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class ExecuteNode
extends Statement {
    private final Node expression;

    public ExecuteNode(int lineNumber, long token, int finish, Node expression) {
        super(lineNumber, token, finish);
        this.expression = expression;
    }

    private ExecuteNode(ExecuteNode executeNode, Node expression) {
        super(executeNode);
        this.expression = expression;
    }

    @Override
    public boolean isTerminal() {
        return this.expression.isTerminal();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterExecuteNode(this)) {
            return visitor.leaveExecuteNode(this.setExpression(this.expression.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        this.expression.toString(sb);
    }

    public Node getExpression() {
        return this.expression;
    }

    public ExecuteNode setExpression(Node expression) {
        if (this.expression == expression) {
            return this;
        }
        return new ExecuteNode(this, expression);
    }
}

