/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class CallNode
extends LexicalContextNode
implements TypeOverride<CallNode> {
    private final Type type;
    private final Node function;
    private final List<Node> args;
    public static final int IS_NEW = 1;
    private final int flags;
    @Ignore
    private final EvalArgs evalArgs;

    public CallNode(int lineNumber, long token, int finish, Node function, List<Node> args) {
        super(lineNumber, token, finish);
        this.function = function;
        this.args = args;
        this.flags = 0;
        this.type = null;
        this.evalArgs = null;
    }

    private CallNode(CallNode callNode, Node function, List<Node> args, int flags, Type type, EvalArgs evalArgs) {
        super(callNode);
        this.function = function;
        this.args = args;
        this.flags = flags;
        this.type = type;
        this.evalArgs = evalArgs;
    }

    @Override
    public Type getType() {
        if (this.hasCallSiteType()) {
            return this.type;
        }
        return this.function instanceof FunctionNode ? ((FunctionNode)this.function).getReturnType() : Type.OBJECT;
    }

    @Override
    public CallNode setType(TemporarySymbols ts, LexicalContext lc, Type type) {
        if (this.type == type) {
            return this;
        }
        return new CallNode(this, this.function, this.args, this.flags, type, this.evalArgs);
    }

    private boolean hasCallSiteType() {
        return this.type != null;
    }

    @Override
    public boolean canHaveCallSiteType() {
        return true;
    }

    @Override
    public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
        CallNode newCallNode;
        if (visitor.enterCallNode(this) && this != (newCallNode = (CallNode)visitor.leaveCallNode(this.setFunction(this.function.accept(visitor)).setArgs(Node.accept(visitor, Node.class, this.args)).setFlags(this.flags).setType(null, lc, this.type).setEvalArgs(this.evalArgs == null ? null : this.evalArgs.setCode(this.evalArgs.getCode().accept(visitor)).setThis((IdentNode)this.evalArgs.getThis().accept(visitor)))))) {
            return Node.replaceInLexicalContext(lc, this, newCallNode);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.hasCallSiteType()) {
            sb.append('{');
            String desc = this.getType().getDescriptor();
            sb.append(desc.charAt(desc.length() - 1) == ';' ? Character.valueOf('O') : this.getType().getDescriptor());
            sb.append('}');
        }
        this.function.toString(sb);
        sb.append('(');
        boolean first = true;
        for (Node arg : this.args) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            arg.toString(sb);
        }
        sb.append(')');
    }

    public List<Node> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    private CallNode setArgs(List<Node> args) {
        if (this.args == args) {
            return this;
        }
        return new CallNode(this, this.function, args, this.flags, this.type, this.evalArgs);
    }

    public EvalArgs getEvalArgs() {
        return this.evalArgs;
    }

    public CallNode setEvalArgs(EvalArgs evalArgs) {
        if (this.evalArgs == evalArgs) {
            return this;
        }
        return new CallNode(this, this.function, this.args, this.flags, this.type, evalArgs);
    }

    public boolean isEval() {
        return this.evalArgs != null;
    }

    public Node getFunction() {
        return this.function;
    }

    public CallNode setFunction(Node function) {
        if (this.function == function) {
            return this;
        }
        return new CallNode(this, function, this.args, this.flags, this.type, this.evalArgs);
    }

    public boolean isNew() {
        return (this.flags & 1) == 1;
    }

    public CallNode setIsNew() {
        return this.setFlags(1);
    }

    private CallNode setFlags(int flags) {
        if (this.flags == flags) {
            return this;
        }
        return new CallNode(this, this.function, this.args, flags, this.type, this.evalArgs);
    }

    public static class EvalArgs {
        private final Node code;
        private final IdentNode evalThis;
        private final String location;
        private final boolean strictMode;

        public EvalArgs(Node code, IdentNode evalThis, String location, boolean strictMode) {
            this.code = code;
            this.evalThis = evalThis;
            this.location = location;
            this.strictMode = strictMode;
        }

        public Node getCode() {
            return this.code;
        }

        private EvalArgs setCode(Node code) {
            if (this.code == code) {
                return this;
            }
            return new EvalArgs(code, this.evalThis, this.location, this.strictMode);
        }

        public IdentNode getThis() {
            return this.evalThis;
        }

        private EvalArgs setThis(IdentNode evalThis) {
            if (this.evalThis == evalThis) {
                return this;
            }
            return new EvalArgs(this.code, evalThis, this.location, this.strictMode);
        }

        public String getLocation() {
            return this.location;
        }

        public boolean getStrictMode() {
            return this.strictMode;
        }
    }
}

