/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionCall;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.annotations.Immutable;

@Immutable
public abstract class BaseNode
extends Node
implements FunctionCall,
TypeOverride<BaseNode> {
    protected final Node base;
    private final boolean isFunction;
    private final boolean hasCallSiteType;

    public BaseNode(long token, int finish, Node base, boolean isFunction, boolean hasCallSiteType) {
        super(token, base.getStart(), finish);
        this.base = base;
        this.isFunction = isFunction;
        this.hasCallSiteType = hasCallSiteType;
    }

    protected BaseNode(BaseNode baseNode, Node base, boolean isFunction, boolean hasCallSiteType) {
        super(baseNode);
        this.base = base;
        this.isFunction = isFunction;
        this.hasCallSiteType = hasCallSiteType;
    }

    public Node getBase() {
        return this.base;
    }

    @Override
    public boolean isFunction() {
        return this.isFunction;
    }

    public abstract BaseNode setIsFunction();

    @Override
    public boolean canHaveCallSiteType() {
        return true;
    }

    protected boolean hasCallSiteType() {
        return this.hasCallSiteType;
    }

    protected final void logTypeChange(Type type) {
        if (ObjectClassGenerator.DEBUG_FIELDS && !Type.areEquivalent(this.getSymbol().getSymbolType(), type)) {
            ObjectClassGenerator.LOG.info(this.getClass().getName(), " ", this, " => ", type, " instead of ", this.getType());
        }
    }
}

