/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class AccessNode
extends BaseNode {
    private final IdentNode property;

    public AccessNode(long token, int finish, Node base, IdentNode property) {
        super(token, finish, base, false, false);
        this.property = property.setIsPropertyName();
    }

    private AccessNode(AccessNode accessNode, Node base, IdentNode property, boolean isFunction, boolean hasCallSiteType) {
        super(accessNode, base, isFunction, hasCallSiteType);
        this.property = property;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterAccessNode(this)) {
            return visitor.leaveAccessNode(this.setBase(this.base.accept(visitor)).setProperty((IdentNode)this.property.accept(visitor)));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean needsParen = this.tokenType().needsParens(this.getBase().tokenType(), true);
        if (this.hasCallSiteType()) {
            sb.append('{');
            String desc = this.getType().getDescriptor();
            sb.append(desc.charAt(desc.length() - 1) == ';' ? "O" : this.getType().getDescriptor());
            sb.append('}');
        }
        if (needsParen) {
            sb.append('(');
        }
        this.base.toString(sb);
        if (needsParen) {
            sb.append(')');
        }
        sb.append('.');
        sb.append(this.property.getName());
    }

    public IdentNode getProperty() {
        return this.property;
    }

    private AccessNode setBase(Node base) {
        if (this.base == base) {
            return this;
        }
        return new AccessNode(this, base, this.property, this.isFunction(), this.hasCallSiteType());
    }

    private AccessNode setProperty(IdentNode property) {
        if (this.property == property) {
            return this;
        }
        return new AccessNode(this, this.base, property, this.isFunction(), this.hasCallSiteType());
    }

    @Override
    public AccessNode setType(TemporarySymbols ts, LexicalContext lc, Type type) {
        this.logTypeChange(type);
        AccessNode newAccessNode = (AccessNode)this.setSymbol(lc, this.getSymbol().setTypeOverrideShared(type, ts));
        return new AccessNode(newAccessNode, this.base, this.property.setType(ts, lc, type), this.isFunction(), this.hasCallSiteType());
    }

    @Override
    public BaseNode setIsFunction() {
        if (this.isFunction()) {
            return this;
        }
        return new AccessNode(this, this.base, this.property, true, this.hasCallSiteType());
    }
}

