/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.types;

import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.BitwiseType;
import jdk.nashorn.internal.codegen.types.Type;

class LongType
extends BitwiseType {
    private static final CompilerConstants.Call VALUE_OF = CompilerConstants.staticCallNoLookup(Long.class, "valueOf", Long.class, Long.TYPE);

    protected LongType(String name) {
        super(name, Long.TYPE, 3, 2);
    }

    protected LongType() {
        this("long");
    }

    @Override
    public Type nextWider() {
        return NUMBER;
    }

    @Override
    public Class<?> getBoxedType() {
        return Long.class;
    }

    @Override
    public Type cmp(MethodVisitor method) {
        method.visitInsn(148);
        return INT;
    }

    @Override
    public Type load(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(22, slot);
        return LONG;
    }

    @Override
    public void store(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(55, slot);
    }

    @Override
    public Type ldc(MethodVisitor method, Object c) {
        assert (c instanceof Long);
        long value = (Long)c;
        if (value == 0L) {
            method.visitInsn(9);
        } else if (value == 1L) {
            method.visitInsn(10);
        } else {
            method.visitLdcInsn(c);
        }
        return Type.LONG;
    }

    @Override
    public Type convert(MethodVisitor method, Type to) {
        if (this.isEquivalentTo(to)) {
            return to;
        }
        if (to.isNumber()) {
            method.visitInsn(138);
        } else if (to.isInteger()) {
            method.visitInsn(136);
        } else if (to.isBoolean()) {
            method.visitInsn(136);
        } else if (to.isObject()) {
            LongType.invokeStatic(method, VALUE_OF);
        } else assert (false) : "Illegal conversion " + this + " -> " + to;
        return to;
    }

    @Override
    public Type add(MethodVisitor method) {
        method.visitInsn(97);
        return LONG;
    }

    @Override
    public Type sub(MethodVisitor method) {
        method.visitInsn(101);
        return LONG;
    }

    @Override
    public Type mul(MethodVisitor method) {
        method.visitInsn(105);
        return LONG;
    }

    @Override
    public Type div(MethodVisitor method) {
        method.visitInsn(109);
        return LONG;
    }

    @Override
    public Type rem(MethodVisitor method) {
        method.visitInsn(113);
        return LONG;
    }

    @Override
    public Type shr(MethodVisitor method) {
        method.visitInsn(125);
        return LONG;
    }

    @Override
    public Type sar(MethodVisitor method) {
        method.visitInsn(123);
        return LONG;
    }

    @Override
    public Type shl(MethodVisitor method) {
        method.visitInsn(121);
        return LONG;
    }

    @Override
    public Type and(MethodVisitor method) {
        method.visitInsn(127);
        return LONG;
    }

    @Override
    public Type or(MethodVisitor method) {
        method.visitInsn(129);
        return LONG;
    }

    @Override
    public Type xor(MethodVisitor method) {
        method.visitInsn(131);
        return LONG;
    }

    @Override
    public Type neg(MethodVisitor method) {
        method.visitInsn(117);
        return LONG;
    }

    @Override
    public void _return(MethodVisitor method) {
        method.visitInsn(173);
    }

    @Override
    public Type loadUndefined(MethodVisitor method) {
        method.visitLdcInsn(0L);
        return LONG;
    }

    @Override
    public Type cmp(MethodVisitor method, boolean isCmpG) {
        return this.cmp(method);
    }
}

