/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.List;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.MapCreator;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.ObjectCreator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.scripts.JO;

public class SpillObjectCreator
extends ObjectCreator {
    private final List<Node> values;

    protected SpillObjectCreator(CodeGenerator codegen, List<String> keys, List<Symbol> symbols, List<Node> values) {
        super(codegen, keys, symbols, false, false);
        this.values = values;
        this.makeMap();
    }

    @Override
    protected void makeObject(MethodEmitter method) {
        Property property;
        String key;
        int i;
        assert (!this.isScope()) : "spill scope objects are not currently supported";
        int length = this.keys.size();
        Object[] presetValues = new Object[this.propertyMap.size()];
        Class<JO> clazz = JO.class;
        for (i = 0; i < length; ++i) {
            key = (String)this.keys.get(i);
            property = this.propertyMap.findProperty(key);
            if (property == null) continue;
            presetValues[property.getSlot()] = LiteralNode.objectAsConstant(this.values.get(i));
        }
        method._new(clazz).dup();
        this.codegen.loadConstant(this.propertyMap);
        method.invoke(CompilerConstants.constructorNoLookup(JO.class, PropertyMap.class));
        method.dup();
        this.codegen.loadConstant(presetValues);
        for (i = 0; i < length; ++i) {
            key = (String)this.keys.get(i);
            property = this.propertyMap.findProperty(key);
            if (property == null || presetValues[property.getSlot()] != LiteralNode.POSTSET_MARKER) continue;
            method.dup();
            method.load(property.getSlot());
            this.codegen.load(this.values.get(i)).convert(Type.OBJECT);
            method.arraystore();
            presetValues[property.getSlot()] = null;
        }
        method.putField(Type.typeFor(ScriptObject.class).getInternalName(), "spill", Type.OBJECT_ARRAY.getDescriptor());
        int callSiteFlags = this.codegen.getCallSiteFlags();
        for (int i2 = 0; i2 < length; ++i2) {
            String key2 = (String)this.keys.get(i2);
            Property property2 = this.propertyMap.findProperty(key2);
            Node value = this.values.get(i2);
            if (property2 != null || value == null) continue;
            method.dup();
            method.load((String)this.keys.get(i2));
            this.codegen.load(value);
            method.dynamicSetIndex(callSiteFlags);
        }
    }

    @Override
    protected PropertyMap makeMap() {
        assert (this.propertyMap == null) : "property map already initialized";
        this.propertyMap = new MapCreator(JO.class, this.keys, this.symbols){

            @Override
            protected int getPropertyFlags(Symbol symbol, boolean hasArguments) {
                return super.getPropertyFlags(symbol, hasArguments) | 0x10 | 0x80;
            }
        }.makeSpillMap(false);
        return this.propertyMap;
    }
}

