/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jdk.nashorn.internal.codegen.types.Range;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.LoopNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.DebugLogger;

final class RangeAnalyzer
extends NodeOperatorVisitor<LexicalContext> {
    static final DebugLogger LOG = new DebugLogger("ranges");
    private static final Range.Functionality RANGE = new Range.Functionality(LOG);
    private final Map<LoopNode, Symbol> loopCounters = new HashMap<LoopNode, Symbol>();

    RangeAnalyzer() {
        super(new LexicalContext());
    }

    @Override
    public boolean enterForNode(ForNode forNode) {
        Symbol counter = RangeAnalyzer.findLoopCounter(forNode);
        LOG.fine("Entering forNode " + forNode + " counter = " + counter);
        if (counter != null && !RangeAnalyzer.assignedInLoop(forNode, counter)) {
            this.loopCounters.put(forNode, counter);
        }
        return true;
    }

    private Symbol setRange(Node dest, Range range) {
        if (range.isUnknown()) {
            return null;
        }
        Symbol symbol = dest.getSymbol();
        assert (symbol != null) : dest + " " + dest.getClass() + " has no symbol";
        assert (symbol.getRange() != null) : symbol + " has no range";
        Range symRange = RANGE.join(symbol.getRange(), range);
        if (this.lc.inLoop() && !this.isLoopCounter(this.lc.getCurrentLoop(), symbol)) {
            symbol.setRange(Range.createGenericRange());
            return symbol;
        }
        if (!symRange.equals(symbol.getRange())) {
            LOG.fine("Modify range for " + dest + " " + symbol + " from " + symbol.getRange() + " to " + symRange + " (in node = " + dest + ")");
            symbol.setRange(symRange);
        }
        return null;
    }

    @Override
    public Node leaveADD(BinaryNode node) {
        this.setRange(node, RANGE.add(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveSUB(BinaryNode node) {
        this.setRange(node, RANGE.sub(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveMUL(BinaryNode node) {
        this.setRange(node, RANGE.mul(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveDIV(BinaryNode node) {
        this.setRange(node, RANGE.div(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveMOD(BinaryNode node) {
        this.setRange(node, RANGE.mod(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveBIT_AND(BinaryNode node) {
        this.setRange(node, RANGE.and(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveBIT_OR(BinaryNode node) {
        this.setRange(node, RANGE.or(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveBIT_XOR(BinaryNode node) {
        this.setRange(node, RANGE.xor(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveSAR(BinaryNode node) {
        this.setRange(node, RANGE.sar(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveSHL(BinaryNode node) {
        this.setRange(node, RANGE.shl(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveSHR(BinaryNode node) {
        this.setRange(node, RANGE.shr(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
        return node;
    }

    private Node leaveCmp(BinaryNode node) {
        this.setRange(node, Range.createTypeRange(Type.BOOLEAN));
        return node;
    }

    @Override
    public Node leaveEQ(BinaryNode node) {
        return this.leaveCmp(node);
    }

    @Override
    public Node leaveEQ_STRICT(BinaryNode node) {
        return this.leaveCmp(node);
    }

    @Override
    public Node leaveNE(BinaryNode node) {
        return this.leaveCmp(node);
    }

    @Override
    public Node leaveNE_STRICT(BinaryNode node) {
        return this.leaveCmp(node);
    }

    @Override
    public Node leaveLT(BinaryNode node) {
        return this.leaveCmp(node);
    }

    @Override
    public Node leaveLE(BinaryNode node) {
        return this.leaveCmp(node);
    }

    @Override
    public Node leaveGT(BinaryNode node) {
        return this.leaveCmp(node);
    }

    @Override
    public Node leaveGE(BinaryNode node) {
        return this.leaveCmp(node);
    }

    @Override
    public Node leaveASSIGN(BinaryNode node) {
        Range range = node.rhs().getSymbol().getRange();
        if (range.isUnknown()) {
            range = Range.createGenericRange();
        }
        this.setRange(node.lhs(), range);
        this.setRange(node, range);
        return node;
    }

    private Node leaveSelfModifyingAssign(BinaryNode node, Range range) {
        this.setRange(node.lhs(), range);
        this.setRange(node, range);
        return node;
    }

    private Node leaveSelfModifyingAssign(UnaryNode node, Range range) {
        this.setRange(node.rhs(), range);
        this.setRange(node, range);
        return node;
    }

    @Override
    public Node leaveASSIGN_ADD(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.add(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveASSIGN_SUB(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.sub(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveASSIGN_MUL(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.mul(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveASSIGN_DIV(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, Range.createTypeRange(Type.NUMBER));
    }

    @Override
    public Node leaveASSIGN_MOD(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, Range.createTypeRange(Type.NUMBER));
    }

    @Override
    public Node leaveASSIGN_BIT_AND(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.and(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveASSIGN_BIT_OR(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.or(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveASSIGN_BIT_XOR(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.xor(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveASSIGN_SAR(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.sar(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveASSIGN_SHR(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.shr(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveASSIGN_SHL(BinaryNode node) {
        return this.leaveSelfModifyingAssign(node, RANGE.shl(node.lhs().getSymbol().getRange(), node.rhs().getSymbol().getRange()));
    }

    @Override
    public Node leaveDECINC(UnaryNode node) {
        switch (node.tokenType()) {
            case DECPREFIX: 
            case DECPOSTFIX: {
                return this.leaveSelfModifyingAssign(node, RANGE.sub(node.rhs().getSymbol().getRange(), Range.createRange(1)));
            }
            case INCPREFIX: 
            case INCPOSTFIX: {
                return this.leaveSelfModifyingAssign(node, RANGE.add(node.rhs().getSymbol().getRange(), Range.createRange(1)));
            }
        }
        assert (false);
        return node;
    }

    @Override
    public Node leaveADD(UnaryNode node) {
        Range range = node.rhs().getSymbol().getRange();
        if (!range.getType().isNumeric()) {
            range = Range.createTypeRange(Type.NUMBER);
        }
        this.setRange(node, range);
        return node;
    }

    @Override
    public Node leaveBIT_NOT(UnaryNode node) {
        this.setRange(node, Range.createTypeRange(Type.INT));
        return node;
    }

    @Override
    public Node leaveNOT(UnaryNode node) {
        this.setRange(node, Range.createTypeRange(Type.BOOLEAN));
        return node;
    }

    @Override
    public Node leaveSUB(UnaryNode node) {
        this.setRange(node, RANGE.neg(node.rhs().getSymbol().getRange()));
        return node;
    }

    @Override
    public Node leaveVarNode(VarNode node) {
        if (node.isAssignment()) {
            Range range = node.getInit().getSymbol().getRange();
            range = range.isUnknown() ? Range.createGenericRange() : range;
            this.setRange(node.getName(), range);
            this.setRange(node, range);
        }
        return node;
    }

    @Override
    public boolean enterLiteralNode(LiteralNode node) {
        return !(node instanceof LiteralNode.ArrayLiteralNode);
    }

    @Override
    public Node leaveLiteralNode(LiteralNode node) {
        if (node.getType().isInteger()) {
            this.setRange(node, Range.createRange(node.getInt32()));
        } else if (node.getType().isNumber()) {
            this.setRange(node, Range.createRange(node.getNumber()));
        } else if (node.getType().isLong()) {
            this.setRange(node, Range.createRange(node.getLong()));
        } else if (node.getType().isBoolean()) {
            this.setRange(node, Range.createTypeRange(Type.BOOLEAN));
        } else {
            this.setRange(node, Range.createGenericRange());
        }
        return node;
    }

    @Override
    public boolean enterRuntimeNode(RuntimeNode node) {
        return node.getRequest().canSpecialize();
    }

    private static boolean assignedInLoop(LoopNode loopNode, final Symbol symbol) {
        final HashSet skip = new HashSet();
        final HashSet assignmentsInLoop = new HashSet();
        loopNode.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            private boolean assigns(Node node, Symbol s) {
                return node.isAssignment() && ((Node)((Assignment)((Object)node)).getAssignmentDest()).getSymbol() == s;
            }

            @Override
            public boolean enterForNode(ForNode forNode) {
                if (forNode.getInit() != null) {
                    skip.add(forNode.getInit());
                }
                if (forNode.getModify() != null) {
                    skip.add(forNode.getModify());
                }
                return true;
            }

            @Override
            public Node leaveDefault(Node node) {
                if (!skip.contains(node) && this.assigns(node, symbol)) {
                    assignmentsInLoop.add(node);
                }
                return node;
            }
        });
        return !assignmentsInLoop.isEmpty();
    }

    private static Symbol findLoopCounter(LoopNode node) {
        Node test = node.getTest();
        if (test != null && test.isComparison()) {
            BinaryNode binaryNode = (BinaryNode)test;
            Node lhs = binaryNode.lhs();
            Node rhs = binaryNode.rhs();
            if (lhs instanceof IdentNode && rhs instanceof LiteralNode && ((LiteralNode)rhs).getType().isInteger()) {
                Symbol symbol = lhs.getSymbol();
                int margin = ((LiteralNode)rhs).getInt32();
                TokenType op = test.tokenType();
                switch (op) {
                    case LT: 
                    case LE: {
                        symbol.setRange(RANGE.join(symbol.getRange(), Range.createRange(op == TokenType.LT ? margin - 1 : margin)));
                        return symbol;
                    }
                }
            }
        }
        return null;
    }

    private boolean isLoopCounter(LoopNode loopNode, Symbol symbol) {
        return this.loopCounters.get(loopNode) == symbol;
    }
}

