/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.Debug;

public final class Label {
    private final String name;
    private Stack stack;
    private jdk.internal.org.objectweb.asm.Label label;

    public Label(String name) {
        this.name = name;
    }

    public Label(Label label) {
        this.name = label.name;
    }

    jdk.internal.org.objectweb.asm.Label getLabel() {
        if (this.label == null) {
            this.label = new jdk.internal.org.objectweb.asm.Label();
        }
        return this.label;
    }

    Stack getStack() {
        return this.stack;
    }

    void setStack(Stack stack) {
        this.stack = stack;
    }

    public String toString() {
        return this.name + '_' + Debug.id(this);
    }

    static final class Stack {
        Type[] data = new Type[8];
        int sp = 0;

        Stack() {
        }

        private Stack(Type[] type, int sp) {
            this();
            this.data = new Type[type.length];
            this.sp = sp;
            for (int i = 0; i < sp; ++i) {
                this.data[i] = type[i];
            }
        }

        boolean isEmpty() {
            return this.sp == 0;
        }

        int size() {
            return this.sp;
        }

        boolean isEquivalentTo(Stack other) {
            if (this.sp != other.sp) {
                return false;
            }
            for (int i = 0; i < this.sp; ++i) {
                if (this.data[i].isEquivalentTo(other.data[i])) continue;
                return false;
            }
            return true;
        }

        void clear() {
            this.sp = 0;
        }

        void push(Type type) {
            if (this.data.length == this.sp) {
                Type[] newData = new Type[this.sp * 2];
                for (int i = 0; i < this.sp; ++i) {
                    newData[i] = this.data[i];
                }
                this.data = newData;
            }
            this.data[this.sp++] = type;
        }

        Type peek() {
            return this.peek(0);
        }

        Type peek(int n) {
            int pos = this.sp - 1 - n;
            return pos < 0 ? null : this.data[pos];
        }

        Type pop() {
            return this.data[--this.sp];
        }

        Stack copy() {
            return new Stack(this.data, this.sp);
        }
    }
}

