/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.FoldConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TypeOverride;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.JSType;

final class FinalizeTypes
extends NodeOperatorVisitor<LexicalContext> {
    private static final DebugLogger LOG = new DebugLogger("finalize");
    private final TemporarySymbols temporarySymbols;

    FinalizeTypes(TemporarySymbols temporarySymbols) {
        super(new LexicalContext());
        this.temporarySymbols = temporarySymbols;
    }

    @Override
    public Node leaveCallNode(CallNode callNode) {
        Node function = callNode.getFunction();
        if (function instanceof FunctionNode) {
            return this.setTypeOverride(callNode, ((FunctionNode)function).getReturnType());
        }
        return callNode;
    }

    private Node leaveUnary(UnaryNode unaryNode) {
        return unaryNode.setRHS(this.convert(unaryNode.rhs(), unaryNode.getType()));
    }

    @Override
    public Node leaveADD(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode);
    }

    @Override
    public Node leaveBIT_NOT(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode);
    }

    @Override
    public Node leaveCONVERT(UnaryNode unaryNode) {
        assert (unaryNode.rhs().tokenType() != TokenType.CONVERT) : "convert(convert encountered. check its origin and remove it";
        return unaryNode;
    }

    @Override
    public Node leaveDECINC(UnaryNode unaryNode) {
        return this.specialize(unaryNode).node;
    }

    @Override
    public Node leaveNEW(UnaryNode unaryNode) {
        assert (unaryNode.getSymbol() != null && unaryNode.getSymbol().getSymbolType().isObject());
        return unaryNode.setRHS(((CallNode)unaryNode.rhs()).setIsNew());
    }

    @Override
    public Node leaveSUB(UnaryNode unaryNode) {
        return this.leaveUnary(unaryNode);
    }

    @Override
    public Node leaveADD(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type type = binaryNode.getType();
        if (type.isObject() && !this.isAddString(binaryNode)) {
            return new RuntimeNode(binaryNode, RuntimeNode.Request.ADD);
        }
        return binaryNode.setLHS(this.convert(lhs, type)).setRHS(this.convert(rhs, type));
    }

    @Override
    public Node leaveAND(BinaryNode binaryNode) {
        return binaryNode;
    }

    @Override
    public Node leaveASSIGN(BinaryNode binaryNode) {
        AccessNode accessNode;
        SpecializedNode specialized = this.specialize(binaryNode);
        BinaryNode specBinaryNode = (BinaryNode)specialized.node;
        Type destType = specialized.type;
        if (destType == null) {
            destType = specBinaryNode.getType();
        }
        if (binaryNode.lhs() instanceof AccessNode && (accessNode = (AccessNode)binaryNode.lhs()).getBase().getSymbol().isThis()) {
            this.lc.getCurrentFunction().addThisProperty(accessNode.getProperty().getName());
        }
        return specBinaryNode.setRHS(this.convert(specBinaryNode.rhs(), destType));
    }

    @Override
    public Node leaveASSIGN_ADD(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_AND(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_OR(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_DIV(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MOD(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MUL(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SAR(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHL(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHR(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SUB(BinaryNode binaryNode) {
        return this.leaveASSIGN(binaryNode);
    }

    private boolean symbolIsInteger(Node node) {
        Symbol symbol = node.getSymbol();
        assert (symbol != null && symbol.getSymbolType().isInteger()) : "int coercion expected: " + Debug.id(symbol) + " " + symbol + " " + this.lc.getCurrentFunction().getSource();
        return true;
    }

    @Override
    public Node leaveBIT_AND(BinaryNode binaryNode) {
        assert (this.symbolIsInteger(binaryNode));
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveBIT_OR(BinaryNode binaryNode) {
        assert (this.symbolIsInteger(binaryNode));
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveBIT_XOR(BinaryNode binaryNode) {
        assert (this.symbolIsInteger(binaryNode));
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveCOMMALEFT(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null);
        BinaryNode newBinaryNode = binaryNode.setRHS(FinalizeTypes.discard(binaryNode.rhs()));
        return this.propagateType(newBinaryNode, newBinaryNode.lhs().getType());
    }

    @Override
    public Node leaveCOMMARIGHT(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null);
        BinaryNode newBinaryNode = binaryNode.setLHS(FinalizeTypes.discard(binaryNode.lhs()));
        return this.propagateType(newBinaryNode, newBinaryNode.rhs().getType());
    }

    @Override
    public Node leaveDIV(BinaryNode binaryNode) {
        return this.leaveBinaryArith(binaryNode);
    }

    @Override
    public Node leaveEQ(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.EQ);
    }

    @Override
    public Node leaveEQ_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.EQ_STRICT);
    }

    @Override
    public Node leaveGE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.GE);
    }

    @Override
    public Node leaveGT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.GT);
    }

    @Override
    public Node leaveLE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.LE);
    }

    @Override
    public Node leaveLT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.LT);
    }

    @Override
    public Node leaveMOD(BinaryNode binaryNode) {
        return this.leaveBinaryArith(binaryNode);
    }

    @Override
    public Node leaveMUL(BinaryNode binaryNode) {
        return this.leaveBinaryArith(binaryNode);
    }

    @Override
    public Node leaveNE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.NE);
    }

    @Override
    public Node leaveNE_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.NE_STRICT);
    }

    @Override
    public Node leaveOR(BinaryNode binaryNode) {
        return binaryNode;
    }

    @Override
    public Node leaveSAR(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveSHL(BinaryNode binaryNode) {
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveSHR(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null && binaryNode.getSymbol().getSymbolType().isLong()) : "long coercion expected: " + binaryNode.getSymbol();
        return this.leaveBinary(binaryNode, Type.INT, Type.INT);
    }

    @Override
    public Node leaveSUB(BinaryNode binaryNode) {
        return this.leaveBinaryArith(binaryNode);
    }

    @Override
    public boolean enterBlock(Block block) {
        this.updateSymbols(block);
        return true;
    }

    @Override
    public Node leaveCatchNode(CatchNode catchNode) {
        Node exceptionCondition = catchNode.getExceptionCondition();
        if (exceptionCondition != null) {
            return catchNode.setExceptionCondition(this.convert(exceptionCondition, Type.BOOLEAN));
        }
        return catchNode;
    }

    @Override
    public Node leaveExecuteNode(ExecuteNode executeNode) {
        this.temporarySymbols.reuse();
        return executeNode.setExpression(FinalizeTypes.discard(executeNode.getExpression()));
    }

    @Override
    public Node leaveForNode(ForNode forNode) {
        Node init = forNode.getInit();
        Node test = forNode.getTest();
        Node modify = forNode.getModify();
        if (forNode.isForIn()) {
            return forNode.setModify(this.lc, this.convert(forNode.getModify(), Type.OBJECT));
        }
        assert (test != null || forNode.hasGoto()) : "forNode " + forNode + " needs goto and is missing it in " + this.lc.getCurrentFunction();
        return forNode.setInit(this.lc, init == null ? null : FinalizeTypes.discard(init)).setTest(this.lc, test == null ? null : this.convert(test, Type.BOOLEAN)).setModify(this.lc, modify == null ? null : FinalizeTypes.discard(modify));
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        if (functionNode.isLazy()) {
            return false;
        }
        if (!functionNode.needsCallee()) {
            functionNode.compilerConstant(CompilerConstants.CALLEE).setNeedsSlot(false);
        }
        if (!functionNode.hasScopeBlock() && !functionNode.needsParentScope()) {
            functionNode.compilerConstant(CompilerConstants.SCOPE).setNeedsSlot(false);
        }
        return true;
    }

    @Override
    public Node leaveFunctionNode(FunctionNode functionNode) {
        return functionNode.setState(this.lc, FunctionNode.CompilationState.FINALIZED);
    }

    @Override
    public Node leaveIfNode(IfNode ifNode) {
        return ifNode.setTest(this.convert(ifNode.getTest(), Type.BOOLEAN));
    }

    @Override
    public boolean enterLiteralNode(LiteralNode literalNode) {
        if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)literalNode;
            Node[] array = (Node[])arrayLiteralNode.getValue();
            Type elementType = arrayLiteralNode.getElementType();
            for (int i = 0; i < array.length; ++i) {
                Node element = array[i];
                if (element == null) continue;
                array[i] = this.convert(element.accept(this), elementType);
            }
        }
        return false;
    }

    @Override
    public Node leaveReturnNode(ReturnNode returnNode) {
        Node expr = returnNode.getExpression();
        if (expr != null) {
            return returnNode.setExpression(this.convert(expr, this.lc.getCurrentFunction().getReturnType()));
        }
        return returnNode;
    }

    @Override
    public Node leaveRuntimeNode(RuntimeNode runtimeNode) {
        List<Node> args = runtimeNode.getArgs();
        for (Node arg : args) {
            assert (!arg.getType().isUnknown());
        }
        return runtimeNode;
    }

    @Override
    public Node leaveSwitchNode(SwitchNode switchNode) {
        boolean allInteger = switchNode.getTag().getSymbolType().isInteger();
        if (allInteger) {
            return switchNode;
        }
        Node expression = switchNode.getExpression();
        List<CaseNode> cases = switchNode.getCases();
        ArrayList<CaseNode> newCases = new ArrayList<CaseNode>();
        for (CaseNode caseNode : cases) {
            Node test = caseNode.getTest();
            newCases.add(test != null ? caseNode.setTest(this.convert(test, Type.OBJECT)) : caseNode);
        }
        return switchNode.setExpression(this.lc, this.convert(expression, Type.OBJECT)).setCases(this.lc, newCases);
    }

    @Override
    public Node leaveTernaryNode(TernaryNode ternaryNode) {
        return ternaryNode.setLHS(this.convert(ternaryNode.lhs(), Type.BOOLEAN));
    }

    @Override
    public Node leaveThrowNode(ThrowNode throwNode) {
        return throwNode.setExpression(this.convert(throwNode.getExpression(), Type.OBJECT));
    }

    @Override
    public Node leaveVarNode(VarNode varNode) {
        Node init = varNode.getInit();
        if (init != null) {
            SpecializedNode specialized = this.specialize(varNode);
            VarNode specVarNode = (VarNode)specialized.node;
            Type destType = specialized.type;
            if (destType == null) {
                destType = specVarNode.getType();
            }
            assert (specVarNode.hasType()) : specVarNode + " doesn't have a type";
            Node convertedInit = this.convert(init, destType);
            this.temporarySymbols.reuse();
            return specVarNode.setInit(convertedInit);
        }
        this.temporarySymbols.reuse();
        return varNode;
    }

    @Override
    public Node leaveWhileNode(WhileNode whileNode) {
        Node test = whileNode.getTest();
        if (test != null) {
            return whileNode.setTest(this.lc, this.convert(test, Type.BOOLEAN));
        }
        return whileNode;
    }

    @Override
    public Node leaveWithNode(WithNode withNode) {
        return withNode.setExpression(this.lc, this.convert(withNode.getExpression(), Type.OBJECT));
    }

    private static void updateSymbolsLog(FunctionNode functionNode, Symbol symbol, boolean loseSlot) {
        if (LOG.isEnabled()) {
            if (!symbol.isScope()) {
                LOG.finest("updateSymbols: ", symbol, " => scope, because all vars in ", functionNode.getName(), " are in scope");
            }
            if (loseSlot && symbol.hasSlot()) {
                LOG.finest("updateSymbols: ", symbol, " => no slot, because all vars in ", functionNode.getName(), " are in scope");
            }
        }
    }

    private void updateSymbols(Block block) {
        if (!block.needsScope()) {
            return;
        }
        FunctionNode functionNode = this.lc.getFunction(block);
        boolean allVarsInScope = functionNode.allVarsInScope();
        boolean isVarArg = functionNode.isVarArg();
        for (Symbol symbol : block.getSymbols()) {
            if (symbol.isInternal() || symbol.isThis() || symbol.isTemp()) continue;
            if (symbol.isVar()) {
                if (allVarsInScope || symbol.isScope()) {
                    FinalizeTypes.updateSymbolsLog(functionNode, symbol, true);
                    Symbol.setSymbolIsScope(this.lc, symbol);
                    symbol.setNeedsSlot(false);
                    continue;
                }
                assert (symbol.hasSlot()) : symbol + " should have a slot only, no scope";
                continue;
            }
            if (!symbol.isParam() || !allVarsInScope && !isVarArg && !symbol.isScope()) continue;
            FinalizeTypes.updateSymbolsLog(functionNode, symbol, isVarArg);
            Symbol.setSymbolIsScope(this.lc, symbol);
            symbol.setNeedsSlot(!isVarArg);
        }
    }

    private Node leaveCmp(BinaryNode binaryNode, RuntimeNode.Request request) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type widest = Type.widest(lhs.getType(), rhs.getType());
        boolean newRuntimeNode = false;
        boolean finalized = false;
        switch (request) {
            case EQ_STRICT: 
            case NE_STRICT: {
                if (lhs.getType().isBoolean() == rhs.getType().isBoolean()) break;
                newRuntimeNode = true;
                widest = Type.OBJECT;
                finalized = true;
            }
        }
        if (newRuntimeNode || widest.isObject()) {
            return new RuntimeNode(binaryNode, request).setIsFinal(finalized);
        }
        return binaryNode.setLHS(this.convert(lhs, widest)).setRHS(this.convert(rhs, widest));
    }

    private static Type binaryArithType(Type lhsType, Type rhsType) {
        if (!Compiler.shouldUseIntegerArithmetic()) {
            return Type.NUMBER;
        }
        return Type.widest(lhsType, rhsType, Type.NUMBER);
    }

    private Node leaveBinaryArith(BinaryNode binaryNode) {
        Type type = FinalizeTypes.binaryArithType(binaryNode.lhs().getType(), binaryNode.rhs().getType());
        return this.leaveBinary(binaryNode, type, type);
    }

    private Node leaveBinary(BinaryNode binaryNode, Type lhsType, Type rhsType) {
        BinaryNode b = binaryNode.setLHS(this.convert(binaryNode.lhs(), lhsType)).setRHS(this.convert(binaryNode.rhs(), rhsType));
        return b;
    }

    private static void setCanBePrimitive(Node node, final Type to) {
        final HashSet exclude = new HashSet();
        node.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            private void setCanBePrimitive(Symbol symbol) {
                LOG.info("*** can be primitive symbol ", symbol, " ", Debug.id(symbol));
                symbol.setCanBePrimitive(to);
            }

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                if (!exclude.contains(identNode)) {
                    this.setCanBePrimitive(identNode.getSymbol());
                }
                return false;
            }

            @Override
            public boolean enterAccessNode(AccessNode accessNode) {
                this.setCanBePrimitive(accessNode.getProperty().getSymbol());
                return false;
            }

            @Override
            public boolean enterIndexNode(IndexNode indexNode) {
                exclude.add(indexNode.getBase());
                return true;
            }
        });
    }

    <T extends Node> SpecializedNode specialize(Assignment<T> assignment) {
        Node node = (Node)((Object)assignment);
        T lhs = assignment.getAssignmentDest();
        Node rhs = assignment.getAssignmentSource();
        if (!FinalizeTypes.canHaveCallSiteType(lhs)) {
            return new SpecializedNode(node, null);
        }
        Type to = node.isSelfModifying() ? node.getWidestOperationType() : rhs.getType();
        if (!FinalizeTypes.isSupportedCallSiteType(to)) {
            return new SpecializedNode(node, null);
        }
        Node newNode = assignment.setAssignmentDest(this.setTypeOverride(lhs, to));
        Node typePropagatedNode = this.propagateType(newNode, to);
        return new SpecializedNode(typePropagatedNode, to);
    }

    private static boolean canHaveCallSiteType(Node node) {
        return node instanceof TypeOverride && ((TypeOverride)((Object)node)).canHaveCallSiteType();
    }

    private static boolean isSupportedCallSiteType(Type castTo) {
        return castTo.isNumeric();
    }

    <T extends Node> T setTypeOverride(T node, Type to) {
        Type from = node.getType();
        if (!node.getType().equals(to)) {
            LOG.info("Changing call override type for '", node, "' from ", node.getType(), " to ", to);
            if (!to.isObject() && from.isObject()) {
                FinalizeTypes.setCanBePrimitive(node, to);
            }
        }
        LOG.info("Type override for lhs in '", node, "' => ", to);
        return ((TypeOverride)((Object)node)).setType(this.temporarySymbols, this.lc, to);
    }

    private Node convert(Node node, Type to) {
        assert (!to.isUnknown()) : "unknown type for " + node + " class=" + node.getClass();
        assert (node != null) : "node is null";
        assert (node.getSymbol() != null) : "node " + node + " " + node.getClass() + " has no symbol! " + this.lc.getCurrentFunction();
        assert (node.tokenType() != TokenType.CONVERT) : "assert convert in convert " + node + " in " + this.lc.getCurrentFunction();
        Type from = ((Node)node).getType();
        if (Type.areEquivalent(from, to)) {
            return node;
        }
        if (from.isObject() && to.isObject()) {
            return node;
        }
        LiteralNode<?> resultNode = node;
        if (node instanceof LiteralNode && !(node instanceof LiteralNode.ArrayLiteralNode) && !to.isObject()) {
            LiteralNode<?> newNode = new LiteralNodeConstantEvaluator(node, to).eval();
            if (newNode != null) {
                resultNode = newNode;
            }
        } else {
            if (FinalizeTypes.canHaveCallSiteType(node) && FinalizeTypes.isSupportedCallSiteType(to)) {
                assert (node instanceof TypeOverride);
                return this.setTypeOverride(node, to);
            }
            resultNode = new UnaryNode(Token.recast(node.getToken(), TokenType.CONVERT), (Node)node);
        }
        LOG.info("CONVERT('", node, "', ", to, ") => '", resultNode, "'");
        assert (!node.isTerminal());
        return this.temporarySymbols.ensureSymbol(this.lc, to, resultNode);
    }

    private static Node discard(Node node) {
        if (node.getSymbol() != null) {
            UnaryNode discard = new UnaryNode(Token.recast(node.getToken(), TokenType.DISCARD), node);
            assert (!node.isTerminal());
            return discard;
        }
        return node;
    }

    private Node propagateType(Node node, Type to) {
        Symbol symbol = node.getSymbol();
        if (symbol.isTemp() && symbol.getSymbolType() != to) {
            symbol = symbol.setTypeOverrideShared(to, this.temporarySymbols);
            LOG.info("Type override for temporary in '", node, "' => ", to);
        }
        return node.setSymbol(this.lc, symbol);
    }

    private boolean isAddString(Node node) {
        if (node instanceof BinaryNode && node.isTokenType(TokenType.ADD)) {
            BinaryNode binaryNode = (BinaryNode)node;
            Node lhs = binaryNode.lhs();
            Node rhs = binaryNode.rhs();
            return this.isAddString(lhs) || this.isAddString(rhs);
        }
        return node instanceof LiteralNode && ((LiteralNode)node).isString();
    }

    class LiteralNodeConstantEvaluator
    extends FoldConstants.ConstantEvaluator<LiteralNode<?>> {
        private final Type type;

        LiteralNodeConstantEvaluator(LiteralNode<?> parent, Type type) {
            super(parent);
            this.type = type;
        }

        @Override
        protected LiteralNode<?> eval() {
            Object value = ((LiteralNode)this.parent).getValue();
            LiteralNode<Number> literalNode = null;
            if (this.type.isString()) {
                literalNode = LiteralNode.newInstance(this.token, this.finish, JSType.toString(value));
            } else if (this.type.isBoolean()) {
                literalNode = LiteralNode.newInstance(this.token, this.finish, JSType.toBoolean(value));
            } else if (this.type.isInteger()) {
                literalNode = LiteralNode.newInstance(this.token, this.finish, JSType.toInt32(value));
            } else if (this.type.isLong()) {
                literalNode = LiteralNode.newInstance(this.token, this.finish, JSType.toLong(value));
            } else if (this.type.isNumber() || ((LiteralNode)this.parent).getType().isNumeric() && !((LiteralNode)this.parent).getType().isNumber()) {
                literalNode = LiteralNode.newInstance(this.token, this.finish, JSType.toNumber(value));
            }
            if (literalNode != null) {
                literalNode = (LiteralNode<Number>)literalNode.setSymbol(FinalizeTypes.this.lc, ((LiteralNode)this.parent).getSymbol());
            }
            return literalNode;
        }
    }

    private static class SpecializedNode {
        final Node node;
        final Type type;

        SpecializedNode(Node node, Type type) {
            this.node = node;
            this.type = type;
        }
    }
}

