/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;

final class Attr
extends NodeOperatorVisitor<LexicalContext> {
    private final Deque<Set<String>> localDefs;
    private final Deque<Set<String>> localUses;
    private final Deque<Type> returnTypes;
    private int catchNestingLevel;
    private static final DebugLogger LOG = new DebugLogger("attr");
    private static final boolean DEBUG = LOG.isEnabled();
    private final TemporarySymbols temporarySymbols;

    Attr(TemporarySymbols temporarySymbols) {
        super(new LexicalContext());
        this.temporarySymbols = temporarySymbols;
        this.localDefs = new ArrayDeque<Set<String>>();
        this.localUses = new ArrayDeque<Set<String>>();
        this.returnTypes = new ArrayDeque<Type>();
    }

    @Override
    protected boolean enterDefault(Node node) {
        return this.start(node);
    }

    @Override
    protected Node leaveDefault(Node node) {
        return this.end(node);
    }

    @Override
    public Node leaveAccessNode(AccessNode accessNode) {
        return this.end(this.ensureSymbol(Type.OBJECT, accessNode));
    }

    private void initFunctionWideVariables(FunctionNode functionNode, Block body) {
        this.initCompileConstant(CompilerConstants.CALLEE, body, 2052, FunctionNode.FUNCTION_TYPE);
        this.initCompileConstant(CompilerConstants.THIS, body, 36, Type.OBJECT);
        if (functionNode.isVarArg()) {
            this.initCompileConstant(CompilerConstants.VARARGS, body, 2052, Type.OBJECT_ARRAY);
            if (functionNode.needsArguments()) {
                this.initCompileConstant(CompilerConstants.ARGUMENTS, body, 2307, Type.typeFor(ScriptObject.class));
                this.addLocalDef(CompilerConstants.ARGUMENTS.symbolName());
            }
        }
        this.initParameters(functionNode, body);
        this.initCompileConstant(CompilerConstants.SCOPE, body, 2307, Type.typeFor(ScriptObject.class));
        this.initCompileConstant(CompilerConstants.RETURN, body, 2307, Type.OBJECT);
    }

    private void acceptDeclarations(final FunctionNode functionNode, final Block body) {
        body.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){
            private final Set<String> uses;
            private final Set<String> canBeUndefined;
            {
                super(lc);
                this.uses = new HashSet<String>();
                this.canBeUndefined = new HashSet<String>();
            }

            @Override
            public boolean enterFunctionNode(FunctionNode nestedFn) {
                return false;
            }

            @Override
            public Node leaveIdentNode(IdentNode identNode) {
                this.uses.add(identNode.getName());
                return identNode;
            }

            @Override
            public boolean enterVarNode(VarNode varNode) {
                final String name = varNode.getName().getName();
                if (this.uses.contains(name)) {
                    this.canBeUndefined.add(name);
                }
                if (!varNode.isFunctionDeclaration() && varNode.getInit() != null) {
                    varNode.getInit().accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

                        @Override
                        public boolean enterIdentNode(IdentNode identNode) {
                            if (name.equals(identNode.getName())) {
                                canBeUndefined.add(name);
                            }
                            return false;
                        }
                    });
                }
                return true;
            }

            @Override
            public Node leaveVarNode(VarNode varNode) {
                if (varNode.isStatement()) {
                    IdentNode ident = varNode.getName();
                    Symbol symbol = Attr.this.defineSymbol(body, ident.getName(), 3);
                    if (this.canBeUndefined.contains(ident.getName())) {
                        symbol.setType(Type.OBJECT);
                        symbol.setCanBeUndefined();
                    }
                    functionNode.addDeclaredSymbol(symbol);
                    if (varNode.isFunctionDeclaration()) {
                        Attr.newType(symbol, FunctionNode.FUNCTION_TYPE);
                    }
                    return varNode.setName((IdentNode)ident.setSymbol(this.lc, symbol));
                }
                return varNode;
            }
        });
    }

    private void enterFunctionBody() {
        FunctionNode functionNode = this.lc.getCurrentFunction();
        Block body = this.lc.getCurrentBlock();
        this.initFunctionWideVariables(functionNode, body);
        if (functionNode.isProgram()) {
            this.initFromPropertyMap(body);
        } else if (!functionNode.isDeclared()) {
            String name;
            assert (functionNode.getSymbol() == null);
            boolean anonymous = functionNode.isAnonymous();
            String string = name = anonymous ? null : functionNode.getIdent().getName();
            if (!anonymous && body.getExistingSymbol(name) == null) {
                assert (!anonymous && name != null);
                Attr.newType(this.defineSymbol(body, name, 4099), Type.OBJECT);
            }
        }
        this.acceptDeclarations(functionNode, body);
    }

    @Override
    public boolean enterBlock(Block block) {
        this.start(block);
        block.clearSymbols();
        if (this.lc.isFunctionBody()) {
            this.enterFunctionBody();
        }
        this.pushLocalsBlock();
        return true;
    }

    @Override
    public Node leaveBlock(Block block) {
        this.popLocals();
        return this.end(block);
    }

    @Override
    public boolean enterCallNode(CallNode callNode) {
        return this.start(callNode);
    }

    @Override
    public Node leaveCallNode(CallNode callNode) {
        return this.end(this.ensureSymbol(callNode.getType(), callNode));
    }

    @Override
    public boolean enterCatchNode(CatchNode catchNode) {
        IdentNode exception = catchNode.getException();
        Block block = this.lc.getCurrentBlock();
        this.start(catchNode);
        ++this.catchNestingLevel;
        String exname = exception.getName();
        Symbol def = this.defineSymbol(block, exname, 1283);
        Attr.newType(def, Type.OBJECT);
        this.addLocalDef(exname);
        return true;
    }

    @Override
    public Node leaveCatchNode(CatchNode catchNode) {
        IdentNode exception = catchNode.getException();
        Block block = this.lc.getCurrentBlock();
        Symbol symbol = this.findSymbol(block, exception.getName());
        --this.catchNestingLevel;
        assert (symbol != null);
        return this.end(catchNode.setException((IdentNode)exception.setSymbol(this.lc, symbol)));
    }

    private Symbol defineSymbol(Block block, String name, int symbolFlags) {
        int flags = symbolFlags;
        Symbol symbol = this.findSymbol(block, name);
        if ((flags & 7) == 2) {
            flags |= 0x10;
        }
        FunctionNode function = this.lc.getFunction(block);
        if (symbol != null) {
            if ((flags & 7) == 4) {
                if (!this.isLocal(function, symbol)) {
                    symbol = null;
                } else if (symbol.isParam()) {
                    assert (false) : "duplicate parameter";
                    return null;
                }
            } else if ((flags & 7) == 3) {
                if ((flags & 0x800) == 2048 || (flags & 0x400) == 1024) {
                    symbol = null;
                } else if (!this.isLocal(function, symbol) || symbol.less(3)) {
                    symbol = null;
                }
            }
        }
        if (symbol == null) {
            Block symbolBlock = (flags & 7) == 3 && ((flags & 0x800) == 2048 || (flags & 0x400) == 1024) ? block : this.lc.getFunctionBody(function);
            symbol = new Symbol(name, flags);
            symbolBlock.putSymbol(this.lc, symbol);
            if ((flags & 7) != 2) {
                symbol.setNeedsSlot(true);
            }
        } else if (symbol.less(flags)) {
            symbol.setFlags(flags);
        }
        return symbol;
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        Iterator<Block> blocks;
        this.start(functionNode, false);
        if (functionNode.isLazy()) {
            return false;
        }
        if (functionNode.isDeclared() && (blocks = this.lc.getBlocks()).hasNext()) {
            this.defineSymbol(blocks.next(), functionNode.getIdent().getName(), 3);
        }
        this.returnTypes.push(functionNode.getReturnType());
        this.pushLocalsFunction();
        return true;
    }

    @Override
    public Node leaveFunctionNode(FunctionNode functionNode) {
        Type returnType;
        FunctionNode newFunctionNode = functionNode;
        Block body = newFunctionNode.getBody();
        if (functionNode.isDeclared()) {
            Iterator<Block> blocks = this.lc.getBlocks();
            if (blocks.hasNext()) {
                newFunctionNode = (FunctionNode)newFunctionNode.setSymbol(this.lc, this.findSymbol(blocks.next(), functionNode.getIdent().getName()));
            }
        } else if (!functionNode.isProgram()) {
            String name;
            boolean anonymous = functionNode.isAnonymous();
            String string = name = anonymous ? null : functionNode.getIdent().getName();
            if (anonymous || body.getExistingSymbol(name) != null) {
                newFunctionNode = (FunctionNode)this.ensureSymbol(FunctionNode.FUNCTION_TYPE, newFunctionNode);
            } else {
                assert (name != null);
                Symbol self = body.getExistingSymbol(name);
                assert (self != null && self.isFunctionSelf());
                newFunctionNode = (FunctionNode)newFunctionNode.setSymbol(this.lc, body.getExistingSymbol(name));
            }
        }
        newFunctionNode = this.finalizeParameters(newFunctionNode);
        newFunctionNode = this.finalizeTypes(newFunctionNode);
        for (Symbol symbol : newFunctionNode.getDeclaredSymbols()) {
            if (!symbol.getSymbolType().isUnknown()) continue;
            symbol.setType(Type.OBJECT);
            symbol.setCanBeUndefined();
        }
        if (newFunctionNode.hasLazyChildren()) {
            Attr.objectifySymbols(body);
        }
        if (body.getFlag(2)) {
            IdentNode callee = this.compilerConstant(CompilerConstants.CALLEE);
            VarNode selfInit = new VarNode(newFunctionNode.getLineNumber(), newFunctionNode.getToken(), newFunctionNode.getFinish(), newFunctionNode.getIdent(), callee);
            LOG.info("Accepting self symbol init ", selfInit, " for ", newFunctionNode.getName());
            ArrayList<Statement> newStatements = new ArrayList<Statement>();
            assert (callee.getSymbol() != null && callee.getSymbol().hasSlot());
            IdentNode name = selfInit.getName();
            Symbol nameSymbol = body.getExistingSymbol(name.getName());
            assert (nameSymbol != null);
            selfInit = selfInit.setName((IdentNode)name.setSymbol(this.lc, nameSymbol));
            selfInit = (VarNode)selfInit.setSymbol(this.lc, nameSymbol);
            newStatements.add(selfInit);
            newStatements.addAll(body.getStatements());
            newFunctionNode = newFunctionNode.setBody(this.lc, body.setStatements(this.lc, newStatements));
        }
        if (this.returnTypes.peek().isUnknown()) {
            LOG.info("Unknown return type promoted to object");
            newFunctionNode = newFunctionNode.setReturnType(this.lc, Type.OBJECT);
        }
        newFunctionNode = newFunctionNode.setReturnType(this.lc, (returnType = this.returnTypes.pop()).isUnknown() ? Type.OBJECT : returnType);
        newFunctionNode = newFunctionNode.setState(this.lc, FunctionNode.CompilationState.ATTR);
        this.popLocals();
        this.end(newFunctionNode, false);
        return newFunctionNode;
    }

    @Override
    public Node leaveCONVERT(UnaryNode unaryNode) {
        assert (false) : "There should be no convert operators in IR during Attribution";
        return this.end(unaryNode);
    }

    @Override
    public Node leaveIdentNode(IdentNode identNode) {
        String name = identNode.getName();
        this.start(identNode);
        if (identNode.isPropertyName()) {
            Symbol pseudoSymbol = Attr.pseudoSymbol(name);
            LOG.info("IdentNode is property name -> assigning pseudo symbol ", pseudoSymbol);
            LOG.unindent();
            return this.end(identNode.setSymbol(this.lc, pseudoSymbol));
        }
        Block block = this.lc.getCurrentBlock();
        Symbol symbol = this.findSymbol(block, name);
        if (symbol != null) {
            LOG.info("Existing symbol = ", symbol);
            if (symbol.isFunctionSelf()) {
                FunctionNode functionNode = this.lc.getDefiningFunction(symbol);
                assert (functionNode != null);
                assert (this.lc.getFunctionBody(functionNode).getExistingSymbol(CompilerConstants.CALLEE.symbolName()) != null);
                this.lc.setFlag(functionNode.getBody(), 2);
                Attr.newType(symbol, FunctionNode.FUNCTION_TYPE);
            } else if (!(identNode.isInitializedHere() || this.isLocalDef(name) && !this.inCatch())) {
                Attr.newType(symbol, Type.OBJECT);
                symbol.setCanBeUndefined();
            }
            this.maybeForceScope(symbol);
        } else {
            LOG.info("No symbol exists. Declare undefined: ", symbol);
            symbol = this.defineSymbol(block, name, 2);
            Attr.newType(symbol, Type.OBJECT);
            symbol.setCanBeUndefined();
            Symbol.setSymbolIsScope(this.lc, symbol);
        }
        this.setBlockScope(name, symbol);
        if (!identNode.isInitializedHere()) {
            symbol.increaseUseCount();
        }
        this.addLocalUse(identNode.getName());
        return this.end(identNode.setSymbol(this.lc, symbol));
    }

    private boolean inCatch() {
        return this.catchNestingLevel > 0;
    }

    private void maybeForceScope(Symbol symbol) {
        if (!symbol.isScope() && this.symbolNeedsToBeScope(symbol)) {
            Symbol.setSymbolIsScope(this.lc, symbol);
        }
    }

    private boolean symbolNeedsToBeScope(Symbol symbol) {
        if (symbol.isThis() || symbol.isInternal()) {
            return false;
        }
        boolean previousWasBlock = false;
        Iterator<LexicalContextNode> it = this.lc.getAllNodes();
        while (it.hasNext()) {
            LexicalContextNode node = it.next();
            if (node instanceof FunctionNode) {
                return true;
            }
            if (node instanceof WithNode) {
                if (previousWasBlock) {
                    return true;
                }
                previousWasBlock = false;
                continue;
            }
            if (node instanceof Block) {
                if (((Block)node).getExistingSymbol(symbol.getName()) == symbol) {
                    return false;
                }
                previousWasBlock = true;
                continue;
            }
            previousWasBlock = false;
        }
        throw new AssertionError();
    }

    private void setBlockScope(String name, Symbol symbol) {
        assert (symbol != null);
        if (symbol.isGlobal()) {
            this.setUsesGlobalSymbol();
            return;
        }
        if (symbol.isScope()) {
            Block scopeBlock = null;
            Iterator<LexicalContextNode> contextNodeIter = this.lc.getAllNodes();
            while (contextNodeIter.hasNext()) {
                LexicalContextNode node = contextNodeIter.next();
                if (node instanceof Block) {
                    if (((Block)node).getExistingSymbol(name) == null) continue;
                    scopeBlock = (Block)node;
                    break;
                }
                if (!(node instanceof FunctionNode)) continue;
                this.lc.setFlag(node, 512);
            }
            if (scopeBlock != null) {
                assert (this.lc.contains(scopeBlock));
                this.lc.setBlockNeedsScope(scopeBlock);
            }
        }
    }

    private void setUsesGlobalSymbol() {
        Iterator<FunctionNode> fns = this.lc.getFunctions();
        while (fns.hasNext()) {
            this.lc.setFlag(fns.next(), 512);
        }
    }

    private Symbol findSymbol(Block block, String name) {
        Iterator<Block> blocks = this.lc.getBlocks(block);
        while (blocks.hasNext()) {
            Symbol symbol = blocks.next().getExistingSymbol(name);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    @Override
    public Node leaveIndexNode(IndexNode indexNode) {
        return this.end(this.ensureSymbol(Type.OBJECT, indexNode));
    }

    @Override
    public Node leaveLiteralNode(LiteralNode literalNode) {
        assert (!literalNode.isTokenType(TokenType.THIS)) : "tokentype for " + literalNode + " is this";
        assert (literalNode instanceof LiteralNode.ArrayLiteralNode || !(literalNode.getValue() instanceof Node)) : "literals with Node values not supported";
        Symbol symbol = new Symbol(this.lc.getCurrentFunction().uniqueName(CompilerConstants.LITERAL_PREFIX.symbolName()), 5, literalNode.getType());
        if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
            ((LiteralNode.ArrayLiteralNode)literalNode).analyze();
        }
        return this.end(literalNode.setSymbol(this.lc, symbol));
    }

    @Override
    public boolean enterObjectNode(ObjectNode objectNode) {
        return this.start(objectNode);
    }

    @Override
    public Node leaveObjectNode(ObjectNode objectNode) {
        return this.end(this.ensureSymbol(Type.OBJECT, objectNode));
    }

    @Override
    public Node leavePropertyNode(PropertyNode propertyNode) {
        return propertyNode.setSymbol(this.lc, new Symbol(propertyNode.getKeyName(), 0, Type.OBJECT));
    }

    @Override
    public Node leaveReturnNode(ReturnNode returnNode) {
        Type returnType;
        Node expr = returnNode.getExpression();
        if (expr != null) {
            Symbol symbol = expr.getSymbol();
            if (expr.getType().isUnknown() && symbol.isParam()) {
                symbol.setType(Type.OBJECT);
            }
            returnType = Type.widest(this.returnTypes.pop(), symbol.getSymbolType());
        } else {
            returnType = Type.OBJECT;
        }
        LOG.info("Returntype is now ", returnType);
        this.returnTypes.push(returnType);
        this.end(returnNode);
        return returnNode;
    }

    @Override
    public Node leaveSwitchNode(SwitchNode switchNode) {
        Type type = Type.UNKNOWN;
        ArrayList<CaseNode> newCases = new ArrayList<CaseNode>();
        for (CaseNode caseNode : switchNode.getCases()) {
            Node test = caseNode.getTest();
            CaseNode newCaseNode = caseNode;
            if (test != null) {
                if (test instanceof LiteralNode) {
                    LiteralNode lit = (LiteralNode)test;
                    if (lit.isNumeric() && !(lit.getValue() instanceof Integer) && JSType.isRepresentableAsInt(lit.getNumber())) {
                        newCaseNode = caseNode.setTest(LiteralNode.newInstance((Node)lit, (Number)lit.getInt32()).accept(this));
                    }
                } else {
                    type = Type.OBJECT;
                }
                type = Type.widest(type, newCaseNode.getTest().getType());
                if (type.isBoolean()) {
                    type = Type.OBJECT;
                }
            }
            newCases.add(newCaseNode);
        }
        if (!type.isInteger()) {
            type = Type.OBJECT;
        }
        switchNode.setTag(this.newInternal(this.lc.getCurrentFunction().uniqueName(CompilerConstants.SWITCH_TAG_PREFIX.symbolName()), type));
        this.end(switchNode);
        return switchNode.setCases(this.lc, newCases);
    }

    @Override
    public Node leaveTryNode(TryNode tryNode) {
        tryNode.setException(this.exceptionSymbol());
        if (tryNode.getFinallyBody() != null) {
            tryNode.setFinallyCatchAll(this.exceptionSymbol());
        }
        this.end(tryNode);
        return tryNode;
    }

    @Override
    public boolean enterVarNode(VarNode varNode) {
        this.start(varNode);
        IdentNode ident = varNode.getName();
        String name = ident.getName();
        Symbol symbol = this.defineSymbol(this.lc.getCurrentBlock(), name, 3);
        assert (symbol != null);
        if (this.isLocalUse(ident.getName())) {
            Attr.newType(symbol, Type.OBJECT);
            symbol.setCanBeUndefined();
        }
        return true;
    }

    @Override
    public Node leaveVarNode(VarNode varNode) {
        VarNode newVarNode = varNode;
        Node init = newVarNode.getInit();
        IdentNode ident = newVarNode.getName();
        String name = ident.getName();
        Symbol symbol = this.findSymbol(this.lc.getCurrentBlock(), ident.getName());
        if (init == null) {
            this.removeLocalDef(name);
            return this.end(newVarNode.setSymbol(this.lc, symbol));
        }
        this.addLocalDef(name);
        assert (symbol != null);
        IdentNode newIdent = (IdentNode)ident.setSymbol(this.lc, symbol);
        newVarNode = newVarNode.setName(newIdent);
        newVarNode = (VarNode)newVarNode.setSymbol(this.lc, symbol);
        boolean isScript = this.lc.getDefiningFunction(symbol).isProgram();
        if ((init.getType().isNumeric() || init.getType().isBoolean()) && !isScript) {
            Attr.newType(symbol, init.getType());
        } else {
            Attr.newType(symbol, Type.OBJECT);
        }
        assert (newVarNode.hasType()) : newVarNode + " has no type";
        return this.end(newVarNode);
    }

    @Override
    public Node leaveADD(UnaryNode unaryNode) {
        return this.end(this.ensureSymbol(Attr.arithType(), unaryNode));
    }

    @Override
    public Node leaveBIT_NOT(UnaryNode unaryNode) {
        return this.end(this.ensureSymbol(Type.INT, unaryNode));
    }

    @Override
    public Node leaveDECINC(UnaryNode unaryNode) {
        UnaryNode newUnaryNode = unaryNode.setRHS(this.ensureAssignmentSlots(unaryNode.rhs()));
        Type type = Attr.arithType();
        Attr.newType(newUnaryNode.rhs().getSymbol(), type);
        return this.end(this.ensureSymbol(type, newUnaryNode));
    }

    @Override
    public Node leaveDELETE(UnaryNode unaryNode) {
        Node base;
        FunctionNode currentFunctionNode = this.lc.getCurrentFunction();
        boolean strictMode = currentFunctionNode.isStrict();
        Node rhs = unaryNode.rhs();
        Node strictFlagNode = LiteralNode.newInstance((Node)unaryNode, strictMode).accept(this);
        RuntimeNode.Request request = RuntimeNode.Request.DELETE;
        ArrayList<Node> args = new ArrayList<Node>();
        if (rhs instanceof IdentNode) {
            boolean failDelete;
            String name = ((IdentNode)rhs).getName();
            boolean bl = failDelete = strictMode || rhs.getSymbol().isParam() || rhs.getSymbol().isVar() && !this.isProgramLevelSymbol(name);
            if (failDelete && rhs.getSymbol().isThis()) {
                return LiteralNode.newInstance((Node)unaryNode, true).accept(this);
            }
            Node literalNode = LiteralNode.newInstance((Node)unaryNode, name).accept(this);
            if (!failDelete) {
                args.add(this.compilerConstant(CompilerConstants.SCOPE));
            }
            args.add(literalNode);
            args.add(strictFlagNode);
            if (failDelete) {
                request = RuntimeNode.Request.FAIL_DELETE;
            }
        } else if (rhs instanceof AccessNode) {
            base = ((AccessNode)rhs).getBase();
            IdentNode property = ((AccessNode)rhs).getProperty();
            args.add(base);
            args.add(LiteralNode.newInstance((Node)unaryNode, property.getName()).accept(this));
            args.add(strictFlagNode);
        } else if (rhs instanceof IndexNode) {
            base = ((IndexNode)rhs).getBase();
            Node index = ((IndexNode)rhs).getIndex();
            args.add(base);
            args.add(index);
            args.add(strictFlagNode);
        } else {
            return LiteralNode.newInstance((Node)unaryNode, true).accept(this);
        }
        RuntimeNode runtimeNode = new RuntimeNode((Node)unaryNode, request, args);
        assert (runtimeNode.getSymbol() == unaryNode.getSymbol());
        return this.leaveRuntimeNode(runtimeNode);
    }

    private boolean isProgramLevelSymbol(String name) {
        Iterator<Block> it = this.lc.getBlocks();
        while (it.hasNext()) {
            Block next = it.next();
            if (next.getExistingSymbol(name) == null) continue;
            return next == this.lc.getFunctionBody(this.lc.getOutermostFunction());
        }
        throw new AssertionError((Object)("Couldn't find symbol " + name + " in the context"));
    }

    @Override
    public Node leaveNEW(UnaryNode unaryNode) {
        return this.end(this.ensureSymbol(Type.OBJECT, unaryNode));
    }

    @Override
    public Node leaveNOT(UnaryNode unaryNode) {
        return this.end(this.ensureSymbol(Type.BOOLEAN, unaryNode));
    }

    private IdentNode compilerConstant(CompilerConstants cc) {
        FunctionNode functionNode = this.lc.getCurrentFunction();
        return (IdentNode)new IdentNode(functionNode.getToken(), functionNode.getFinish(), cc.symbolName()).setSymbol(this.lc, functionNode.compilerConstant(cc));
    }

    @Override
    public Node leaveTYPEOF(UnaryNode unaryNode) {
        Node rhs = unaryNode.rhs();
        ArrayList<Node> args = new ArrayList<Node>();
        if (rhs instanceof IdentNode && !rhs.getSymbol().isParam() && !rhs.getSymbol().isVar()) {
            args.add(this.compilerConstant(CompilerConstants.SCOPE));
            args.add(LiteralNode.newInstance(rhs, ((IdentNode)rhs).getName()).accept(this));
        } else {
            args.add(rhs);
            args.add(LiteralNode.newInstance(unaryNode).accept(this));
        }
        RuntimeNode runtimeNode = new RuntimeNode((Node)unaryNode, RuntimeNode.Request.TYPEOF, args);
        assert (runtimeNode.getSymbol() == unaryNode.getSymbol());
        runtimeNode = (RuntimeNode)this.leaveRuntimeNode(runtimeNode);
        this.end(unaryNode);
        return runtimeNode;
    }

    @Override
    public Node leaveRuntimeNode(RuntimeNode runtimeNode) {
        return this.end(this.ensureSymbol(runtimeNode.getRequest().getReturnType(), runtimeNode));
    }

    @Override
    public Node leaveSUB(UnaryNode unaryNode) {
        return this.end(this.ensureSymbol(Attr.arithType(), unaryNode));
    }

    @Override
    public Node leaveVOID(UnaryNode unaryNode) {
        return this.end(this.ensureSymbol(Type.OBJECT, unaryNode));
    }

    @Override
    public Node leaveADD(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Attr.ensureTypeNotUnknown(lhs);
        Attr.ensureTypeNotUnknown(rhs);
        return this.end(this.ensureSymbol(Type.widest(Attr.arithType(), Type.widest(lhs.getType(), rhs.getType())), binaryNode));
    }

    @Override
    public Node leaveAND(BinaryNode binaryNode) {
        return this.end(this.ensureSymbol(Type.OBJECT, binaryNode));
    }

    private boolean enterAssignmentNode(BinaryNode binaryNode) {
        this.start(binaryNode);
        Node lhs = binaryNode.lhs();
        if (lhs instanceof IdentNode) {
            IdentNode ident;
            String name;
            Block block = this.lc.getCurrentBlock();
            Symbol symbol = this.findSymbol(block, name = (ident = (IdentNode)lhs).getName());
            if (symbol == null) {
                symbol = this.defineSymbol(block, name, 2);
            } else {
                this.maybeForceScope(symbol);
            }
            this.addLocalDef(name);
        }
        return true;
    }

    private Node leaveAssignmentNode(BinaryNode binaryNode) {
        BinaryNode newBinaryNode = binaryNode;
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type type = rhs.getType().isNumeric() ? Type.widest(binaryNode.lhs().getType(), binaryNode.rhs().getType()) : Type.OBJECT;
        Attr.newType(lhs.getSymbol(), type);
        return this.end(this.ensureSymbol(type, newBinaryNode));
    }

    private boolean isLocal(FunctionNode function, Symbol symbol) {
        FunctionNode definingFn = this.lc.getDefiningFunction(symbol);
        return definingFn == null || definingFn == function;
    }

    @Override
    public boolean enterASSIGN(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN(BinaryNode binaryNode) {
        return this.leaveAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_ADD(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_ADD(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type widest = Type.widest(lhs.getType(), rhs.getType());
        return this.leaveSelfModifyingAssignmentNode(binaryNode, widest.isNumeric() ? Type.NUMBER : Type.OBJECT);
    }

    @Override
    public boolean enterASSIGN_BIT_AND(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_AND(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_BIT_OR(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_OR(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_DIV(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_DIV(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_MOD(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MOD(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_MUL(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MUL(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_SAR(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SAR(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_SHL(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHL(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_SHR(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHR(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public boolean enterASSIGN_SUB(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SUB(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveBIT_AND(BinaryNode binaryNode) {
        return this.end(this.coerce(binaryNode, Type.INT));
    }

    @Override
    public Node leaveBIT_OR(BinaryNode binaryNode) {
        return this.end(this.coerce(binaryNode, Type.INT));
    }

    @Override
    public Node leaveBIT_XOR(BinaryNode binaryNode) {
        return this.end(this.coerce(binaryNode, Type.INT));
    }

    @Override
    public Node leaveCOMMARIGHT(BinaryNode binaryNode) {
        return this.end(this.ensureSymbol(binaryNode.rhs().getType(), binaryNode));
    }

    @Override
    public Node leaveCOMMALEFT(BinaryNode binaryNode) {
        return this.end(this.ensureSymbol(binaryNode.lhs().getType(), binaryNode));
    }

    @Override
    public Node leaveDIV(BinaryNode binaryNode) {
        return this.leaveBinaryArithmetic(binaryNode);
    }

    private Node leaveCmp(BinaryNode binaryNode) {
        Attr.ensureTypeNotUnknown(binaryNode.lhs());
        Attr.ensureTypeNotUnknown(binaryNode.rhs());
        return this.end(this.ensureSymbol(Type.BOOLEAN, binaryNode));
    }

    private Node coerce(BinaryNode binaryNode, Type operandType, Type destType) {
        return this.ensureSymbol(destType, binaryNode);
    }

    private Node coerce(BinaryNode binaryNode, Type type) {
        return this.coerce(binaryNode, type, type);
    }

    private Node leaveBinaryArithmetic(BinaryNode binaryNode) {
        assert (!Compiler.shouldUseIntegerArithmetic());
        return this.end(this.coerce(binaryNode, Type.NUMBER));
    }

    @Override
    public Node leaveEQ(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode);
    }

    @Override
    public Node leaveEQ_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode);
    }

    @Override
    public Node leaveGE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode);
    }

    @Override
    public Node leaveGT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode);
    }

    @Override
    public Node leaveIN(BinaryNode binaryNode) {
        return this.leaveBinaryRuntimeOperator(binaryNode, RuntimeNode.Request.IN);
    }

    @Override
    public Node leaveINSTANCEOF(BinaryNode binaryNode) {
        return this.leaveBinaryRuntimeOperator(binaryNode, RuntimeNode.Request.INSTANCEOF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node leaveBinaryRuntimeOperator(BinaryNode binaryNode, RuntimeNode.Request request) {
        try {
            Node node = this.leaveRuntimeNode(new RuntimeNode(binaryNode, request));
            return node;
        }
        finally {
            this.end(binaryNode);
        }
    }

    @Override
    public Node leaveLE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode);
    }

    @Override
    public Node leaveLT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode);
    }

    @Override
    public Node leaveMOD(BinaryNode binaryNode) {
        return this.leaveBinaryArithmetic(binaryNode);
    }

    @Override
    public Node leaveMUL(BinaryNode binaryNode) {
        return this.leaveBinaryArithmetic(binaryNode);
    }

    @Override
    public Node leaveNE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode);
    }

    @Override
    public Node leaveNE_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode);
    }

    @Override
    public Node leaveOR(BinaryNode binaryNode) {
        return this.end(this.ensureSymbol(Type.OBJECT, binaryNode));
    }

    @Override
    public Node leaveSAR(BinaryNode binaryNode) {
        return this.end(this.coerce(binaryNode, Type.INT));
    }

    @Override
    public Node leaveSHL(BinaryNode binaryNode) {
        return this.end(this.coerce(binaryNode, Type.INT));
    }

    @Override
    public Node leaveSHR(BinaryNode binaryNode) {
        return this.end(this.coerce(binaryNode, Type.LONG));
    }

    @Override
    public Node leaveSUB(BinaryNode binaryNode) {
        return this.leaveBinaryArithmetic(binaryNode);
    }

    @Override
    public Node leaveForNode(ForNode forNode) {
        if (forNode.isForIn()) {
            forNode.setIterator(this.newInternal(this.lc.getCurrentFunction().uniqueName(CompilerConstants.ITERATOR_PREFIX.symbolName()), Type.typeFor(CompilerConstants.ITERATOR_PREFIX.type())));
            Attr.newType(forNode.getInit().getSymbol(), Type.OBJECT);
        }
        this.end(forNode);
        return forNode;
    }

    @Override
    public Node leaveTernaryNode(TernaryNode ternaryNode) {
        Node lhs = ternaryNode.rhs();
        Node rhs = ternaryNode.third();
        Attr.ensureTypeNotUnknown(lhs);
        Attr.ensureTypeNotUnknown(rhs);
        Type type = Type.widest(lhs.getType(), rhs.getType());
        return this.end(this.ensureSymbol(type, ternaryNode));
    }

    private void initCompileConstant(CompilerConstants cc, Block block, int flags, Type type) {
        Symbol symbol = this.defineSymbol(block, cc.symbolName(), flags);
        Attr.newType(symbol, type);
        symbol.setNeedsSlot(true);
    }

    private void initParameters(FunctionNode functionNode, Block body) {
        int pos = 0;
        for (IdentNode param : functionNode.getParameters()) {
            this.addLocalDef(param.getName());
            Type callSiteParamType = functionNode.getHints().getParameterType(pos);
            int flags = 4;
            if (callSiteParamType != null) {
                LOG.info("Param ", param, " has a callsite type ", callSiteParamType, ". Using that.");
                flags |= 0x2000;
            }
            Symbol paramSymbol = this.defineSymbol(body, param.getName(), flags);
            assert (paramSymbol != null);
            Attr.newType(paramSymbol, callSiteParamType == null ? Type.UNKNOWN : callSiteParamType);
            LOG.info("Initialized param ", pos, "=", paramSymbol);
            ++pos;
        }
    }

    private FunctionNode finalizeParameters(FunctionNode functionNode) {
        ArrayList<IdentNode> newParams = new ArrayList<IdentNode>();
        boolean isVarArg = functionNode.isVarArg();
        int nparams = functionNode.getParameters().size();
        int specialize = 0;
        int pos = 0;
        for (IdentNode param : functionNode.getParameters()) {
            Symbol paramSymbol = functionNode.getBody().getExistingSymbol(param.getName());
            assert (paramSymbol != null);
            assert (paramSymbol.isParam());
            newParams.add((IdentNode)param.setSymbol(this.lc, paramSymbol));
            assert (paramSymbol != null);
            Type type = functionNode.getHints().getParameterType(pos);
            if (type == null) {
                type = Type.OBJECT;
            }
            if (paramSymbol.getUseCount() > 1 && !paramSymbol.getSymbolType().isObject()) {
                LOG.finest("Parameter ", param, " could profit from specialization to ", paramSymbol.getSymbolType());
                ++specialize;
            }
            Attr.newType(paramSymbol, Type.widest(type, paramSymbol.getSymbolType()));
            if (isVarArg) {
                paramSymbol.setNeedsSlot(false);
            }
            ++pos;
        }
        FunctionNode newFunctionNode = functionNode;
        if (nparams == 0 || specialize * 2 < nparams) {
            newFunctionNode = newFunctionNode.clearSnapshot(this.lc);
        }
        return newFunctionNode.setParameters(this.lc, newParams);
    }

    private void initFromPropertyMap(Block block) {
        PropertyMap map = Context.getGlobalMap();
        for (Property property : map.getProperties()) {
            String key = property.getKey();
            Symbol symbol = this.defineSymbol(block, key, 2);
            Attr.newType(symbol, Type.OBJECT);
            LOG.info("Added global symbol from property map ", symbol);
        }
    }

    private static void ensureTypeNotUnknown(Node node) {
        Symbol symbol = node.getSymbol();
        LOG.info("Ensure type not unknown for: ", symbol);
        if (node.getType().isUnknown() || symbol.isParam() && !symbol.isSpecializedParam()) {
            Attr.newType(symbol, Type.OBJECT);
            symbol.setCanBeUndefined();
        }
    }

    private static Symbol pseudoSymbol(String name) {
        return new Symbol(name, 0, Type.OBJECT);
    }

    private Symbol exceptionSymbol() {
        return this.newInternal(this.lc.getCurrentFunction().uniqueName(CompilerConstants.EXCEPTION_PREFIX.symbolName()), Type.typeFor(CompilerConstants.EXCEPTION_PREFIX.type()));
    }

    private Node ensureAssignmentSlots(Node assignmentDest) {
        final LexicalContext attrLexicalContext = this.lc;
        return assignmentDest.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public Node leaveIndexNode(IndexNode indexNode) {
                assert (indexNode.getSymbol().isTemp());
                Node index = indexNode.getIndex();
                Symbol indexSymbol = index.getSymbol();
                if (indexSymbol.isTemp() && !indexSymbol.isConstant() && !indexSymbol.hasSlot()) {
                    if (indexSymbol.isShared()) {
                        indexSymbol = Attr.this.temporarySymbols.createUnshared(indexSymbol);
                    }
                    indexSymbol.setNeedsSlot(true);
                    attrLexicalContext.getCurrentBlock().putSymbol(attrLexicalContext, indexSymbol);
                    return indexNode.setIndex(index.setSymbol(attrLexicalContext, indexSymbol));
                }
                return indexNode;
            }
        });
    }

    private static Type arithType() {
        return Compiler.shouldUseIntegerArithmetic() ? Type.INT : Type.NUMBER;
    }

    private FunctionNode finalizeTypes(FunctionNode functionNode) {
        final HashSet changed = new HashSet();
        FunctionNode currentFunctionNode = functionNode;
        do {
            changed.clear();
            FunctionNode newFunctionNode = (FunctionNode)currentFunctionNode.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

                private Node widen(Node node, Type to) {
                    if (node instanceof LiteralNode) {
                        return node;
                    }
                    Type from = node.getType();
                    if (!Type.areEquivalent(from, to) && Type.widest(from, to) == to) {
                        LOG.fine("Had to post pass widen '", node, "' ", Debug.id(node), " from ", node.getType(), " to ", to);
                        Symbol symbol = node.getSymbol();
                        if (symbol.isShared() && symbol.wouldChangeType(to)) {
                            symbol = Attr.this.temporarySymbols.getTypedTemporarySymbol(to);
                        }
                        Attr.newType(symbol, to);
                        Node newNode = node.setSymbol(this.lc, symbol);
                        changed.add(newNode);
                        return newNode;
                    }
                    return node;
                }

                @Override
                public boolean enterFunctionNode(FunctionNode node) {
                    return !node.isLazy();
                }

                @Override
                public Node leaveBinaryNode(BinaryNode binaryNode) {
                    Type widest = Type.widest(binaryNode.lhs().getType(), binaryNode.rhs().getType());
                    BinaryNode newBinaryNode = binaryNode;
                    switch (binaryNode.tokenType()) {
                        default: {
                            if (!binaryNode.isAssignment() || binaryNode.isSelfModifying()) break;
                            newBinaryNode = newBinaryNode.setLHS(this.widen(newBinaryNode.lhs(), widest));
                        }
                        case ADD: {
                            newBinaryNode = (BinaryNode)this.widen(newBinaryNode, widest);
                        }
                    }
                    return newBinaryNode;
                }
            });
            this.lc.replace(currentFunctionNode, newFunctionNode);
            currentFunctionNode = newFunctionNode;
        } while (!changed.isEmpty());
        return currentFunctionNode;
    }

    private Node leaveSelfModifyingAssignmentNode(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode, binaryNode.getWidestOperationType());
    }

    private Node leaveSelfModifyingAssignmentNode(BinaryNode binaryNode, Type destType) {
        Node lhs = binaryNode.lhs();
        Attr.newType(lhs.getSymbol(), destType);
        return this.end(this.ensureSymbol(destType, this.ensureAssignmentSlots(binaryNode)));
    }

    private Node ensureSymbol(Type type, Node node) {
        LOG.info("New TEMPORARY added to ", this.lc.getCurrentFunction().getName(), " type=", type);
        return this.temporarySymbols.ensureSymbol(this.lc, type, node);
    }

    private Symbol newInternal(String name, Type type) {
        Symbol iter = this.defineSymbol(this.lc.getCurrentBlock(), name, 2051);
        iter.setType(type);
        return iter;
    }

    private static void newType(Symbol symbol, Type type) {
        Type oldType = symbol.getSymbolType();
        symbol.setType(type);
        if (symbol.getSymbolType() != oldType) {
            LOG.info("New TYPE ", type, " for ", symbol, " (was ", oldType, ")");
        }
        if (symbol.isParam()) {
            symbol.setType(type);
            LOG.info("Param type change ", symbol);
        }
    }

    private void pushLocalsFunction() {
        this.localDefs.push(new HashSet());
        this.localUses.push(new HashSet());
    }

    private void pushLocalsBlock() {
        this.localDefs.push(new HashSet(this.localDefs.peek()));
        this.localUses.push(new HashSet(this.localUses.peek()));
    }

    private void popLocals() {
        this.localDefs.pop();
        this.localUses.pop();
    }

    private boolean isLocalDef(String name) {
        return this.localDefs.peek().contains(name);
    }

    private void addLocalDef(String name) {
        LOG.info("Adding local def of symbol: '", name, "'");
        this.localDefs.peek().add(name);
    }

    private void removeLocalDef(String name) {
        LOG.info("Removing local def of symbol: '", name, "'");
        this.localDefs.peek().remove(name);
    }

    private boolean isLocalUse(String name) {
        return this.localUses.peek().contains(name);
    }

    private void addLocalUse(String name) {
        LOG.info("Adding local use of symbol: '", name, "'");
        this.localUses.peek().add(name);
    }

    private static void objectifySymbols(Block body) {
        body.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

            private void toObject(Block block) {
                for (Symbol symbol : block.getSymbols()) {
                    if (symbol.isTemp()) continue;
                    Attr.newType(symbol, Type.OBJECT);
                }
            }

            @Override
            public boolean enterBlock(Block block) {
                this.toObject(block);
                return true;
            }

            @Override
            public boolean enterFunctionNode(FunctionNode node) {
                return false;
            }
        });
    }

    private static String name(Node node) {
        String cn = node.getClass().getName();
        int lastDot = cn.lastIndexOf(46);
        if (lastDot == -1) {
            return cn;
        }
        return cn.substring(lastDot + 1);
    }

    private boolean start(Node node) {
        return this.start(node, true);
    }

    private boolean start(Node node, boolean printNode) {
        if (DEBUG) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ENTER ").append(Attr.name(node)).append("] ").append(printNode ? node.toString() : "").append(" in '").append(this.lc.getCurrentFunction().getName()).append("'");
            LOG.info(sb);
            LOG.indent();
        }
        return true;
    }

    private Node end(Node node) {
        return this.end(node, true);
    }

    private Node end(Node node, boolean printNode) {
        if (node instanceof Statement) {
            this.temporarySymbols.reuse();
        }
        if (DEBUG) {
            StringBuilder sb = new StringBuilder();
            sb.append("[LEAVE ").append(Attr.name(node)).append("] ").append(printNode ? node.toString() : "").append(" in '").append(this.lc.getCurrentFunction().getName());
            if (node.getSymbol() == null) {
                sb.append(" <NO SYMBOL>");
            } else {
                sb.append(" <symbol=").append(node.getSymbol()).append('>');
            }
            LOG.unindent();
            LOG.info(sb);
        }
        return node;
    }
}

