/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.dynalink.beans;

import java.io.IOException;
import java.io.InputStream;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.SecureRandom;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;

final class SandboxClassLoader {
    private final String className;
    private final String randomizedClassName;

    private SandboxClassLoader(String className) {
        this.className = className;
        String simpleClassName = className.substring(className.lastIndexOf(46) + 1);
        this.randomizedClassName = "randomPackage" + Long.toHexString(new SecureRandom().nextLong()) + "." + simpleClassName;
    }

    static Class<?> loadClass(String className) throws SecurityException {
        return new SandboxClassLoader(className).loadClass();
    }

    private Class<?> loadClass() throws SecurityException {
        ClassLoader loader = this.createClassLoader();
        try {
            Class<?> clazz = Class.forName(this.randomizedClassName, true, loader);
            if (clazz.getClassLoader() != loader) {
                throw new AssertionError((Object)(this.randomizedClassName + " was loaded from a different class loader"));
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ClassLoader createClassLoader() throws SecurityException {
        final String lclassName = this.randomizedClassName;
        return new SecureClassLoader(this.getClass().getClassLoader()){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                SecurityManager sm;
                if (name.equals(lclassName)) {
                    byte[] bytes = SandboxClassLoader.this.getClassBytes();
                    Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, SandboxClassLoader.createMinimalPermissionsDomain());
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                int i = name.lastIndexOf(46);
                if (i != -1 && (sm = System.getSecurityManager()) != null) {
                    sm.checkPackageAccess(name.substring(0, i));
                }
                return super.loadClass(name, resolve);
            }
        };
    }

    private static ProtectionDomain createMinimalPermissionsDomain() {
        Permissions p = new Permissions();
        p.add(new RuntimePermission("accessClassInPackage.jdk.internal.dynalink.beans.sandbox"));
        return new ProtectionDomain(null, p);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getClassBytes() {
        try (InputStream in = this.getClass().getResourceAsStream("/" + this.className.replace('.', '/') + ".class");){
            ClassReader cr = new ClassReader(in);
            ClassWriter cw = new ClassWriter(cr, 0);
            cr.accept(new ClassVisitor(262144, cw){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if ((access & 1) != 0) {
                        throw new IllegalArgumentException("Class " + SandboxClassLoader.this.className + " must be package-private");
                    }
                    super.visit(version, access | 1, SandboxClassLoader.this.randomizedClassName.replace('.', '/'), signature, superName, interfaces);
                }

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    boolean isCtor = "<init>".equals(name);
                    if (isCtor && (access & 1) != 0) {
                        throw new IllegalArgumentException("Class " + SandboxClassLoader.this.className + " must have no public constructors");
                    }
                    return super.visitMethod(isCtor ? access | 1 : access, name, desc, signature, exceptions);
                }
            }, 0);
            byte[] byArray = cw.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

