/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.dynalink.beans;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jdk.internal.dynalink.beans.sandbox.Unreflector;

final class SafeUnreflectorImpl
implements Unreflector {
    SafeUnreflectorImpl() {
    }

    @Override
    public MethodHandle unreflect(Method m) {
        try {
            return MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e) {
            IllegalAccessError ee = new IllegalAccessError("Failed to unreflect method " + m);
            ee.initCause(e);
            throw ee;
        }
    }

    @Override
    public MethodHandle unreflectGetter(Field f) {
        try {
            return MethodHandles.lookup().unreflectGetter(f);
        }
        catch (IllegalAccessException e) {
            IllegalAccessError ee = new IllegalAccessError("Failed to unreflect getter for field " + f);
            ee.initCause(e);
            throw ee;
        }
    }

    @Override
    public MethodHandle unreflectSetter(Field f) {
        try {
            return MethodHandles.lookup().unreflectSetter(f);
        }
        catch (IllegalAccessException e) {
            IllegalAccessError ee = new IllegalAccessError("Failed to unreflect setter for field " + f);
            ee.initCause(e);
            throw ee;
        }
    }

    @Override
    public MethodHandle unreflectConstructor(Constructor<?> c) {
        try {
            return MethodHandles.lookup().unreflectConstructor(c);
        }
        catch (IllegalAccessException e) {
            IllegalAccessError ee = new IllegalAccessError("Failed to unreflect constructor " + c);
            ee.initCause(e);
            throw ee;
        }
    }
}

