/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.regexp.joni.ast;

import java.util.Set;
import jdk.nashorn.internal.runtime.regexp.joni.UnsetAddrList;
import jdk.nashorn.internal.runtime.regexp.joni.WarnCallback;
import jdk.nashorn.internal.runtime.regexp.joni.ast.Node;
import jdk.nashorn.internal.runtime.regexp.joni.ast.StateNode;

public final class CallNode
extends StateNode {
    public char[] name;
    public int nameP;
    public int nameEnd;
    public int groupNum;
    public Node target;
    public UnsetAddrList unsetAddrList;

    public CallNode(char[] name, int nameP, int nameEnd, int gnum) {
        this.name = name;
        this.nameP = nameP;
        this.nameEnd = nameEnd;
        this.groupNum = gnum;
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    protected void setChild(Node newChild) {
        this.target = newChild;
    }

    @Override
    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node tgt) {
        this.target = tgt;
        tgt.parent = this;
    }

    @Override
    public String getName() {
        return "Call";
    }

    @Override
    public void verifyTree(Set<Node> set, WarnCallback warnings) {
        if (this.target == null || this.target.parent == this) {
            warnings.warn(this.getAddressName() + " doesn't point to a target or the target has been stolen");
        }
    }

    @Override
    public String toString(int level) {
        StringBuilder value = new StringBuilder(super.toString(level));
        value.append("\n  name: " + new String(this.name, this.nameP, this.nameEnd - this.nameP));
        value.append("\n  groupNum: " + this.groupNum);
        value.append("\n  target: " + CallNode.pad(this.target.getAddressName(), level + 1));
        value.append("\n  unsetAddrList: " + CallNode.pad(this.unsetAddrList, level + 1));
        return value.toString();
    }
}

