/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.regexp.joni;

import java.util.HashMap;
import java.util.Iterator;
import jdk.nashorn.internal.runtime.regexp.joni.Analyser;
import jdk.nashorn.internal.runtime.regexp.joni.Matcher;
import jdk.nashorn.internal.runtime.regexp.joni.MatcherFactory;
import jdk.nashorn.internal.runtime.regexp.joni.MinMaxLen;
import jdk.nashorn.internal.runtime.regexp.joni.NameEntry;
import jdk.nashorn.internal.runtime.regexp.joni.OptAnchorInfo;
import jdk.nashorn.internal.runtime.regexp.joni.OptExactInfo;
import jdk.nashorn.internal.runtime.regexp.joni.OptMapInfo;
import jdk.nashorn.internal.runtime.regexp.joni.Option;
import jdk.nashorn.internal.runtime.regexp.joni.Region;
import jdk.nashorn.internal.runtime.regexp.joni.ScanEnvironment;
import jdk.nashorn.internal.runtime.regexp.joni.SearchAlgorithm;
import jdk.nashorn.internal.runtime.regexp.joni.Syntax;
import jdk.nashorn.internal.runtime.regexp.joni.WarnCallback;
import jdk.nashorn.internal.runtime.regexp.joni.constants.RegexState;
import jdk.nashorn.internal.runtime.regexp.joni.exception.InternalException;
import jdk.nashorn.internal.runtime.regexp.joni.exception.ValueException;

public final class Regex
implements RegexState {
    int[] code;
    int codeLength;
    boolean stackNeeded;
    Object[] operands;
    int operandLength;
    int state;
    int numMem;
    int numRepeat;
    int numNullCheck;
    int numCombExpCheck;
    int numCall;
    int captureHistory;
    int btMemStart;
    int btMemEnd;
    int stackPopLevel;
    int[] repeatRangeLo;
    int[] repeatRangeHi;
    public WarnCallback warnings;
    public MatcherFactory factory;
    int options;
    int userOptions;
    Object userObject;
    final int caseFoldFlag;
    HashMap<String, NameEntry> nameTable;
    SearchAlgorithm searchAlgorithm;
    int thresholdLength;
    int anchor;
    int anchorDmin;
    int anchorDmax;
    int subAnchor;
    char[] exact;
    int exactP;
    int exactEnd;
    byte[] map;
    int[] intMap;
    int[] intMapBackward;
    int dMin;
    int dMax;
    char[][] templates;
    int templateNum;

    public Regex(CharSequence cs) {
        this(cs.toString());
    }

    public Regex(String str) {
        this(str.toCharArray(), 0, str.length(), 0);
    }

    public Regex(char[] chars) {
        this(chars, 0, chars.length, 0);
    }

    public Regex(char[] chars, int p, int end) {
        this(chars, p, end, 0);
    }

    public Regex(char[] chars, int p, int end, int option) {
        this(chars, p, end, option, Syntax.RUBY, WarnCallback.DEFAULT);
    }

    public Regex(char[] chars, int p, int end, int option, Syntax syntax) {
        this(chars, p, end, option, 0x40000000, syntax, WarnCallback.DEFAULT);
    }

    public Regex(char[] chars, int p, int end, int option, WarnCallback warnings) {
        this(chars, p, end, option, Syntax.RUBY, warnings);
    }

    public Regex(char[] chars, int p, int end, int option, Syntax syntax, WarnCallback warnings) {
        this(chars, p, end, option, 0x40000000, syntax, warnings);
    }

    public Regex(char[] chars, int p, int end, int option, int caseFoldFlag, Syntax syntax, WarnCallback warnings) {
        if ((option & 0x180) == 384) {
            throw new ValueException("invalid combination of options");
        }
        if ((option & 0x40) != 0) {
            option |= syntax.options;
            option &= 0xFFFFFFF7;
        } else {
            option |= syntax.options;
        }
        this.options = option;
        this.caseFoldFlag = caseFoldFlag;
        this.warnings = warnings;
        new Analyser(new ScanEnvironment(this, syntax), chars, p, end).compile();
        this.warnings = null;
    }

    public Matcher matcher(char[] chars) {
        return this.matcher(chars, 0, chars.length);
    }

    public Matcher matcher(char[] chars, int p, int end) {
        return this.factory.create(this, chars, p, end);
    }

    public int numberOfCaptures() {
        return this.numMem;
    }

    public int numberOfCaptureHistories() {
        return 0;
    }

    String nameTableToString() {
        StringBuilder sb = new StringBuilder();
        if (this.nameTable != null) {
            sb.append("name table\n");
            for (NameEntry ne : this.nameTable.values()) {
                sb.append("  " + ne + "\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    NameEntry nameFind(char[] name, int nameP, int nameEnd) {
        if (this.nameTable != null) {
            return this.nameTable.get(new String(name, nameP, nameEnd - nameP));
        }
        return null;
    }

    void renumberNameTable(int[] map) {
        if (this.nameTable != null) {
            for (NameEntry e : this.nameTable.values()) {
                if (e.backNum > 1) {
                    for (int i = 0; i < e.backNum; ++i) {
                        e.backRefs[i] = map[e.backRefs[i]];
                    }
                    continue;
                }
                if (e.backNum != 1) continue;
                e.backRef1 = map[e.backRef1];
            }
        }
    }

    public int numberOfNames() {
        return this.nameTable == null ? 0 : this.nameTable.size();
    }

    void nameAdd(char[] name, int nameP, int nameEnd, int backRef, Syntax syntax) {
        if (nameEnd - nameP <= 0) {
            throw new ValueException("group name is empty");
        }
        NameEntry e = null;
        if (this.nameTable == null) {
            this.nameTable = new HashMap();
        } else {
            e = this.nameFind(name, nameP, nameEnd);
        }
        if (e == null) {
            e = new NameEntry(name, nameP, nameEnd);
            this.nameTable.put(new String(name, nameP, nameEnd - nameP), e);
        } else if (e.backNum >= 1 && !syntax.allowMultiplexDefinitionName()) {
            throw new ValueException("multiplex defined name <%n>", new String(name, nameP, nameEnd - nameP));
        }
        e.addBackref(backRef);
    }

    NameEntry nameToGroupNumbers(char[] name, int nameP, int nameEnd) {
        return this.nameFind(name, nameP, nameEnd);
    }

    public int nameToBackrefNumber(char[] name, int nameP, int nameEnd, Region region) {
        NameEntry e = this.nameToGroupNumbers(name, nameP, nameEnd);
        if (e == null) {
            throw new ValueException("undefined name <%n> reference", new String(name, nameP, nameEnd - nameP));
        }
        switch (e.backNum) {
            case 0: {
                throw new InternalException("internal parser error (bug)");
            }
            case 1: {
                return e.backRef1;
            }
        }
        if (region != null) {
            for (int i = e.backNum - 1; i >= 0; --i) {
                if (region.beg[e.backRefs[i]] == -1) continue;
                return e.backRefs[i];
            }
        }
        return e.backRefs[e.backNum - 1];
    }

    public Iterator<NameEntry> namedBackrefIterator() {
        return this.nameTable.values().iterator();
    }

    public boolean noNameGroupIsActive(Syntax syntax) {
        if (Option.isDontCaptureGroup(this.options)) {
            return false;
        }
        return this.numberOfNames() <= 0 || !syntax.captureOnlyNamedGroup() || Option.isCaptureGroup(this.options);
    }

    void setupBMSkipMap() {
        char[] chars = this.exact;
        int end = this.exactEnd;
        int p = this.exactP;
        int len = end - p;
        if (len < 256) {
            int i;
            if (this.map == null) {
                this.map = new byte[256];
            }
            for (i = 0; i < 256; ++i) {
                this.map[i] = (byte)len;
            }
            for (i = 0; i < len - 1; ++i) {
                this.map[chars[p + i] & 0xFF] = (byte)(len - 1 - i);
            }
        } else {
            if (this.intMap == null) {
                this.intMap = new int[256];
            }
            for (int i = 0; i < len - 1; ++i) {
                this.intMap[chars[p + i] & 0xFF] = len - 1 - i;
            }
        }
    }

    void setExactInfo(OptExactInfo e) {
        if (e.length == 0) {
            return;
        }
        this.exact = e.chars;
        this.exactP = 0;
        this.exactEnd = e.length;
        if (e.ignoreCase) {
            this.searchAlgorithm = new SearchAlgorithm.SLOW_IC(this);
        } else if (e.length >= 2) {
            this.setupBMSkipMap();
            this.searchAlgorithm = SearchAlgorithm.BM;
        } else {
            this.searchAlgorithm = SearchAlgorithm.SLOW;
        }
        this.dMin = e.mmd.min;
        this.dMax = e.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + (this.exactEnd - this.exactP);
        }
    }

    void setOptimizeMapInfo(OptMapInfo m) {
        this.map = m.map;
        this.searchAlgorithm = SearchAlgorithm.MAP;
        this.dMin = m.mmd.min;
        this.dMax = m.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + 1;
        }
    }

    void setSubAnchor(OptAnchorInfo anc) {
        this.subAnchor |= anc.leftAnchor & 2;
        this.subAnchor |= anc.rightAnchor & 0x20;
    }

    void clearOptimizeInfo() {
        this.searchAlgorithm = SearchAlgorithm.NONE;
        this.anchor = 0;
        this.anchorDmax = 0;
        this.anchorDmin = 0;
        this.subAnchor = 0;
        this.exact = null;
        this.exactEnd = 0;
        this.exactP = 0;
    }

    public String encStringToString(byte[] bytes, int p, int end) {
        StringBuilder sb = new StringBuilder("\nPATTERN: /");
        while (p < end) {
            sb.append(new String(new byte[]{bytes[p]}));
            ++p;
        }
        return sb.append("/").toString();
    }

    public String optimizeInfoToString() {
        String s = "";
        s = s + "optimize: " + this.searchAlgorithm.getName() + "\n";
        s = s + "  anchor:     " + OptAnchorInfo.anchorToString(this.anchor);
        if ((this.anchor & 0x18) != 0) {
            s = s + MinMaxLen.distanceRangeToString(this.anchorDmin, this.anchorDmax);
        }
        s = s + "\n";
        if (this.searchAlgorithm != SearchAlgorithm.NONE) {
            s = s + "  sub anchor: " + OptAnchorInfo.anchorToString(this.subAnchor) + "\n";
        }
        s = s + "dmin: " + this.dMin + " dmax: " + this.dMax + "\n";
        s = s + "threshold length: " + this.thresholdLength + "\n";
        if (this.exact != null) {
            s = s + "exact: [" + new String(this.exact, this.exactP, this.exactEnd - this.exactP) + "]: length: " + (this.exactEnd - this.exactP) + "\n";
        } else if (this.searchAlgorithm == SearchAlgorithm.MAP) {
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                if (this.map[i] == 0) continue;
                ++n;
            }
            s = s + "map: n = " + n + "\n";
            if (n > 0) {
                int c = 0;
                s = s + "[";
                for (int i = 0; i < 256; ++i) {
                    if (this.map[i] == 0) continue;
                    if (c > 0) {
                        s = s + ", ";
                    }
                    ++c;
                    s = s + (char)i;
                }
                s = s + "]\n";
            }
        }
        return s;
    }

    public int getOptions() {
        return this.options;
    }

    public void setUserOptions(int options) {
        this.userOptions = options;
    }

    public int getUserOptions() {
        return this.userOptions;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }
}

