/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.regexp.joni;

import java.util.Arrays;
import jdk.nashorn.internal.runtime.regexp.joni.ApplyCaseFold;
import jdk.nashorn.internal.runtime.regexp.joni.encoding.IntHolder;

public class EncodingHelper {
    public static final char NEW_LINE = '\n';
    public static final char RETURN = '\r';
    static final char[] EMPTYCHARS = new char[0];
    static final int[][] codeRanges = new int[15][];

    public static int digitVal(int code) {
        return code - 48;
    }

    public static int odigitVal(int code) {
        return EncodingHelper.digitVal(code);
    }

    public static boolean isXDigit(int code) {
        return Character.isDigit(code) || code >= 97 && code <= 102 || code >= 65 && code <= 70;
    }

    public static int xdigitVal(int code) {
        if (Character.isDigit(code)) {
            return code - 48;
        }
        if (code >= 97 && code <= 102) {
            return code - 97 + 10;
        }
        return code - 65 + 10;
    }

    public static boolean isDigit(int code) {
        return code >= 48 && code <= 57;
    }

    public static boolean isWord(int code) {
        return (1 << Character.getType(code) & 0x8003FE) != 0;
    }

    public static boolean isNewLine(int code) {
        return code == 10;
    }

    public static boolean isNewLine(char[] chars, int p, int end) {
        return p < end && chars[p] == '\n';
    }

    public static boolean isCrnl(char[] chars, int p, int end) {
        return p + 1 < end && chars[p] == '\r' && chars[p + 1] == '\n';
    }

    public static int prevCharHead(int p, int s) {
        return s <= p ? -1 : s - 1;
    }

    public static int rightAdjustCharHeadWithPrev(int s, IntHolder prev) {
        if (prev != null) {
            prev.value = -1;
        }
        return s;
    }

    public static int stepBack(int p, int s, int n) {
        while (s != -1 && n-- > 0) {
            if (s <= p) {
                return -1;
            }
            --s;
        }
        return s;
    }

    public static int strNCmp(char[] chars1, int p1, int end, char[] chars2, int p2, int n) {
        while (n-- > 0) {
            if (p1 >= end) {
                return chars2[p2];
            }
            char c = chars1[p1];
            int x = chars2[p2] - c;
            if (x != 0) {
                return x;
            }
            ++p2;
            ++p1;
        }
        return 0;
    }

    public static int mbcToCode(byte[] bytes, int p, int end) {
        int code = 0;
        for (int i = p; i < end; ++i) {
            code = code << 8 | bytes[i] & 0xFF;
        }
        return code;
    }

    public static int mbcodeStartPosition() {
        return 128;
    }

    public static char[] caseFoldCodesByString(int flag, char c) {
        if (Character.isUpperCase(c)) {
            return new char[]{Character.toLowerCase(c)};
        }
        if (Character.isLowerCase(c)) {
            return new char[]{Character.toUpperCase(c)};
        }
        return EMPTYCHARS;
    }

    public static void applyAllCaseFold(int flag, ApplyCaseFold fun, Object arg) {
        int[] code = new int[1];
        for (int c = 0; c < 65535; ++c) {
            if (Character.getType(c) != 2) continue;
            int upper = code[0] = Character.toUpperCase(c);
            fun.apply(c, code, 1, arg);
            code[0] = c;
            fun.apply(upper, code, 1, arg);
        }
    }

    public static boolean isInCodeRange(int[] p, int code) {
        int n;
        int low = 0;
        int high = n = p[0];
        while (low < high) {
            int x = low + high >> 1;
            if (code > p[(x << 1) + 2]) {
                low = x + 1;
                continue;
            }
            high = x;
        }
        return low < n && code >= p[(low << 1) + 1];
    }

    public static int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 256;
        int[] range = null;
        if (ctype < codeRanges.length && (range = codeRanges[ctype]) == null) {
            range = new int[16];
            int rangeCount = 0;
            int lastCode = -2;
            for (int code = 0; code <= 65535; ++code) {
                if (!EncodingHelper.isCodeCType(code, ctype)) continue;
                if (lastCode < code - 1) {
                    if (rangeCount * 2 + 2 >= range.length) {
                        range = Arrays.copyOf(range, range.length * 2);
                    }
                    range[rangeCount * 2 + 1] = code;
                    ++rangeCount;
                }
                range[rangeCount * 2] = lastCode = code;
            }
            if (rangeCount * 2 + 1 < range.length) {
                range = Arrays.copyOf(range, rangeCount * 2 + 1);
            }
            range[0] = rangeCount;
            EncodingHelper.codeRanges[ctype] = range;
        }
        return range;
    }

    public static boolean isInCodeRange(int[] p, int offset, int code) {
        int n;
        int low = 0;
        int high = n = p[offset];
        while (low < high) {
            int x = low + high >> 1;
            if (code > p[(x << 1) + 2 + offset]) {
                low = x + 1;
                continue;
            }
            high = x;
        }
        return low < n && code >= p[(low << 1) + 1 + offset];
    }

    public static boolean isCodeCType(int code, int ctype) {
        switch (ctype) {
            case 0: {
                return code == 10;
            }
            case 1: {
                return (1 << Character.getType(code) & 0x1FE) != 0;
            }
            case 2: {
                return code == 9 || Character.getType(code) == 12;
            }
            case 3: {
                int type = Character.getType(code);
                return (1 << type & 0xD8000) != 0 || type == 0;
            }
            case 4: {
                return EncodingHelper.isDigit(code);
            }
            case 5: {
                switch (code) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        return false;
                    }
                }
                int type = Character.getType(code);
                return (1 << type & 0x8F000) == 0 && type != 0;
            }
            case 6: {
                return Character.isLowerCase(code);
            }
            case 7: {
                int type = Character.getType(code);
                return (1 << type & 0x88000) == 0 && type != 0;
            }
            case 8: {
                return (1 << Character.getType(code) & 0x61F00000) != 0;
            }
            case 9: {
                switch (code) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        return true;
                    }
                }
                return (1 << Character.getType(code) & 0x7000) != 0 || code == 65279;
            }
            case 10: {
                return Character.isUpperCase(code);
            }
            case 11: {
                return EncodingHelper.isXDigit(code);
            }
            case 12: {
                return (1 << Character.getType(code) & 0x8003FE) != 0;
            }
            case 13: {
                return (1 << Character.getType(code) & 0x3FE) != 0;
            }
            case 14: {
                return code < 128;
            }
        }
        throw new RuntimeException("illegal character type: " + ctype);
    }
}

