/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.regexp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.regexp.RegExp;
import jdk.nashorn.internal.runtime.regexp.RegExpMatcher;
import jdk.nashorn.internal.runtime.regexp.RegExpScanner;

public class DefaultRegExp
extends RegExp {
    private Pattern pattern;
    private RegExpMatcher matcher;

    public DefaultRegExp(String source, String flags) throws ParserException {
        super(source, flags);
        int intFlags = 0;
        if (this.isIgnoreCase()) {
            intFlags |= 0x42;
        }
        if (this.isMultiline()) {
            intFlags |= 8;
        }
        try {
            RegExpScanner parsed;
            try {
                parsed = RegExpScanner.scan(source);
            }
            catch (PatternSyntaxException e) {
                Pattern.compile(source, intFlags);
                throw e;
            }
            if (parsed != null) {
                this.pattern = Pattern.compile(parsed.getJavaPattern(), intFlags);
                this.groupsInNegativeLookahead = parsed.getGroupsInNegativeLookahead();
            }
        }
        catch (PatternSyntaxException e2) {
            DefaultRegExp.throwParserException("syntax", e2.getMessage());
        }
    }

    @Override
    public RegExpMatcher match(String str) {
        if (this.pattern == null) {
            return null;
        }
        RegExpMatcher matcher = this.matcher;
        if (matcher == null || matcher.getInput() != str) {
            this.matcher = matcher = new DefaultMatcher(str);
        }
        return matcher;
    }

    class DefaultMatcher
    implements RegExpMatcher {
        final String input;
        final Matcher matcher;

        DefaultMatcher(String input) {
            this.input = input;
            this.matcher = DefaultRegExp.this.pattern.matcher(input);
        }

        @Override
        public boolean search(int start) {
            return this.matcher.find(start);
        }

        @Override
        public String getInput() {
            return this.input;
        }

        @Override
        public int start() {
            return this.matcher.start();
        }

        @Override
        public int start(int group) {
            return this.matcher.start(group);
        }

        @Override
        public int end() {
            return this.matcher.end();
        }

        @Override
        public int end(int group) {
            return this.matcher.end(group);
        }

        @Override
        public String group() {
            return this.matcher.group();
        }

        @Override
        public String group(int group) {
            return this.matcher.group(group);
        }

        @Override
        public int groupCount() {
            return this.matcher.groupCount();
        }
    }
}

