/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.SpecializedMethodChooser;
import jdk.nashorn.internal.runtime.linker.Lookup;

public final class ScriptFunctionData {
    private static final MethodHandle BIND_VAR_ARGS = ScriptFunctionData.findOwnMH("bindVarArgs", Object[].class, Object[].class, Object[].class);
    private static final MethodHandle NEWFILTER = ScriptFunctionData.findOwnMH("newFilter", Object.class, Object.class, Object.class);
    private static final int IS_STRICT = 1;
    private static final int IS_BUILTIN = 2;
    private static final int HAS_CALLEE = 4;
    private static final int IS_VARARGS = 8;
    private static final int IS_CONSTRUCTOR = 16;
    private final String name;
    private final Source source;
    private PropertyMap allocatorMap;
    private final long token;
    private int arity;
    private final int flags;
    private MethodHandle invoker;
    private MethodHandle constructor;
    private MethodHandle allocator;
    private MethodHandle genericInvoker;
    private MethodHandle[] invokeSpecializations;
    private MethodHandle[] constructSpecializations;

    public ScriptFunctionData(FunctionNode fn, PropertyMap allocatorMap) {
        long firstToken = fn.getFirstToken();
        long lastToken = fn.getLastToken();
        int position = Token.descPosition(firstToken);
        int length = Token.descPosition(lastToken) - position + Token.descLength(lastToken);
        this.name = fn.isAnonymous() ? "" : fn.getIdent().getName();
        this.source = fn.getSource();
        this.allocatorMap = allocatorMap;
        this.token = Token.toDesc(TokenType.FUNCTION, position, length);
        this.arity = fn.getParameters().size();
        this.flags = ScriptFunctionData.makeFlags(fn.needsCallee(), fn.isVarArg(), fn.isStrictMode(), false, true);
    }

    public ScriptFunctionData(String name, MethodHandle methodHandle, MethodHandle[] specs, boolean strict, boolean builtin, boolean isConstructor) {
        this(name, null, 0L, methodHandle, specs, strict, builtin, isConstructor);
    }

    private ScriptFunctionData(String name, Source source, long token, MethodHandle methodHandle, MethodHandle[] specs, boolean strict, boolean builtin, boolean isConstructor) {
        int lArity;
        this.name = name;
        this.source = source;
        this.token = token;
        boolean isVarArg = ScriptFunctionData.isVarArg(methodHandle);
        boolean needsCallee = ScriptFunctionData.needsCallee(methodHandle);
        this.flags = ScriptFunctionData.makeFlags(needsCallee, isVarArg, strict, builtin, isConstructor);
        int n = lArity = isVarArg ? -1 : methodHandle.type().parameterCount() - 1;
        if (needsCallee && !isVarArg) {
            --lArity;
        }
        if (ScriptFunctionData.isConstructor(methodHandle)) {
            assert (isConstructor);
            if (!isVarArg) {
                --lArity;
            }
            this.invoker = Lookup.MH.insertArguments(methodHandle, 0, false);
            this.constructor = this.composeConstructor(Lookup.MH.insertArguments(methodHandle, 0, true));
            if (specs != null) {
                this.invokeSpecializations = new MethodHandle[specs.length];
                this.constructSpecializations = new MethodHandle[specs.length];
                for (int i = 0; i < specs.length; ++i) {
                    this.invokeSpecializations[i] = Lookup.MH.insertArguments(specs[i], 0, false);
                    this.constructSpecializations[i] = this.composeConstructor(Lookup.MH.insertArguments(specs[i], 0, true));
                }
            }
        } else {
            this.invoker = methodHandle;
            this.constructor = null;
            this.invokeSpecializations = specs;
            this.constructSpecializations = null;
        }
        this.arity = lArity;
    }

    int getArity() {
        return this.arity;
    }

    void setArity(int arity) {
        this.arity = arity;
    }

    String getName() {
        return this.name;
    }

    String toSource() {
        if (this.source != null && this.token != 0L) {
            return this.source.getString(Token.descPosition(this.token), Token.descLength(this.token));
        }
        return "function " + (this.name == null ? "" : this.name) + "() { [native code] }";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" [ ").append(this.invoker).append(", ").append(this.name == null || this.name.isEmpty() ? "<anonymous>" : this.name);
        if (this.source != null) {
            sb.append(" @ ").append(this.source.getName()).append(':').append(this.source.getLine(Token.descPosition(this.token)));
        }
        sb.append(" ]");
        return sb.toString();
    }

    boolean needsCallee() {
        return (this.flags & 4) != 0;
    }

    public boolean isStrict() {
        return (this.flags & 1) != 0;
    }

    private boolean isBuiltin() {
        return (this.flags & 2) != 0;
    }

    private boolean isConstructor() {
        return (this.flags & 0x10) != 0;
    }

    private boolean isVarArg() {
        return (this.flags & 8) != 0;
    }

    boolean needsWrappedThis() {
        return (this.flags & 3) == 0;
    }

    MethodHandle getInvoker() {
        return this.invoker;
    }

    MethodHandle getBestInvoker(MethodType type) {
        return SpecializedMethodChooser.candidateWithLowestWeight(type, this.invoker, this.invokeSpecializations);
    }

    private MethodHandle getConstructor() {
        if (this.constructor == null) {
            this.constructor = this.composeConstructor(this.invoker);
        }
        return this.constructor;
    }

    MethodHandle getBestConstructor(MethodType descType) {
        if (!this.isConstructor()) {
            throw ECMAErrors.typeError("not.a.constructor", this.toSource());
        }
        return SpecializedMethodChooser.candidateWithLowestWeight(descType, this.getConstructor(), this.getConstructSpecializations());
    }

    private MethodHandle composeConstructor(MethodHandle ctor) {
        MethodHandle composedCtor = ScriptFunctionData.changeReturnTypeToObject(this.swapCalleeAndThis(ctor));
        MethodType ctorType = composedCtor.type();
        Class<?>[] ctorArgs = ctorType.dropParameterTypes(0, 1).parameterArray();
        composedCtor = Lookup.MH.foldArguments(Lookup.MH.dropArguments(NEWFILTER, 2, ctorArgs), composedCtor);
        if (this.needsCallee()) {
            return Lookup.MH.foldArguments(composedCtor, ScriptFunction.ALLOCATE);
        }
        return Lookup.MH.filterArguments(composedCtor, 0, ScriptFunction.ALLOCATE);
    }

    private MethodHandle getGenericInvoker() {
        if (this.genericInvoker == null) {
            assert (this.invoker != null) : "invoker is null";
            this.genericInvoker = this.makeGenericMethod(this.invoker);
        }
        return this.genericInvoker;
    }

    Object invoke(ScriptFunction fn, Object self, Object ... arguments) throws Throwable {
        Object[] args;
        MethodHandle genInvoker = this.getGenericInvoker();
        Object selfObj = this.convertThisObject(self);
        Object[] objectArray = args = arguments == null ? ScriptRuntime.EMPTY_ARRAY : arguments;
        if (this.isVarArg()) {
            if (this.needsCallee()) {
                return genInvoker.invokeExact(fn, selfObj, args);
            }
            return genInvoker.invokeExact(selfObj, args);
        }
        int paramCount = genInvoker.type().parameterCount();
        if (this.needsCallee()) {
            switch (paramCount) {
                case 2: {
                    return genInvoker.invokeExact(fn, selfObj);
                }
                case 3: {
                    return genInvoker.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0));
                }
                case 4: {
                    return genInvoker.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1));
                }
                case 5: {
                    return genInvoker.invokeExact(fn, selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2));
                }
            }
            return genInvoker.invokeWithArguments(this.withArguments(fn, selfObj, paramCount, args));
        }
        switch (paramCount) {
            case 1: {
                return genInvoker.invokeExact(selfObj);
            }
            case 2: {
                return genInvoker.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0));
            }
            case 3: {
                return genInvoker.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1));
            }
            case 4: {
                return genInvoker.invokeExact(selfObj, ScriptFunctionData.getArg(args, 0), ScriptFunctionData.getArg(args, 1), ScriptFunctionData.getArg(args, 2));
            }
        }
        return genInvoker.invokeWithArguments(this.withArguments(null, selfObj, paramCount, args));
    }

    private static Object getArg(Object[] args, int i) {
        return i < args.length ? args[i] : ScriptRuntime.UNDEFINED;
    }

    private Object[] withArguments(ScriptFunction fn, Object self, int argCount, Object[] args) {
        Object[] finalArgs = new Object[argCount];
        int nextArg = 0;
        if (this.needsCallee()) {
            assert (fn != null);
            finalArgs[nextArg++] = fn;
        } else assert (fn == null);
        finalArgs[nextArg++] = self;
        int i = 0;
        while (i < args.length && nextArg < argCount) {
            finalArgs[nextArg++] = args[i++];
        }
        while (nextArg < argCount) {
            finalArgs[nextArg++] = ScriptRuntime.UNDEFINED;
        }
        return finalArgs;
    }

    private MethodHandle[] getConstructSpecializations() {
        if (this.constructSpecializations == null && this.invokeSpecializations != null) {
            MethodHandle[] ctors = new MethodHandle[this.invokeSpecializations.length];
            for (int i = 0; i < ctors.length; ++i) {
                ctors[i] = this.composeConstructor(this.invokeSpecializations[i]);
            }
            this.constructSpecializations = ctors;
        }
        return this.constructSpecializations;
    }

    public void setMethodHandles(MethodHandle invoker, MethodHandle allocator) {
        if (this.invoker == null) {
            this.invoker = invoker;
            this.constructor = null;
            this.allocator = allocator;
        }
    }

    void resetInvoker(MethodHandle invoker) {
        this.invoker = invoker;
        this.constructor = null;
    }

    ScriptObject allocate() {
        if (this.allocator == null) {
            return null;
        }
        try {
            return this.allocator.invokeExact(this.allocatorMap);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    ScriptFunctionData makeBoundFunctionData(ScriptFunction fn, Object self, Object[] args) {
        Object[] allArgs = args == null ? ScriptRuntime.EMPTY_ARRAY : args;
        boolean isConstructor = this.isConstructor();
        ScriptFunctionData boundData = new ScriptFunctionData(this.name, this.source, this.token, this.bindInvokeHandle(this.invoker, fn, self, allArgs), this.bindInvokeSpecializations(fn, self, allArgs), this.isStrict(), this.isBuiltin(), isConstructor);
        if (isConstructor) {
            boundData.constructor = ScriptFunctionData.bindConstructHandle(this.getConstructor(), fn, allArgs);
            boundData.constructSpecializations = this.bindConstructorSpecializations(fn, allArgs);
        }
        assert (boundData.allocator == null);
        int thisArity = this.getArity();
        if (thisArity != -1) {
            boundData.setArity(Math.max(0, thisArity - args.length));
        } else assert (boundData.getArity() == -1);
        return boundData;
    }

    Object convertThisObject(Object thiz) {
        if (!(thiz instanceof ScriptObject) && this.needsWrappedThis()) {
            if (JSType.nullOrUndefined(thiz)) {
                return Context.getGlobalTrusted();
            }
            if (ScriptFunctionData.isPrimitiveThis(thiz)) {
                return ((GlobalObject)((Object)Context.getGlobalTrusted())).wrapAsObject(thiz);
            }
        }
        return thiz;
    }

    static boolean isPrimitiveThis(Object obj) {
        return obj instanceof String || obj instanceof ConsString || obj instanceof Number || obj instanceof Boolean;
    }

    private MethodHandle bindInvokeHandle(MethodHandle originalInvoker, ScriptFunction targetFn, Object self, Object[] args) {
        MethodHandle boundInvoker;
        Object boundSelf;
        boolean isTargetBound = targetFn.isBoundFunction();
        assert (!isTargetBound || !this.needsCallee());
        Object object = boundSelf = isTargetBound ? null : this.convertThisObject(self);
        if (ScriptFunctionData.isVarArg(originalInvoker)) {
            MethodHandle noArgBoundInvoker = isTargetBound ? originalInvoker : (this.needsCallee() ? Lookup.MH.insertArguments(originalInvoker, 0, targetFn, boundSelf) : Lookup.MH.bindTo(originalInvoker, boundSelf));
            boundInvoker = args.length > 0 ? ScriptFunctionData.varArgBinder(noArgBoundInvoker, args) : noArgBoundInvoker;
        } else {
            Object[] boundArgs = new Object[Math.min(originalInvoker.type().parameterCount(), args.length + (isTargetBound ? 0 : (this.needsCallee() ? 2 : 1)))];
            int next = 0;
            if (!isTargetBound) {
                if (this.needsCallee()) {
                    boundArgs[next++] = targetFn;
                }
                boundArgs[next++] = boundSelf;
            }
            System.arraycopy(args, 0, boundArgs, next, boundArgs.length - next);
            boundInvoker = Lookup.MH.insertArguments(originalInvoker, isTargetBound ? 1 : 0, boundArgs);
        }
        if (isTargetBound) {
            return boundInvoker;
        }
        return Lookup.MH.dropArguments(boundInvoker, 0, Object.class);
    }

    private MethodHandle[] bindInvokeSpecializations(ScriptFunction fn, Object self, Object[] args) {
        if (this.invokeSpecializations == null) {
            return null;
        }
        MethodHandle[] boundSpecializations = new MethodHandle[this.invokeSpecializations.length];
        for (int i = 0; i < this.invokeSpecializations.length; ++i) {
            boundSpecializations[i] = this.bindInvokeHandle(this.invokeSpecializations[i], fn, self, args);
        }
        return boundSpecializations;
    }

    private static MethodHandle bindConstructHandle(MethodHandle originalConstructor, ScriptFunction fn, Object[] args) {
        Object[] boundArgs;
        MethodHandle calleeBoundConstructor;
        if (originalConstructor == null) {
            return null;
        }
        MethodHandle methodHandle = calleeBoundConstructor = fn.isBoundFunction() ? originalConstructor : Lookup.MH.dropArguments(Lookup.MH.bindTo(originalConstructor, fn), 0, ScriptFunction.class);
        if (args.length == 0) {
            return calleeBoundConstructor;
        }
        if (ScriptFunctionData.isVarArg(calleeBoundConstructor)) {
            return ScriptFunctionData.varArgBinder(calleeBoundConstructor, args);
        }
        int maxArgCount = calleeBoundConstructor.type().parameterCount() - 1;
        if (args.length <= maxArgCount) {
            boundArgs = args;
        } else {
            boundArgs = new Object[maxArgCount];
            System.arraycopy(args, 0, boundArgs, 0, maxArgCount);
        }
        return Lookup.MH.insertArguments(calleeBoundConstructor, 1, boundArgs);
    }

    private MethodHandle[] bindConstructorSpecializations(ScriptFunction fn, Object[] args) {
        MethodHandle[] ctorSpecs = this.getConstructSpecializations();
        if (ctorSpecs == null) {
            return null;
        }
        MethodHandle[] boundSpecializations = new MethodHandle[ctorSpecs.length];
        for (int i = 0; i < ctorSpecs.length; ++i) {
            boundSpecializations[i] = ScriptFunctionData.bindConstructHandle(ctorSpecs[i], fn, args);
        }
        return boundSpecializations;
    }

    private static MethodHandle varArgBinder(MethodHandle mh, Object[] args) {
        assert (args != null);
        assert (args.length > 0);
        return Lookup.MH.filterArguments(mh, mh.type().parameterCount() - 1, Lookup.MH.bindTo(BIND_VAR_ARGS, args));
    }

    private static int makeFlags(boolean needsCallee, boolean isVarArg, boolean isStrict, boolean isBuiltin, boolean isConstructor) {
        int flags = 0;
        if (needsCallee) {
            flags |= 4;
        }
        if (isVarArg) {
            flags |= 8;
        }
        if (isStrict) {
            flags |= 1;
        }
        if (isBuiltin) {
            flags |= 2;
        }
        if (isConstructor) {
            flags |= 0x10;
        }
        return flags;
    }

    private static boolean isConstructor(MethodHandle methodHandle) {
        return methodHandle.type().parameterCount() >= 1 && methodHandle.type().parameterType(0) == Boolean.TYPE;
    }

    private static boolean needsCallee(MethodHandle methodHandle) {
        MethodType type = methodHandle.type();
        int len = type.parameterCount();
        if (len == 0) {
            return false;
        }
        if (type.parameterType(0) == Boolean.TYPE) {
            return len > 1 && type.parameterType(1) == ScriptFunction.class;
        }
        return type.parameterType(0) == ScriptFunction.class;
    }

    private static boolean isVarArg(MethodHandle methodHandle) {
        MethodType type = methodHandle.type();
        return ((Class)type.parameterType(type.parameterCount() - 1)).isArray();
    }

    private MethodHandle makeGenericMethod(MethodHandle handle) {
        MethodType type = handle.type();
        MethodType newType = type.generic();
        if (this.isVarArg()) {
            newType = newType.changeParameterType(type.parameterCount() - 1, Object[].class);
        }
        if (this.needsCallee()) {
            newType = newType.changeParameterType(0, ScriptFunction.class);
        }
        return type.equals((Object)newType) ? handle : handle.asType(newType);
    }

    private static MethodHandle changeReturnTypeToObject(MethodHandle mh) {
        return Lookup.MH.asType(mh, mh.type().changeReturnType(Object.class));
    }

    private MethodHandle swapCalleeAndThis(MethodHandle mh) {
        if (!this.needsCallee()) {
            return mh;
        }
        MethodType type = mh.type();
        assert (type.parameterType(0) == ScriptFunction.class);
        assert (type.parameterType(1) == Object.class);
        MethodType newType = type.changeParameterType(0, Object.class).changeParameterType(1, ScriptFunction.class);
        int[] reorder = new int[type.parameterCount()];
        reorder[0] = 1;
        assert (reorder[1] == 0);
        for (int i = 2; i < reorder.length; ++i) {
            reorder[i] = i;
        }
        return MethodHandles.permuteArguments(mh, newType, reorder);
    }

    private static Object[] bindVarArgs(Object[] array1, Object[] array2) {
        if (array2 == null) {
            return (Object[])array1.clone();
        }
        int l2 = array2.length;
        if (l2 == 0) {
            return (Object[])array1.clone();
        }
        int l1 = array1.length;
        Object[] concat = new Object[l1 + l2];
        System.arraycopy(array1, 0, concat, 0, l1);
        System.arraycopy(array2, 0, concat, l1, l2);
        return concat;
    }

    private static Object newFilter(Object result, Object allocation) {
        return result instanceof ScriptObject || !JSType.isPrimitive(result) ? result : allocation;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), ScriptFunctionData.class, name, Lookup.MH.type(rtype, types));
    }
}

