/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import jdk.internal.dynalink.beans.StaticClass;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.runtime.ConsString;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.GlobalObject;
import jdk.nashorn.internal.runtime.NumberToString;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;

public final class JSType
extends Enum<JSType> {
    public static final /* enum */ JSType UNDEFINED = new JSType();
    public static final /* enum */ JSType NULL = new JSType();
    public static final /* enum */ JSType BOOLEAN = new JSType();
    public static final /* enum */ JSType NUMBER = new JSType();
    public static final /* enum */ JSType STRING = new JSType();
    public static final /* enum */ JSType OBJECT = new JSType();
    public static final /* enum */ JSType FUNCTION = new JSType();
    public static final long MAX_UINT = 0xFFFFFFFFL;
    public static final CompilerConstants.Call TO_BOOLEAN;
    public static final CompilerConstants.Call TO_BOOLEAN_D;
    public static final CompilerConstants.Call TO_INTEGER;
    public static final CompilerConstants.Call TO_LONG;
    public static final CompilerConstants.Call TO_NUMBER;
    public static final CompilerConstants.Call TO_INT32;
    public static final CompilerConstants.Call TO_INT32_D;
    public static final CompilerConstants.Call TO_UINT32;
    public static final CompilerConstants.Call TO_UINT32_D;
    public static final CompilerConstants.Call TO_INT64;
    public static final CompilerConstants.Call TO_INT64_D;
    public static final CompilerConstants.Call TO_STRING;
    public static final CompilerConstants.Call TO_STRING_D;
    public static final CompilerConstants.Call TO_PRIMITIVE;
    private static final /* synthetic */ JSType[] $VALUES;

    public static JSType[] values() {
        return (JSType[])$VALUES.clone();
    }

    public static JSType valueOf(String name) {
        return Enum.valueOf(JSType.class, name);
    }

    public final String typeName() {
        return (this == NULL ? OBJECT : this).name().toLowerCase();
    }

    public static JSType of(Object obj) {
        if (obj == ScriptRuntime.UNDEFINED) {
            return UNDEFINED;
        }
        if (obj == null) {
            return NULL;
        }
        if (obj instanceof Boolean) {
            return BOOLEAN;
        }
        if (obj instanceof Number) {
            return NUMBER;
        }
        if (obj instanceof String || obj instanceof ConsString) {
            return STRING;
        }
        if (obj instanceof ScriptObject) {
            return obj instanceof ScriptFunction ? FUNCTION : OBJECT;
        }
        if (obj instanceof StaticClass) {
            return FUNCTION;
        }
        return OBJECT;
    }

    public static boolean isRepresentableAsInt(long number) {
        return (long)((int)number) == number;
    }

    public static boolean isRepresentableAsInt(double number) {
        return (double)((int)number) == number;
    }

    public static boolean isRepresentableAsLong(double number) {
        return (double)((long)number) == number;
    }

    public static Number narrowestIntegerRepresentation(double number) {
        if (JSType.isRepresentableAsInt(number)) {
            return (int)number;
        }
        if (JSType.isRepresentableAsLong(number)) {
            return (long)number;
        }
        return number;
    }

    public static boolean isPrimitive(Object obj) {
        return obj == null || obj == ScriptRuntime.UNDEFINED || obj instanceof Boolean || obj instanceof Number || obj instanceof String || obj instanceof ConsString;
    }

    public static Object toPrimitive(Object obj) {
        return JSType.toPrimitive(obj, null);
    }

    public static Object toPrimitive(Object obj, Class<?> hint) {
        if (!(obj instanceof ScriptObject)) {
            return obj;
        }
        ScriptObject sobj = (ScriptObject)obj;
        Object result = sobj.getDefaultValue(hint);
        if (!JSType.isPrimitive(result)) {
            throw ECMAErrors.typeError("bad.default.value", result.toString());
        }
        return result;
    }

    public static boolean toBoolean(double num) {
        return num != 0.0 && !Double.isNaN(num);
    }

    public static boolean toBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (JSType.nullOrUndefined(obj)) {
            return false;
        }
        if (obj instanceof Number) {
            double num = ((Number)obj).doubleValue();
            return num != 0.0 && !Double.isNaN(num);
        }
        if (obj instanceof String || obj instanceof ConsString) {
            return ((CharSequence)obj).length() > 0;
        }
        return true;
    }

    public static String toString(Object obj) {
        return JSType.toStringImpl(obj, false);
    }

    public static CharSequence toCharSequence(Object obj) {
        if (obj instanceof ConsString) {
            return (CharSequence)obj;
        }
        return JSType.toString(obj);
    }

    public static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String toString(int num) {
        return Integer.toString(num);
    }

    public static String toString(double num) {
        if (JSType.isRepresentableAsInt(num)) {
            return Integer.toString((int)num);
        }
        if (num == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (num == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (Double.isNaN(num)) {
            return "NaN";
        }
        return NumberToString.stringFor(num);
    }

    public static String toString(double num, int radix) {
        assert (radix >= 2 && radix <= 36) : "invalid radix";
        if (JSType.isRepresentableAsInt(num)) {
            return Integer.toString((int)num, radix);
        }
        if (num == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (num == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (Double.isNaN(num)) {
            return "NaN";
        }
        if (num == 0.0) {
            return "0";
        }
        String chars = "0123456789abcdefghijklmnopqrstuvwxyz";
        StringBuilder sb = new StringBuilder();
        boolean negative = num < 0.0;
        double signedNum = negative ? -num : num;
        double intPart = Math.floor(signedNum);
        double decPart = signedNum - intPart;
        do {
            sb.append("0123456789abcdefghijklmnopqrstuvwxyz".charAt((int)(intPart % (double)radix)));
        } while ((intPart /= (double)radix) >= 1.0);
        if (negative) {
            sb.append('-');
        }
        sb.reverse();
        if (decPart > 0.0) {
            double d;
            int dot = sb.length();
            sb.append('.');
            do {
                d = Math.floor(decPart *= (double)radix);
                sb.append("0123456789abcdefghijklmnopqrstuvwxyz".charAt((int)d));
            } while ((decPart -= d) > 0.0 && sb.length() - dot < 1100);
        }
        return sb.toString();
    }

    public static double toNumber(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return JSType.toNumberGeneric(obj);
    }

    public static int digit(char ch, int radix) {
        return JSType.digit(ch, radix, false);
    }

    public static int digit(char ch, int radix, boolean onlyIsoLatin1) {
        char maxInRadix = (char)(97 + (radix - 1) - 10);
        char c = Character.toLowerCase(ch);
        if (c >= 'a' && c <= maxInRadix) {
            return Character.digit(ch, radix);
        }
        if (Character.isDigit(ch) && (!onlyIsoLatin1 || ch >= '0' && ch <= '9')) {
            return Character.digit(ch, radix);
        }
        return -1;
    }

    public static double toNumber(String str) {
        double value;
        boolean negative;
        int end = str.length();
        if (end == 0) {
            return 0.0;
        }
        int start = 0;
        char f = str.charAt(0);
        while (Lexer.isJSWhitespace(f)) {
            if (++start == end) {
                return 0.0;
            }
            f = str.charAt(start);
        }
        while (Lexer.isJSWhitespace(str.charAt(end - 1))) {
            --end;
        }
        if (f == '-') {
            if (++start == end) {
                return Double.NaN;
            }
            f = str.charAt(start);
            negative = true;
        } else {
            if (f == '+') {
                if (++start == end) {
                    return Double.NaN;
                }
                f = str.charAt(start);
            }
            negative = false;
        }
        if (start + 1 < end && f == '0' && Character.toLowerCase(str.charAt(start + 1)) == 'x') {
            value = JSType.parseRadix(str.toCharArray(), start + 2, end, 16);
        } else {
            if ((f < '0' || f > '9') && f != '.' && f != 'I' && f != 'N') {
                return Double.NaN;
            }
            try {
                value = Double.parseDouble(str.substring(start, end));
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        return negative ? -value : value;
    }

    public static int toInteger(Object obj) {
        return (int)JSType.toNumber(obj);
    }

    public static long toLong(Object obj) {
        return (long)JSType.toNumber(obj);
    }

    public static int toInt32(Object obj) {
        return JSType.toInt32(JSType.toNumber(obj));
    }

    public static int toInt32(long num) {
        return (int)num;
    }

    public static int toInt32(double num) {
        if (Double.isInfinite(num)) {
            return 0;
        }
        return (int)num;
    }

    public static long toInt64(Object obj) {
        return JSType.toInt64(JSType.toNumber(obj));
    }

    public static long toInt64(double num) {
        if (Double.isInfinite(num)) {
            return 0L;
        }
        return (long)num;
    }

    public static long toUint32(Object obj) {
        return JSType.toUint32(JSType.toNumber(obj));
    }

    public static long toUint32(double num) {
        if (Double.isInfinite(num)) {
            return 0L;
        }
        return (long)num & 0xFFFFFFFFL;
    }

    public static int toUint16(Object obj) {
        return JSType.toUint16(JSType.toNumber(obj));
    }

    public static int toUint16(int num) {
        return num & 0xFFFF;
    }

    public static int toUint16(long num) {
        return (int)num & 0xFFFF;
    }

    public static int toUint16(double num) {
        if (Double.isInfinite(num)) {
            return 0;
        }
        return (int)num & 0xFFFF;
    }

    public static boolean isFinite(double num) {
        return !Double.isInfinite(num) && !Double.isNaN(num);
    }

    public static Double toDouble(double num) {
        return num;
    }

    public static Double toDouble(long num) {
        return num;
    }

    public static Double toDouble(int num) {
        return num;
    }

    public static Object toObject(boolean bool) {
        return bool;
    }

    public static Object toObject(int num) {
        return num;
    }

    public static Object toObject(long num) {
        return num;
    }

    public static Object toObject(double num) {
        return num;
    }

    public static Object toObject(Object obj) {
        return obj;
    }

    public static Object toScriptObject(Object obj) {
        return JSType.toScriptObject(Context.getGlobalTrusted(), obj);
    }

    public static Object toScriptObject(ScriptObject global, Object obj) {
        if (JSType.nullOrUndefined(obj)) {
            throw ECMAErrors.typeError(global, "not.an.object", ScriptRuntime.safeToString(obj));
        }
        if (obj instanceof ScriptObject) {
            return obj;
        }
        return ((GlobalObject)((Object)global)).wrapAsObject(obj);
    }

    public static boolean nullOrUndefined(Object obj) {
        return obj == null || obj == ScriptRuntime.UNDEFINED;
    }

    static String toStringImpl(Object obj, boolean safe) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Number) {
            return JSType.toString(((Number)obj).doubleValue());
        }
        if (obj == ScriptRuntime.UNDEFINED) {
            return "undefined";
        }
        if (obj == null) {
            return "null";
        }
        if (obj instanceof ScriptObject) {
            if (safe) {
                ScriptObject sobj = (ScriptObject)obj;
                GlobalObject gobj = (GlobalObject)((Object)Context.getGlobalTrusted());
                return gobj.isError(sobj) ? ECMAException.safeToString(sobj) : sobj.safeToString();
            }
            return JSType.toString(JSType.toPrimitive(obj, String.class));
        }
        if (obj instanceof StaticClass) {
            return "[JavaClass " + ((StaticClass)obj).getRepresentedClass().getName() + "]";
        }
        return obj.toString();
    }

    static String trimLeft(String str) {
        int start;
        for (start = 0; start < str.length() && Lexer.isJSWhitespace(str.charAt(start)); ++start) {
        }
        return str.substring(start);
    }

    private static double parseRadix(char[] chars, int start, int length, int radix) {
        int pos = 0;
        for (int i = start; i < length && JSType.digit(chars[i], radix) != -1; ++i) {
            ++pos;
        }
        if (pos == 0) {
            return Double.NaN;
        }
        double value = 0.0;
        for (int i = start; i < start + pos; ++i) {
            value *= (double)radix;
            value += (double)JSType.digit(chars[i], radix);
        }
        return value;
    }

    private static double toNumberGeneric(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof String) {
            return JSType.toNumber((String)obj);
        }
        if (obj instanceof ConsString) {
            return JSType.toNumber(obj.toString());
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        if (obj instanceof ScriptObject) {
            return JSType.toNumber(JSType.toPrimitive(obj, Number.class));
        }
        return Double.NaN;
    }

    static {
        $VALUES = new JSType[]{UNDEFINED, NULL, BOOLEAN, NUMBER, STRING, OBJECT, FUNCTION};
        TO_BOOLEAN = CompilerConstants.staticCall(JSType.class, "toBoolean", Boolean.TYPE, Object.class);
        TO_BOOLEAN_D = CompilerConstants.staticCall(JSType.class, "toBoolean", Boolean.TYPE, Double.TYPE);
        TO_INTEGER = CompilerConstants.staticCall(JSType.class, "toInteger", Integer.TYPE, Object.class);
        TO_LONG = CompilerConstants.staticCall(JSType.class, "toLong", Long.TYPE, Object.class);
        TO_NUMBER = CompilerConstants.staticCall(JSType.class, "toNumber", Double.TYPE, Object.class);
        TO_INT32 = CompilerConstants.staticCall(JSType.class, "toInt32", Integer.TYPE, Object.class);
        TO_INT32_D = CompilerConstants.staticCall(JSType.class, "toInt32", Integer.TYPE, Double.TYPE);
        TO_UINT32 = CompilerConstants.staticCall(JSType.class, "toUint32", Long.TYPE, Object.class);
        TO_UINT32_D = CompilerConstants.staticCall(JSType.class, "toUint32", Long.TYPE, Double.TYPE);
        TO_INT64 = CompilerConstants.staticCall(JSType.class, "toInt64", Long.TYPE, Object.class);
        TO_INT64_D = CompilerConstants.staticCall(JSType.class, "toInt64", Long.TYPE, Double.TYPE);
        TO_STRING = CompilerConstants.staticCall(JSType.class, "toString", String.class, Object.class);
        TO_STRING_D = CompilerConstants.staticCall(JSType.class, "toString", String.class, Double.TYPE);
        TO_PRIMITIVE = CompilerConstants.staticCall(JSType.class, "toPrimitive", Object.class, Object.class);
    }
}

