/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.parser;

import java.util.ArrayList;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.parser.AbstractParser;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.TokenStream;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.Source;

public class JSONParser
extends AbstractParser {
    public JSONParser(Source source, ErrorManager errors, boolean strict) {
        super(source, errors, strict);
    }

    public static String quote(String value) {
        StringBuilder product = new StringBuilder();
        product.append("\"");
        block9: for (char ch : value.toCharArray()) {
            switch (ch) {
                case '\\': {
                    product.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    product.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    product.append("\\b");
                    continue block9;
                }
                case '\f': {
                    product.append("\\f");
                    continue block9;
                }
                case '\n': {
                    product.append("\\n");
                    continue block9;
                }
                case '\r': {
                    product.append("\\r");
                    continue block9;
                }
                case '\t': {
                    product.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch < ' ') {
                        product.append(Lexer.unicodeEscape(ch));
                        continue block9;
                    }
                    product.append(ch);
                }
            }
        }
        product.append("\"");
        return product.toString();
    }

    public Node parse() {
        this.stream = new TokenStream();
        this.lexer = new Lexer(this.source, this.stream){

            @Override
            protected boolean skipComments() {
                return false;
            }

            @Override
            protected boolean isStringDelimiter(char ch) {
                return ch == '\"';
            }

            @Override
            protected boolean isWhitespace(char ch) {
                return Lexer.isJsonWhitespace(ch);
            }

            @Override
            protected boolean isEOL(char ch) {
                return Lexer.isJsonEOL(ch);
            }
        };
        this.k = -1;
        this.next();
        Node resultNode = this.jsonLiteral();
        this.expect(TokenType.EOF);
        return resultNode;
    }

    private LiteralNode<?> getStringLiteral() {
        LiteralNode<?> literal = this.getLiteral();
        String str = (String)literal.getValue();
        block3: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                default: {
                    if (ch > '\u001f') continue block3;
                }
                case '\"': 
                case '\\': {
                    this.error(AbstractParser.message("unexpected.token", str));
                }
            }
        }
        return literal;
    }

    private Node jsonLiteral() {
        long literalToken = this.token;
        switch (this.type) {
            case STRING: {
                return this.getStringLiteral();
            }
            case ESCSTRING: 
            case DECIMAL: 
            case FLOATING: {
                return this.getLiteral();
            }
            case FALSE: {
                this.next();
                return LiteralNode.newInstance(this.source, literalToken, this.finish, false);
            }
            case TRUE: {
                this.next();
                return LiteralNode.newInstance(this.source, literalToken, this.finish, true);
            }
            case NULL: {
                this.next();
                return LiteralNode.newInstance(this.source, literalToken, this.finish);
            }
            case LBRACKET: {
                return this.arrayLiteral();
            }
            case LBRACE: {
                return this.objectLiteral();
            }
            case SUB: {
                this.next();
                long realToken = this.token;
                Object value = this.getValue();
                if (value instanceof Number) {
                    this.next();
                    return new UnaryNode(this.source, literalToken, LiteralNode.newInstance(this.source, realToken, this.finish, (Number)value));
                }
                this.error(AbstractParser.message("expected", "number", this.type.getNameOrType()));
                break;
            }
        }
        this.error(AbstractParser.message("expected", "json literal", this.type.getNameOrType()));
        return null;
    }

    private Node arrayLiteral() {
        long arrayToken = this.token;
        this.next();
        LiteralNode<Node[]> result = null;
        ArrayList<Node> elements = new ArrayList<Node>();
        block4: while (true) {
            switch (this.type) {
                case RBRACKET: {
                    this.next();
                    result = LiteralNode.newInstance(this.source, arrayToken, this.finish, elements);
                    break block4;
                }
                case COMMARIGHT: {
                    this.next();
                    continue block4;
                }
                default: {
                    elements.add(this.jsonLiteral());
                    if (this.type == TokenType.COMMARIGHT || this.type == TokenType.RBRACKET) continue block4;
                    this.error(AbstractParser.message("expected", ", or ]", this.type.getNameOrType()));
                    continue block4;
                }
            }
            break;
        }
        return result;
    }

    private Node objectLiteral() {
        long objectToken = this.token;
        this.next();
        ArrayList<Node> elements = new ArrayList<Node>();
        block4: while (true) {
            switch (this.type) {
                case RBRACE: {
                    this.next();
                    break block4;
                }
                case COMMARIGHT: {
                    this.next();
                    continue block4;
                }
                default: {
                    Node property = this.propertyAssignment();
                    elements.add(property);
                    if (this.type == TokenType.RBRACE || this.type == TokenType.COMMARIGHT) continue block4;
                    this.error(AbstractParser.message("expected", ", or }", this.type.getNameOrType()));
                    continue block4;
                }
            }
            break;
        }
        return new ObjectNode(this.source, objectToken, this.finish, null, elements);
    }

    private Node propertyAssignment() {
        long propertyToken = this.token;
        LiteralNode<?> name = null;
        if (this.type == TokenType.STRING) {
            name = this.getStringLiteral();
        } else if (this.type == TokenType.ESCSTRING) {
            name = this.getLiteral();
        }
        if (name != null) {
            this.expect(TokenType.COLON);
            Node value = this.jsonLiteral();
            return new PropertyNode(this.source, propertyToken, value.getFinish(), name, value);
        }
        this.error(AbstractParser.message("expected", "string", this.type.getNameOrType()));
        return null;
    }
}

