/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class TernaryNode
extends BinaryNode {
    private Node third;

    public TernaryNode(Source source, long token, Node lhs, Node rhs, Node third) {
        super(source, token, lhs, rhs);
        this.finish = third.getFinish();
        this.third = third;
    }

    private TernaryNode(TernaryNode ternaryNode, Node.CopyState cs) {
        super(ternaryNode, cs);
        this.third = cs.existingOrCopy(ternaryNode.third);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new TernaryNode(this, cs);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.third.equals(((TernaryNode)other).third());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.third().hashCode();
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.lhs = this.lhs.accept(visitor);
            this.rhs = this.rhs.accept(visitor);
            this.third = this.third.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean lhsParen = this.tokenType().needsParens(this.lhs().tokenType(), true);
        boolean rhsParen = this.tokenType().needsParens(this.rhs().tokenType(), false);
        boolean thirdParen = this.tokenType().needsParens(this.third().tokenType(), false);
        if (lhsParen) {
            sb.append('(');
        }
        this.lhs().toString(sb);
        if (lhsParen) {
            sb.append(')');
        }
        sb.append(" ? ");
        if (rhsParen) {
            sb.append('(');
        }
        this.rhs().toString(sb);
        if (rhsParen) {
            sb.append(')');
        }
        sb.append(" : ");
        if (thirdParen) {
            sb.append('(');
        }
        this.third().toString(sb);
        if (thirdParen) {
            sb.append(')');
        }
    }

    public Node third() {
        return this.third;
    }

    public void setThird(Node third) {
        this.third = third;
    }
}

