/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LabeledNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class BreakNode
extends LabeledNode {
    public BreakNode(Source source, long token, int finish, LabelNode labelNode, Node targetNode, TryNode tryChain) {
        super(source, token, finish, labelNode, targetNode, tryChain);
        this.setHasGoto();
    }

    private BreakNode(BreakNode breakNode, Node.CopyState cs) {
        super(breakNode, cs);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new BreakNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            return visitor.leave(this);
        }
        return this;
    }

    public Label getTargetLabel() {
        if (this.targetNode instanceof BreakableNode) {
            return ((BreakableNode)this.targetNode).getBreakLabel();
        }
        if (this.targetNode instanceof Block) {
            return ((Block)this.targetNode).getBreakLabel();
        }
        throw new AssertionError((Object)("Invalid break target " + this.targetNode.getClass()));
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("break");
        if (this.labelNode != null) {
            sb.append(' ');
            this.labelNode.getLabel().toString(sb);
        }
    }
}

