/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.List;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.MapCreator;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.PropertyMap;

public abstract class ObjectCreator {
    protected final CompileUnit compileUnit;
    protected final List<String> keys;
    protected final List<Symbol> symbols;
    protected final CodeGenerator codegen;
    private final boolean isScope;
    private final boolean hasArguments;
    private int fieldCount;
    private int paramCount;
    private String fieldObjectClassName;
    private Class<?> fieldObjectClass;
    private PropertyMap propertyMap;

    protected ObjectCreator(CodeGenerator codegen, List<String> keys, List<Symbol> symbols, boolean isScope, boolean hasArguments) {
        this.codegen = codegen;
        this.compileUnit = codegen.getCurrentCompileUnit();
        this.keys = keys;
        this.symbols = symbols;
        this.isScope = isScope;
        this.hasArguments = hasArguments;
        this.countFields();
        this.findClass();
    }

    private void countFields() {
        for (Symbol symbol : this.symbols) {
            if (symbol == null) continue;
            if (this.hasArguments() && symbol.isParam()) {
                symbol.setFieldIndex(this.paramCount++);
                continue;
            }
            symbol.setFieldIndex(this.fieldCount++);
        }
    }

    private void findClass() {
        this.fieldObjectClassName = this.isScope() ? ObjectClassGenerator.getClassName(this.fieldCount, this.paramCount) : ObjectClassGenerator.getClassName(this.fieldCount);
        try {
            this.fieldObjectClass = Context.forStructureClass(Compiler.binaryName(this.fieldObjectClassName));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)"Nashorn has encountered an internal error.  Structure can not be created.");
        }
    }

    protected abstract void makeObject(MethodEmitter var1);

    protected MapCreator newMapCreator(Class<?> clazz) {
        return new MapCreator(clazz, this.keys, this.symbols);
    }

    protected PropertyMap makeMap() {
        this.propertyMap = this.keys.isEmpty() ? PropertyMap.newMap(this.fieldObjectClass) : this.newMapCreator(this.fieldObjectClass).makeMap(this.hasArguments());
        return this.propertyMap;
    }

    protected MethodEmitter loadMap(MethodEmitter method) {
        this.codegen.loadConstant(this.propertyMap);
        return method;
    }

    String getClassName() {
        return this.fieldObjectClassName;
    }

    protected boolean isScope() {
        return this.isScope;
    }

    protected boolean hasArguments() {
        return this.hasArguments;
    }
}

