/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.Serializable;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Location;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;

final class FoldConstants
extends NodeVisitor {
    private static final DebugLogger LOG = new DebugLogger("fold");

    FoldConstants() {
    }

    @Override
    public Node leave(UnaryNode unaryNode) {
        LiteralNode<?> literalNode = new UnaryNodeConstantEvaluator(unaryNode).eval();
        if (literalNode != null) {
            LOG.info("Unary constant folded " + unaryNode + " to " + literalNode);
            return literalNode;
        }
        return unaryNode;
    }

    @Override
    public Node leave(BinaryNode binaryNode) {
        LiteralNode<?> literalNode = new BinaryNodeConstantEvaluator(binaryNode).eval();
        if (literalNode != null) {
            LOG.info("Binary constant folded " + binaryNode + " to " + literalNode);
            return literalNode;
        }
        return binaryNode;
    }

    @Override
    public Node leave(IfNode ifNode) {
        Node test = ifNode.getTest();
        if (test instanceof LiteralNode) {
            Block shortCut;
            Block block = shortCut = ((LiteralNode)test).isTrue() ? ifNode.getPass() : ifNode.getFail();
            if (shortCut != null) {
                return new ExecuteNode(shortCut);
            }
            return new EmptyNode(ifNode);
        }
        return ifNode;
    }

    @Override
    public Node leave(TernaryNode ternaryNode) {
        Node test = ternaryNode.lhs();
        if (test instanceof LiteralNode) {
            return ((LiteralNode)test).isTrue() ? ternaryNode.rhs() : ternaryNode.third();
        }
        return ternaryNode;
    }

    private static class BinaryNodeConstantEvaluator
    extends ConstantEvaluator<BinaryNode> {
        BinaryNodeConstantEvaluator(BinaryNode parent) {
            super(parent);
        }

        @Override
        protected LiteralNode<?> eval() {
            LiteralNode<?> result = this.reduceTwoLiterals();
            if (result != null) {
                return result;
            }
            result = this.reduceOneLiteral();
            if (result != null) {
                return result;
            }
            return null;
        }

        private LiteralNode<?> reduceOneLiteral() {
            return null;
        }

        private LiteralNode<?> reduceTwoLiterals() {
            double value;
            if (!(((BinaryNode)this.parent).lhs() instanceof LiteralNode) || !(((BinaryNode)this.parent).rhs() instanceof LiteralNode)) {
                return null;
            }
            LiteralNode lhs = (LiteralNode)((BinaryNode)this.parent).lhs();
            LiteralNode rhs = (LiteralNode)((BinaryNode)this.parent).rhs();
            Type widest = Type.widest(lhs.getType(), rhs.getType());
            boolean isInteger = widest.isInteger();
            boolean isLong = widest.isLong();
            switch (((BinaryNode)this.parent).tokenType()) {
                case DIV: {
                    value = lhs.getNumber() / rhs.getNumber();
                    break;
                }
                case ADD: {
                    if ((lhs.isString() || rhs.isNumeric()) && (rhs.isString() || rhs.isNumeric())) {
                        Object res = ScriptRuntime.ADD(lhs.getObject(), rhs.getObject());
                        if (res instanceof Number) {
                            value = ((Number)res).doubleValue();
                            break;
                        }
                        assert (res instanceof CharSequence) : res + " was not a CharSequence, it was a " + res.getClass();
                        return LiteralNode.newInstance(this.source, this.token, this.finish, res.toString());
                    }
                    return null;
                }
                case MUL: {
                    value = lhs.getNumber() * rhs.getNumber();
                    break;
                }
                case MOD: {
                    value = lhs.getNumber() % rhs.getNumber();
                    break;
                }
                case SUB: {
                    value = lhs.getNumber() - rhs.getNumber();
                    break;
                }
                case SHR: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, (long)(lhs.getInt32() >>> rhs.getInt32()) & 0xFFFFFFFFL);
                }
                case SAR: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() >> rhs.getInt32());
                }
                case SHL: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() << rhs.getInt32());
                }
                case BIT_XOR: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() ^ rhs.getInt32());
                }
                case BIT_AND: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() & rhs.getInt32());
                }
                case BIT_OR: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, lhs.getInt32() | rhs.getInt32());
                }
                case GE: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.GE(lhs.getObject(), rhs.getObject()));
                }
                case LE: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.LE(lhs.getObject(), rhs.getObject()));
                }
                case GT: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.GT(lhs.getObject(), rhs.getObject()));
                }
                case LT: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.LT(lhs.getObject(), rhs.getObject()));
                }
                case NE: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.NE(lhs.getObject(), rhs.getObject()));
                }
                case NE_STRICT: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.NE_STRICT(lhs.getObject(), rhs.getObject()));
                }
                case EQ: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.EQ(lhs.getObject(), rhs.getObject()));
                }
                case EQ_STRICT: {
                    return LiteralNode.newInstance(this.source, this.token, this.finish, ScriptRuntime.EQ_STRICT(lhs.getObject(), rhs.getObject()));
                }
                default: {
                    return null;
                }
            }
            isLong &= value != 0.0 && JSType.isRepresentableAsLong(value);
            if (isInteger &= value != 0.0 && JSType.isRepresentableAsInt(value)) {
                return LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toInt32(value));
            }
            if (isLong) {
                return LiteralNode.newInstance(this.source, this.token, this.finish, JSType.toLong(value));
            }
            return LiteralNode.newInstance(this.source, this.token, this.finish, value);
        }
    }

    private static class UnaryNodeConstantEvaluator
    extends ConstantEvaluator<UnaryNode> {
        UnaryNodeConstantEvaluator(UnaryNode parent) {
            super(parent);
        }

        @Override
        protected LiteralNode<?> eval() {
            LiteralNode<Serializable> literalNode;
            Node rhsNode = ((UnaryNode)this.parent).rhs();
            if (!(rhsNode instanceof LiteralNode)) {
                return null;
            }
            LiteralNode rhs = (LiteralNode)rhsNode;
            boolean rhsInteger = rhs.getType().isInteger();
            switch (((UnaryNode)this.parent).tokenType()) {
                case ADD: {
                    if (rhsInteger) {
                        literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, rhs.getInt32());
                        break;
                    }
                    literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, rhs.getNumber());
                    break;
                }
                case SUB: {
                    if (rhsInteger && rhs.getInt32() != 0) {
                        literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, -rhs.getInt32());
                        break;
                    }
                    literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, -rhs.getNumber());
                    break;
                }
                case NOT: {
                    literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, !rhs.getBoolean());
                    break;
                }
                case BIT_NOT: {
                    literalNode = LiteralNode.newInstance(this.source, this.token, this.finish, ~rhs.getInt32());
                    break;
                }
                default: {
                    return null;
                }
            }
            return literalNode;
        }
    }

    static abstract class ConstantEvaluator<T extends Node> {
        protected T parent;
        protected final Source source;
        protected final long token;
        protected final int finish;

        protected ConstantEvaluator(T parent) {
            this.parent = parent;
            this.source = ((Location)parent).getSource();
            this.token = ((Location)parent).getToken();
            this.finish = ((Node)parent).getFinish();
        }

        protected abstract LiteralNode<?> eval();
    }
}

