/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;

final class Attr
extends NodeOperatorVisitor {
    private final Context context;
    private Set<String> localDefs;
    private Set<String> localUses;
    private static final DebugLogger LOG = new DebugLogger("attr");
    private static final boolean DEBUG = LOG.isEnabled();

    Attr(Context context) {
        this.context = context;
    }

    @Override
    protected Node enterDefault(Node node) {
        return this.start(node);
    }

    @Override
    protected Node leaveDefault(Node node) {
        return this.end(node);
    }

    @Override
    public Node leave(AccessNode accessNode) {
        this.newTemporary(Type.OBJECT, accessNode);
        this.end(accessNode);
        return accessNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node enter(Block block) {
        this.start(block);
        Set<String> savedLocalDefs = this.localDefs;
        Set<String> savedLocalUses = this.localUses;
        block.setFrame(this.getCurrentFunctionNode().pushFrame());
        try {
            this.localDefs = new HashSet<String>(savedLocalDefs);
            this.localUses = new HashSet<String>(savedLocalUses);
            for (Node statement : block.getStatements()) {
                statement.accept(this);
            }
        }
        finally {
            this.localDefs = savedLocalDefs;
            this.localUses = savedLocalUses;
            this.getCurrentFunctionNode().popFrame();
        }
        this.end(block);
        return null;
    }

    @Override
    public Node enter(CallNode callNode) {
        this.start(callNode);
        callNode.getFunction().accept(this);
        ArrayList<Node> acceptedArgs = new ArrayList<Node>(callNode.getArgs().size());
        for (Node arg : callNode.getArgs()) {
            LOG.info("Doing call arg " + arg);
            acceptedArgs.add(arg.accept(this));
        }
        callNode.setArgs(acceptedArgs);
        CallNode.EvalArgs evalArgs = callNode.getEvalArgs();
        if (evalArgs != null) {
            evalArgs.setCode(evalArgs.getCode().accept(this));
            IdentNode thisNode = new IdentNode(this.getCurrentFunctionNode().getThisNode());
            assert (thisNode.getSymbol() != null);
            evalArgs.setThis(thisNode);
        }
        this.newTemporary(Type.OBJECT, callNode);
        Attr.newType(callNode.getFunction().getSymbol(), Type.OBJECT);
        this.end(callNode);
        return null;
    }

    @Override
    public Node enter(CatchNode catchNode) {
        IdentNode exception = catchNode.getException();
        Block block = this.getCurrentBlock();
        this.start(catchNode);
        Symbol def = block.defineSymbol(exception.getName(), 259, exception);
        Attr.newType(def, Type.OBJECT);
        this.addLocalDef(exception.getName());
        return catchNode;
    }

    @Override
    public Node enter(FunctionNode functionNode) {
        this.start(functionNode, false);
        if (functionNode.isLazy()) {
            LOG.info("LAZY: " + functionNode.getName());
            this.end(functionNode);
            return null;
        }
        this.clearLocalDefs();
        this.clearLocalUses();
        functionNode.setFrame(functionNode.pushFrame());
        Attr.initCallee(functionNode);
        Attr.initThis(functionNode);
        if (functionNode.isVarArg()) {
            this.initVarArg(functionNode);
        }
        this.initParameters(functionNode);
        Attr.initScope(functionNode);
        Attr.initReturn(functionNode);
        for (FunctionNode nestedFunction : functionNode.getFunctions()) {
            IdentNode ident = nestedFunction.getIdent();
            if (ident == null || !nestedFunction.isStatement()) continue;
            Symbol functionSymbol = functionNode.defineSymbol(ident.getName(), 3, nestedFunction);
            Attr.newType(functionSymbol, Type.typeFor(ScriptFunction.class));
        }
        if (functionNode.isScript()) {
            Attr.initFromPropertyMap(this.context, functionNode);
        }
        if (!(functionNode.isStatement() || functionNode.isAnonymous() || functionNode.isScript())) {
            Symbol selfSymbol = functionNode.defineSymbol(functionNode.getIdent().getName(), 3, functionNode);
            Attr.newType(selfSymbol, Type.OBJECT);
            selfSymbol.setNode(functionNode);
        }
        ArrayList<Symbol> declaredSymbols = new ArrayList<Symbol>();
        for (VarNode decl : functionNode.getDeclarations()) {
            IdentNode ident = decl.getName();
            declaredSymbols.add(functionNode.defineSymbol(ident.getName(), 3, new IdentNode(ident)));
        }
        for (FunctionNode nestedFunction : functionNode.getFunctions()) {
            VarNode varNode = nestedFunction.getFunctionVarNode();
            if (varNode == null) continue;
            varNode.accept(this);
            assert (varNode.isFunctionVarNode()) : varNode + " should be function var node";
        }
        for (Node statement : functionNode.getStatements()) {
            if (statement instanceof VarNode && ((VarNode)statement).isFunctionVarNode()) continue;
            statement.accept(this);
        }
        for (FunctionNode nestedFunction : functionNode.getFunctions()) {
            LOG.info("Going into nested function " + functionNode.getName() + " -> " + nestedFunction.getName());
            nestedFunction.accept(this);
        }
        Attr.finalizeParameters(functionNode);
        Attr.finalizeTypes(functionNode);
        for (Symbol symbol : declaredSymbols) {
            if (!symbol.getSymbolType().isUnknown()) continue;
            symbol.setType(Type.OBJECT);
            symbol.setCanBeUndefined();
        }
        if (functionNode.getReturnType().isUnknown()) {
            LOG.info("Unknown return type promoted to object");
            functionNode.setReturnType(Type.OBJECT);
        }
        if (functionNode.getSelfSymbolInit() != null) {
            LOG.info("Accepting self symbol init " + functionNode.getSelfSymbolInit() + " for " + functionNode.getName());
            Node init = functionNode.getSelfSymbolInit();
            ArrayList<Node> newStatements = new ArrayList<Node>();
            newStatements.add(init);
            newStatements.addAll(functionNode.getStatements());
            functionNode.setStatements(newStatements);
            functionNode.setNeedsSelfSymbol(functionNode.getSelfSymbolInit().accept(this));
        }
        functionNode.popFrame();
        this.end(functionNode, false);
        return null;
    }

    @Override
    public Node leaveCONVERT(UnaryNode unaryNode) {
        assert (false) : "There should be no convert operators in IR during Attribution";
        this.end(unaryNode);
        return unaryNode;
    }

    @Override
    public Node enter(IdentNode identNode) {
        String name = identNode.getName();
        this.start(identNode);
        if (identNode.isPropertyName()) {
            Symbol pseudoSymbol = Attr.pseudoSymbol(name);
            LOG.info("IdentNode is property name -> assigning pseudo symbol " + pseudoSymbol);
            LOG.unindent();
            identNode.setSymbol(pseudoSymbol);
            return null;
        }
        Block block = this.getCurrentBlock();
        Symbol oldSymbol = identNode.getSymbol();
        Symbol symbol = block.findSymbol(name);
        if (symbol != null) {
            LOG.info("Existing symbol = " + symbol);
            if (Attr.isFunctionExpressionSelfReference(symbol)) {
                FunctionNode functionNode = (FunctionNode)symbol.getNode();
                assert (functionNode.getCalleeNode() != null);
                VarNode var = new VarNode(functionNode.getSource(), functionNode.getToken(), functionNode.getFinish(), functionNode.getIdent(), functionNode.getCalleeNode());
                functionNode.setNeedsSelfSymbol(var);
            }
            if (!identNode.isInitializedHere() && !this.isLocalDef(name)) {
                Attr.newType(symbol, Type.OBJECT);
                symbol.setCanBeUndefined();
            }
            identNode.setSymbol(symbol);
            if (!this.getCurrentFunctionNode().isLocal(symbol) && !symbol.isScope()) {
                List<Block> lookupBlocks = Attr.findLookupBlocksHelper(this.getCurrentFunctionNode(), symbol.findFunction());
                for (Block lookupBlock : lookupBlocks) {
                    Symbol refSymbol = lookupBlock.findSymbol(name);
                    if (refSymbol == null) continue;
                    LOG.finest("Found a ref symbol that must be scope " + refSymbol);
                    refSymbol.setIsScope();
                }
            }
        } else {
            LOG.info("No symbol exists. Declare undefined: " + symbol);
            symbol = block.useSymbol(name, identNode);
            Attr.newType(symbol, Type.OBJECT);
            symbol.setCanBeUndefined();
            symbol.setIsScope();
        }
        assert (symbol != null);
        if (symbol.isGlobal()) {
            this.getCurrentFunctionNode().setUsesGlobalSymbol();
        } else if (symbol.isScope()) {
            this.getCurrentFunctionNode().setUsesScopeSymbol(symbol);
        }
        if (symbol != oldSymbol && !identNode.isInitializedHere()) {
            symbol.increaseUseCount();
        }
        this.addLocalUse(identNode.getName());
        this.end(identNode);
        return null;
    }

    @Override
    public Node leave(IndexNode indexNode) {
        this.newTemporary(Type.OBJECT, indexNode);
        return indexNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node enter(LiteralNode literalNode) {
        try {
            this.start(literalNode);
            assert (!literalNode.isTokenType(TokenType.THIS)) : "tokentype for " + literalNode + " is this";
            if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
                LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)literalNode;
                Node[] array = (Node[])arrayLiteralNode.getValue();
                for (int i = 0; i < array.length; ++i) {
                    Node element = array[i];
                    if (element == null) continue;
                    array[i] = element.accept(this);
                }
                arrayLiteralNode.analyze();
            } else assert (!(literalNode.getValue() instanceof Node)) : "literals with Node values not supported";
            this.getCurrentFunctionNode().newLiteral(literalNode);
        }
        finally {
            this.end(literalNode);
        }
        return null;
    }

    @Override
    public Node leave(ObjectNode objectNode) {
        this.newTemporary(Type.OBJECT, objectNode);
        this.end(objectNode);
        return objectNode;
    }

    @Override
    public Node enter(PropertyNode propertyNode) {
        propertyNode.setSymbol(new Symbol(propertyNode.getKeyName(), 0, Type.OBJECT));
        this.end(propertyNode);
        return propertyNode;
    }

    @Override
    public Node enter(ReferenceNode referenceNode) {
        FunctionNode functionNode = referenceNode.getReference();
        if (functionNode != null) {
            functionNode.addReferencingParentBlock(this.getCurrentBlock());
        }
        return referenceNode;
    }

    @Override
    public Node leave(ReferenceNode referenceNode) {
        this.newTemporary(Type.OBJECT, referenceNode);
        FunctionNode functionNode = referenceNode.getReference();
        if (functionNode.isLazy()) {
            LOG.info("Lazy function node call reference: " + functionNode.getName() + " => Promoting to OBJECT");
            functionNode.setReturnType(Type.OBJECT);
        }
        this.end(referenceNode);
        return referenceNode;
    }

    @Override
    public Node leave(ReturnNode returnNode) {
        Node expr = returnNode.getExpression();
        if (expr != null) {
            Symbol symbol = expr.getSymbol();
            if (expr.getType().isUnknown() && symbol.isParam()) {
                symbol.setType(Type.OBJECT);
            }
            this.getCurrentFunctionNode().setReturnType(Type.widest(this.getCurrentFunctionNode().getReturnType(), symbol.getSymbolType()));
            LOG.info("Returntype is now " + this.getCurrentFunctionNode().getReturnType());
        }
        this.end(returnNode);
        return returnNode;
    }

    @Override
    public Node leave(SwitchNode switchNode) {
        Type type = Type.UNKNOWN;
        for (CaseNode caseNode : switchNode.getCases()) {
            Node test = caseNode.getTest();
            if (test == null) continue;
            if (test instanceof LiteralNode) {
                LiteralNode lit = (LiteralNode)test;
                if (lit.isNumeric() && !(lit.getValue() instanceof Integer) && JSType.isRepresentableAsInt(lit.getNumber())) {
                    caseNode.setTest(LiteralNode.newInstance((Node)lit, lit.getInt32()).accept(this));
                }
            } else {
                type = Type.OBJECT;
                break;
            }
            type = Type.widest(type, caseNode.getTest().getType());
        }
        if (!type.isInteger()) {
            type = Type.OBJECT;
        }
        switchNode.setTag(this.newInternal(this.getCurrentFunctionNode().uniqueName(CompilerConstants.SWITCH_TAG_PREFIX.tag()), type));
        this.end(switchNode);
        return switchNode;
    }

    @Override
    public Node leave(TryNode tryNode) {
        tryNode.setException(this.exceptionSymbol());
        if (tryNode.getFinallyBody() != null) {
            tryNode.setFinallyCatchAll(this.exceptionSymbol());
        }
        this.end(tryNode);
        return tryNode;
    }

    @Override
    public Node enter(VarNode varNode) {
        this.start(varNode);
        IdentNode ident = varNode.getName();
        String name = ident.getName();
        Symbol symbol = this.getCurrentBlock().defineSymbol(name, 3, ident);
        assert (symbol != null);
        LOG.info("VarNode " + varNode + " set symbol " + symbol);
        varNode.setSymbol(symbol);
        if (this.localUses.contains(ident.getName())) {
            Attr.newType(symbol, Type.OBJECT);
            symbol.setCanBeUndefined();
        }
        if (varNode.getInit() != null) {
            varNode.getInit().accept(this);
        }
        return varNode;
    }

    @Override
    public Node leave(VarNode varNode) {
        Node init = varNode.getInit();
        IdentNode ident = varNode.getName();
        String name = ident.getName();
        if (init != null) {
            this.addLocalDef(name);
        }
        if (init == null) {
            this.removeLocalDef(name);
            return varNode;
        }
        Symbol symbol = varNode.getSymbol();
        boolean isScript = symbol.getBlock().getFunction().isScript();
        if ((init.getType().isNumeric() || init.getType().isBoolean()) && !isScript) {
            Attr.newType(symbol, init.getType());
        } else {
            Attr.newType(symbol, Type.OBJECT);
        }
        assert (varNode.hasType()) : varNode;
        this.end(varNode);
        return varNode;
    }

    @Override
    public Node leaveADD(UnaryNode unaryNode) {
        this.newTemporary(Attr.arithType(), unaryNode);
        this.end(unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveBIT_NOT(UnaryNode unaryNode) {
        this.newTemporary(Type.INT, unaryNode);
        this.end(unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveDECINC(UnaryNode unaryNode) {
        Attr.ensureAssignmentSlots(this.getCurrentFunctionNode(), unaryNode.rhs());
        Type type = Attr.arithType();
        Attr.newType(unaryNode.rhs().getSymbol(), type);
        this.newTemporary(type, unaryNode);
        this.end(unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveDELETE(UnaryNode unaryNode) {
        FunctionNode currentFunctionNode = this.getCurrentFunctionNode();
        boolean strictMode = currentFunctionNode.isStrictMode();
        Node rhs = unaryNode.rhs();
        Node strictFlagNode = LiteralNode.newInstance((Node)unaryNode, strictMode).accept(this);
        RuntimeNode.Request request = RuntimeNode.Request.DELETE;
        ArrayList<Node> args = new ArrayList<Node>();
        if (rhs instanceof IdentNode) {
            boolean failDelete;
            String name = ((IdentNode)rhs).getName();
            boolean bl = failDelete = strictMode || rhs.getSymbol().isParam() || rhs.getSymbol().isVar() && !rhs.getSymbol().isTopLevel();
            if (failDelete && rhs.getSymbol().isThis()) {
                return LiteralNode.newInstance((Node)unaryNode, true).accept(this);
            }
            Node literalNode = LiteralNode.newInstance((Node)unaryNode, name).accept(this);
            if (!failDelete) {
                args.add(currentFunctionNode.getScopeNode());
            }
            args.add(literalNode);
            args.add(strictFlagNode);
            if (failDelete) {
                request = RuntimeNode.Request.FAIL_DELETE;
            }
        } else if (rhs instanceof AccessNode) {
            Node base = ((AccessNode)rhs).getBase();
            IdentNode property = ((AccessNode)rhs).getProperty();
            args.add(base);
            args.add(LiteralNode.newInstance((Node)unaryNode, property.getName()).accept(this));
            args.add(strictFlagNode);
        } else if (rhs instanceof IndexNode) {
            Node base = ((IndexNode)rhs).getBase();
            Node index = ((IndexNode)rhs).getIndex();
            args.add(base);
            args.add(index);
            args.add(strictFlagNode);
        } else {
            return LiteralNode.newInstance((Node)unaryNode, true).accept(this);
        }
        RuntimeNode runtimeNode = new RuntimeNode((Node)unaryNode, request, args);
        assert (runtimeNode.getSymbol() == unaryNode.getSymbol());
        runtimeNode.accept(this);
        return runtimeNode;
    }

    @Override
    public Node leaveNEW(UnaryNode unaryNode) {
        this.newTemporary(Type.OBJECT, unaryNode);
        this.end(unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveNOT(UnaryNode unaryNode) {
        this.newTemporary(Type.BOOLEAN, unaryNode);
        this.end(unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveTYPEOF(UnaryNode unaryNode) {
        Node rhs = unaryNode.rhs();
        ArrayList<Node> args = new ArrayList<Node>();
        if (rhs instanceof IdentNode && !rhs.getSymbol().isParam() && !rhs.getSymbol().isVar()) {
            args.add(this.getCurrentFunctionNode().getScopeNode());
            args.add(LiteralNode.newInstance(rhs, ((IdentNode)rhs).getName()).accept(this));
        } else {
            args.add(rhs);
            args.add(LiteralNode.newInstance(unaryNode).accept(this));
        }
        RuntimeNode runtimeNode = new RuntimeNode((Node)unaryNode, RuntimeNode.Request.TYPEOF, args);
        assert (runtimeNode.getSymbol() == unaryNode.getSymbol());
        runtimeNode.accept(this);
        this.end(unaryNode);
        return runtimeNode;
    }

    @Override
    public Node leave(RuntimeNode runtimeNode) {
        this.newTemporary(runtimeNode.getRequest().getReturnType(), runtimeNode);
        return runtimeNode;
    }

    @Override
    public Node leaveSUB(UnaryNode unaryNode) {
        this.newTemporary(Attr.arithType(), unaryNode);
        this.end(unaryNode);
        return unaryNode;
    }

    @Override
    public Node leaveVOID(UnaryNode unaryNode) {
        RuntimeNode runtimeNode = new RuntimeNode(unaryNode, RuntimeNode.Request.VOID);
        runtimeNode.accept(this);
        assert (runtimeNode.getSymbol().getSymbolType().isObject());
        this.end(unaryNode);
        return runtimeNode;
    }

    @Override
    public Node leaveADD(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Attr.ensureTypeNotUnknown(lhs);
        Attr.ensureTypeNotUnknown(rhs);
        this.newTemporary(Type.widest(lhs.getType(), rhs.getType()), binaryNode);
        this.end(binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveAND(BinaryNode binaryNode) {
        this.newTemporary(Type.OBJECT, binaryNode);
        this.end(binaryNode);
        return binaryNode;
    }

    private Node enterAssignmentNode(BinaryNode binaryNode) {
        this.start(binaryNode);
        Node lhs = binaryNode.lhs();
        if (lhs instanceof IdentNode) {
            Block block = this.getCurrentBlock();
            IdentNode ident = (IdentNode)lhs;
            String name = ident.getName();
            Symbol symbol = this.getCurrentBlock().findSymbol(name);
            if (symbol == null) {
                symbol = block.defineSymbol(name, 2, ident);
                binaryNode.setSymbol(symbol);
            } else if (!this.getCurrentFunctionNode().isLocal(symbol)) {
                symbol.setIsScope();
            }
            this.addLocalDef(name);
        }
        return binaryNode;
    }

    @Override
    public Node enterASSIGN(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN(BinaryNode binaryNode) {
        return this.leaveAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_ADD(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_ADD(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type widest = Type.widest(lhs.getType(), rhs.getType());
        return this.leaveSelfModifyingAssignmentNode(binaryNode, widest.isNumeric() ? Type.NUMBER : Type.OBJECT);
    }

    @Override
    public Node enterASSIGN_BIT_AND(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_AND(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_BIT_OR(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_OR(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_BIT_XOR(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_DIV(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_DIV(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_MOD(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MOD(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_MUL(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_MUL(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_SAR(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SAR(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_SHL(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHL(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_SHR(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SHR(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node enterASSIGN_SUB(BinaryNode binaryNode) {
        return this.enterAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveASSIGN_SUB(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode);
    }

    @Override
    public Node leaveBIT_AND(BinaryNode binaryNode) {
        this.newTemporary(Type.INT, binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveBIT_OR(BinaryNode binaryNode) {
        this.newTemporary(Type.INT, binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveBIT_XOR(BinaryNode binaryNode) {
        this.newTemporary(Type.INT, binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveCOMMARIGHT(BinaryNode binaryNode) {
        this.newTemporary(binaryNode.rhs().getType(), binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveCOMMALEFT(BinaryNode binaryNode) {
        this.newTemporary(binaryNode.lhs().getType(), binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveDIV(BinaryNode binaryNode) {
        return this.leaveBinaryArithmetic(binaryNode);
    }

    private Node leaveCmp(BinaryNode binaryNode, RuntimeNode.Request request) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        this.newTemporary(Type.BOOLEAN, binaryNode);
        Attr.ensureTypeNotUnknown(lhs);
        Attr.ensureTypeNotUnknown(rhs);
        this.end(binaryNode);
        return binaryNode;
    }

    private Node leaveBinaryArithmetic(BinaryNode binaryNode) {
        if (!Compiler.shouldUseIntegerArithmetic()) {
            this.newTemporary(Type.NUMBER, binaryNode);
            return binaryNode;
        }
        this.newTemporary(Type.widest(binaryNode.lhs().getType(), binaryNode.rhs().getType(), Type.NUMBER), binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveEQ(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.EQ);
    }

    @Override
    public Node leaveEQ_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.EQ_STRICT);
    }

    @Override
    public Node leaveGE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.GE);
    }

    @Override
    public Node leaveGT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.GT);
    }

    @Override
    public Node leaveIN(BinaryNode binaryNode) {
        try {
            Node node = new RuntimeNode(binaryNode, RuntimeNode.Request.IN).accept(this);
            return node;
        }
        finally {
            this.end(binaryNode);
        }
    }

    @Override
    public Node leaveINSTANCEOF(BinaryNode binaryNode) {
        try {
            Node node = new RuntimeNode(binaryNode, RuntimeNode.Request.INSTANCEOF).accept(this);
            return node;
        }
        finally {
            this.end(binaryNode);
        }
    }

    @Override
    public Node leaveLE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.LE);
    }

    @Override
    public Node leaveLT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.LT);
    }

    @Override
    public Node leaveMOD(BinaryNode binaryNode) {
        return this.leaveBinaryArithmetic(binaryNode);
    }

    @Override
    public Node leaveMUL(BinaryNode binaryNode) {
        return this.leaveBinaryArithmetic(binaryNode);
    }

    @Override
    public Node leaveNE(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.NE);
    }

    @Override
    public Node leaveNE_STRICT(BinaryNode binaryNode) {
        return this.leaveCmp(binaryNode, RuntimeNode.Request.NE_STRICT);
    }

    @Override
    public Node leaveOR(BinaryNode binaryNode) {
        this.newTemporary(Type.OBJECT, binaryNode);
        this.end(binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveSAR(BinaryNode binaryNode) {
        this.newTemporary(Type.INT, binaryNode);
        this.end(binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveSHL(BinaryNode binaryNode) {
        this.newTemporary(Type.INT, binaryNode);
        this.end(binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveSHR(BinaryNode binaryNode) {
        this.newTemporary(Type.LONG, binaryNode);
        this.end(binaryNode);
        return binaryNode;
    }

    @Override
    public Node leaveSUB(BinaryNode binaryNode) {
        return this.leaveBinaryArithmetic(binaryNode);
    }

    @Override
    public Node leave(ForNode forNode) {
        if (forNode.isForIn()) {
            forNode.setIterator(this.newInternal(this.getCurrentFunctionNode(), this.getCurrentFunctionNode().uniqueName(CompilerConstants.ITERATOR_PREFIX.tag()), Type.OBJECT));
            Attr.newType(forNode.getInit().getSymbol(), Type.OBJECT);
        }
        this.end(forNode);
        return forNode;
    }

    @Override
    public Node leave(TernaryNode ternaryNode) {
        Node lhs = ternaryNode.rhs();
        Node rhs = ternaryNode.third();
        Attr.ensureTypeNotUnknown(lhs);
        Attr.ensureTypeNotUnknown(rhs);
        Type type = Type.widest(lhs.getType(), rhs.getType());
        this.newTemporary(type, ternaryNode);
        this.end(ternaryNode);
        return ternaryNode;
    }

    private static void initThis(FunctionNode functionNode) {
        Symbol thisSymbol = functionNode.defineSymbol(CompilerConstants.THIS.tag(), 36, null);
        Attr.newType(thisSymbol, Type.OBJECT);
        thisSymbol.setNeedsSlot(true);
        functionNode.getThisNode().setSymbol(thisSymbol);
        LOG.info("Initialized scope symbol: " + thisSymbol);
    }

    private static void initScope(FunctionNode functionNode) {
        Symbol scopeSymbol = functionNode.defineSymbol(CompilerConstants.SCOPE.tag(), 515, null);
        Attr.newType(scopeSymbol, Type.typeFor(ScriptObject.class));
        scopeSymbol.setNeedsSlot(true);
        functionNode.getScopeNode().setSymbol(scopeSymbol);
        LOG.info("Initialized scope symbol: " + scopeSymbol);
    }

    private static void initReturn(FunctionNode functionNode) {
        Symbol returnSymbol = functionNode.defineSymbol(CompilerConstants.SCRIPT_RETURN.tag(), 515, null);
        Attr.newType(returnSymbol, Type.OBJECT);
        returnSymbol.setNeedsSlot(true);
        functionNode.getResultNode().setSymbol(returnSymbol);
        LOG.info("Initialized return symbol: " + returnSymbol);
    }

    private void initVarArg(FunctionNode functionNode) {
        if (functionNode.isVarArg()) {
            Symbol varArgsSymbol = functionNode.defineSymbol(CompilerConstants.VARARGS.tag(), 516, null);
            varArgsSymbol.setTypeOverride(Type.OBJECT_ARRAY);
            varArgsSymbol.setNeedsSlot(true);
            functionNode.getVarArgsNode().setSymbol(varArgsSymbol);
            LOG.info("Initialized varargs symbol: " + varArgsSymbol);
            if (functionNode.needsArguments()) {
                String argumentsName = functionNode.getArgumentsNode().getName();
                Symbol argumentsSymbol = functionNode.defineSymbol(argumentsName, 515, null);
                Attr.newType(argumentsSymbol, Type.typeFor(ScriptObject.class));
                argumentsSymbol.setNeedsSlot(true);
                functionNode.getArgumentsNode().setSymbol(argumentsSymbol);
                this.addLocalDef(argumentsName);
                LOG.info("Initialized vararg varArgsSymbol=" + varArgsSymbol + " argumentsSymbol=" + argumentsSymbol);
            }
        }
    }

    private static void initCallee(FunctionNode functionNode) {
        assert (functionNode.getCalleeNode() != null) : functionNode + " has no callee";
        Symbol calleeSymbol = functionNode.defineSymbol(CompilerConstants.CALLEE.tag(), 516, null);
        Attr.newType(calleeSymbol, Type.typeFor(ScriptFunction.class));
        calleeSymbol.setNeedsSlot(true);
        functionNode.getCalleeNode().setSymbol(calleeSymbol);
        LOG.info("Initialized callee symbol " + calleeSymbol);
    }

    private void initParameters(FunctionNode functionNode) {
        functionNode.setReturnType(Type.UNKNOWN);
        for (IdentNode ident : functionNode.getParameters()) {
            this.addLocalDef(ident.getName());
            Symbol paramSymbol = functionNode.defineSymbol(ident.getName(), 4, ident);
            if (paramSymbol != null) {
                Attr.newType(paramSymbol, Type.UNKNOWN);
            }
            LOG.info("Initialized param " + paramSymbol);
        }
    }

    private static void finalizeParameters(FunctionNode functionNode) {
        boolean nonObjectParams = false;
        ArrayList<Type> paramSpecializations = new ArrayList<Type>();
        for (IdentNode ident : functionNode.getParameters()) {
            Symbol paramSymbol = ident.getSymbol();
            if (paramSymbol == null) continue;
            Type type = paramSymbol.getSymbolType();
            if (type.isUnknown()) {
                type = Type.OBJECT;
            }
            paramSpecializations.add(type);
            if (!type.isObject()) {
                nonObjectParams = true;
            }
            Attr.newType(paramSymbol, Type.OBJECT);
        }
        if (!nonObjectParams) {
            paramSpecializations = null;
        } else {
            LOG.info("parameter specialization possible: " + functionNode.getName() + " " + paramSpecializations);
        }
        if (functionNode.isVarArg()) {
            for (IdentNode param : functionNode.getParameters()) {
                param.getSymbol().setNeedsSlot(false);
            }
        }
    }

    private static void initFromPropertyMap(Context context, FunctionNode functionNode) {
        assert (functionNode.isScript());
        PropertyMap map = Context.getGlobalMap();
        for (Property property : map.getProperties()) {
            String key = property.getKey();
            Symbol symbol = functionNode.defineSymbol(key, 2, null);
            Attr.newType(symbol, Type.OBJECT);
            LOG.info("Added global symbol from property map " + symbol);
        }
    }

    private static void ensureTypeNotUnknown(Node node) {
        Symbol symbol = node.getSymbol();
        LOG.info("Ensure type not unknown for: " + symbol);
        if (node.getType().isUnknown() || symbol.isParam()) {
            Attr.newType(symbol, Type.OBJECT);
            symbol.setCanBeUndefined();
        }
    }

    private static Symbol pseudoSymbol(String name) {
        return new Symbol(name, 0, Type.OBJECT);
    }

    private Symbol exceptionSymbol() {
        return this.newInternal(this.getCurrentFunctionNode().uniqueName(CompilerConstants.EXCEPTION_PREFIX.tag()), Type.typeFor(ECMAException.class));
    }

    private static void ensureAssignmentSlots(FunctionNode functionNode, Node assignmentDest) {
        assignmentDest.accept(new NodeVisitor(){

            @Override
            public Node leave(IndexNode indexNode) {
                Node index = indexNode.getIndex();
                index.getSymbol().setNeedsSlot(!index.getSymbol().isConstant());
                return indexNode;
            }
        });
    }

    private static Type arithType() {
        return Compiler.shouldUseIntegerArithmetic() ? Type.INT : Type.NUMBER;
    }

    private static void finalizeTypes(FunctionNode functionNode) {
        final HashSet changed = new HashSet();
        do {
            changed.clear();
            functionNode.accept(new NodeVisitor(){

                private void widen(Node node, Type to) {
                    if (node instanceof LiteralNode) {
                        return;
                    }
                    Type from = node.getType();
                    if (!Type.areEquivalent(from, to) && Type.widest(from, to) == to) {
                        LOG.fine("Had to post pass widen '" + node + "' " + Debug.id(node) + " from " + node.getType() + " to " + to);
                        Attr.newType(node.getSymbol(), to);
                        changed.add(node);
                    }
                }

                @Override
                public Node enter(FunctionNode node) {
                    return node.isLazy() ? null : node;
                }

                @Override
                public Node leave(BinaryNode binaryNode) {
                    Type widest = Type.widest(binaryNode.lhs().getType(), binaryNode.rhs().getType());
                    switch (binaryNode.tokenType()) {
                        default: {
                            if (!binaryNode.isAssignment() || binaryNode.isSelfModifying()) break;
                            this.widen(binaryNode.lhs(), widest);
                        }
                        case ADD: {
                            this.widen(binaryNode, widest);
                        }
                    }
                    return binaryNode;
                }
            });
        } while (!changed.isEmpty());
    }

    private Node leaveAssignmentNode(BinaryNode binaryNode) {
        Node lhs = binaryNode.lhs();
        Node rhs = binaryNode.rhs();
        Type type = rhs.getType().isNumeric() ? Type.widest(binaryNode.lhs().getType(), binaryNode.rhs().getType()) : Type.OBJECT;
        this.newTemporary(type, binaryNode);
        Attr.newType(lhs.getSymbol(), type);
        this.end(binaryNode);
        return binaryNode;
    }

    private Node leaveSelfModifyingAssignmentNode(BinaryNode binaryNode) {
        return this.leaveSelfModifyingAssignmentNode(binaryNode, binaryNode.getWidestOperationType());
    }

    private Node leaveSelfModifyingAssignmentNode(BinaryNode binaryNode, Type destType) {
        Node lhs = binaryNode.lhs();
        Attr.newType(lhs.getSymbol(), destType);
        this.newTemporary(destType, binaryNode);
        Attr.ensureAssignmentSlots(this.getCurrentFunctionNode(), binaryNode);
        this.end(binaryNode);
        return binaryNode;
    }

    private static List<Block> findLookupBlocksHelper(FunctionNode currentFunction, FunctionNode topFunction) {
        if (currentFunction.findParentFunction() == topFunction) {
            LinkedList<Block> blocks = new LinkedList<Block>();
            blocks.add(currentFunction.getParent());
            blocks.addAll(currentFunction.getReferencingParentBlocks());
            return blocks;
        }
        return Attr.findLookupBlocksHelper(currentFunction.findParentFunction(), topFunction);
    }

    private static boolean isFunctionExpressionSelfReference(Symbol symbol) {
        if (symbol.isVar() && symbol.getNode() == symbol.getBlock() && symbol.getNode() instanceof FunctionNode) {
            return ((FunctionNode)symbol.getNode()).getIdent().getName().equals(symbol.getName());
        }
        return false;
    }

    private static Symbol newTemporary(FunctionNode functionNode, Type type, Node node) {
        LOG.info("New TEMPORARY added to " + functionNode.getName() + " type=" + type);
        return functionNode.newTemporary(type, node);
    }

    private Symbol newTemporary(Type type, Node node) {
        return Attr.newTemporary(this.getCurrentFunctionNode(), type, node);
    }

    private Symbol newInternal(FunctionNode functionNode, String name, Type type) {
        Symbol iter = this.getCurrentFunctionNode().defineSymbol(name, 515, null);
        iter.setType(type);
        return iter;
    }

    private Symbol newInternal(String name, Type type) {
        return this.newInternal(this.getCurrentFunctionNode(), name, type);
    }

    private static void newType(Symbol symbol, Type type) {
        Type oldType = symbol.getSymbolType();
        symbol.setType(type);
        if (symbol.getSymbolType() != oldType) {
            LOG.info("New TYPE " + type + " for " + symbol + " (was " + oldType + ")");
        }
        if (symbol.isParam()) {
            symbol.setType(type);
            LOG.info("Param type change " + symbol);
        }
    }

    private void clearLocalDefs() {
        this.localDefs = new HashSet<String>();
    }

    private boolean isLocalDef(String name) {
        return this.localDefs.contains(name);
    }

    private void addLocalDef(String name) {
        LOG.info("Adding local def of symbol: '" + name + "'");
        this.localDefs.add(name);
    }

    private void removeLocalDef(String name) {
        LOG.info("Removing local def of symbol: '" + name + "'");
        this.localDefs.remove(name);
    }

    private void clearLocalUses() {
        this.localUses = new HashSet<String>();
    }

    private void addLocalUse(String name) {
        LOG.info("Adding local use of symbol: '" + name + "'");
        this.localUses.add(name);
    }

    private static String name(Node node) {
        String cn = node.getClass().getName();
        int lastDot = cn.lastIndexOf(46);
        if (lastDot == -1) {
            return cn;
        }
        return cn.substring(lastDot + 1);
    }

    private Node start(Node node) {
        return this.start(node, true);
    }

    private Node start(Node node, boolean printNode) {
        if (DEBUG) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ENTER ").append(Attr.name(node)).append("] ").append(printNode ? node.toString() : "").append(" in '").append(this.getCurrentFunctionNode().getName()).append("'");
            LOG.info(sb.toString());
            LOG.indent();
        }
        return node;
    }

    private Node end(Node node) {
        return this.end(node, true);
    }

    private Node end(Node node, boolean printNode) {
        if (DEBUG) {
            StringBuilder sb = new StringBuilder();
            sb.append("[LEAVE ").append(Attr.name(node)).append("] ").append(printNode ? node.toString() : "").append(" in '").append(this.getCurrentFunctionNode().getName());
            if (node.getSymbol() == null) {
                sb.append(" <NO SYMBOL>");
            } else {
                sb.append(" <symbol=").append(node.getSymbol()).append('>');
            }
            LOG.unindent();
            LOG.info(sb.toString());
        }
        return node;
    }
}

