/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.api.scripting;

import jdk.nashorn.internal.runtime.ECMAErrors;

public abstract class NashornException
extends RuntimeException {
    private final String fileName;
    private final int line;
    private final int column;
    public static final String ENGINE_SCRIPT_SOURCE_NAME = "nashorn:engine/resources/engine.js";

    protected NashornException(String msg, String fileName, int line, int column) {
        this(msg, null, fileName, line, column);
    }

    protected NashornException(String msg, Throwable cause, String fileName, int line, int column) {
        super(msg, cause == null ? null : cause);
        this.fileName = fileName;
        this.line = line;
        this.column = column;
    }

    protected NashornException(String msg, Throwable cause) {
        super(msg, cause == null ? null : cause);
        this.column = -1;
        for (StackTraceElement ste : this.getStackTrace()) {
            if (!ECMAErrors.isScriptFrame(ste)) continue;
            this.fileName = ste.getFileName();
            this.line = ste.getLineNumber();
            return;
        }
        this.fileName = null;
        this.line = 0;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getLineNumber() {
        return this.line;
    }

    public final int getColumnNumber() {
        return this.column;
    }
}

