/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TypeUtilities {
    static final Class<Object> OBJECT_CLASS = Object.class;
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPES = TypeUtilities.createWrapperTypes();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES = TypeUtilities.invertMap(WRAPPER_TYPES);
    private static final Map<String, Class<?>> PRIMITIVE_TYPES_BY_NAME = TypeUtilities.createClassNameMapping(WRAPPER_TYPES.keySet());
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPES = TypeUtilities.createWrapperToPrimitiveTypes();
    private static final Set<Class<?>> PRIMITIVE_WRAPPER_TYPES = TypeUtilities.createPrimitiveWrapperTypes();

    private TypeUtilities() {
    }

    public static Class<?> getMostSpecificCommonType(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return c1;
        }
        Class<Object> c3 = c2;
        if (c3.isPrimitive()) {
            if (c3 == Byte.TYPE) {
                c3 = Byte.class;
            } else if (c3 == Short.TYPE) {
                c3 = Short.class;
            } else if (c3 == Character.TYPE) {
                c3 = Character.class;
            } else if (c3 == Integer.TYPE) {
                c3 = Integer.class;
            } else if (c3 == Float.TYPE) {
                c3 = Float.class;
            } else if (c3 == Long.TYPE) {
                c3 = Long.class;
            } else if (c3 == Double.TYPE) {
                c3 = Double.class;
            }
        }
        Set<Class<Class<?>>> a1 = TypeUtilities.getAssignables(c1, c3);
        Set<Class<?>> a2 = TypeUtilities.getAssignables(c3, c1);
        a1.retainAll(a2);
        if (a1.isEmpty()) {
            return Object.class;
        }
        ArrayList max = new ArrayList();
        block0: for (Class<?> clazz : a1) {
            Iterator maxiter = max.iterator();
            while (maxiter.hasNext()) {
                Class maxClazz = (Class)maxiter.next();
                if (TypeUtilities.isSubtype(maxClazz, clazz)) continue block0;
                if (!TypeUtilities.isSubtype(clazz, maxClazz)) continue;
                maxiter.remove();
            }
            max.add(clazz);
        }
        if (max.size() > 1) {
            return OBJECT_CLASS;
        }
        return (Class)max.get(0);
    }

    private static Set<Class<?>> getAssignables(Class<?> c1, Class<?> c2) {
        HashSet s = new HashSet();
        TypeUtilities.collectAssignables(c1, c2, s);
        return s;
    }

    private static void collectAssignables(Class<?> c1, Class<?> c2, Set<Class<?>> s) {
        Class<?> sc;
        if (c1.isAssignableFrom(c2)) {
            s.add(c1);
        }
        if ((sc = c1.getSuperclass()) != null) {
            TypeUtilities.collectAssignables(sc, c2, s);
        }
        Class<?>[] itf = c1.getInterfaces();
        for (int i = 0; i < itf.length; ++i) {
            TypeUtilities.collectAssignables(itf[i], c2, s);
        }
    }

    private static Map<Class<?>, Class<?>> createWrapperTypes() {
        IdentityHashMap<Class<Comparable<Boolean>>, Class> wrapperTypes = new IdentityHashMap<Class<Comparable<Boolean>>, Class>(8);
        wrapperTypes.put(Boolean.TYPE, Boolean.class);
        wrapperTypes.put(Byte.TYPE, Byte.class);
        wrapperTypes.put(Character.TYPE, Character.class);
        wrapperTypes.put(Short.TYPE, Short.class);
        wrapperTypes.put(Integer.TYPE, Integer.class);
        wrapperTypes.put(Long.TYPE, Long.class);
        wrapperTypes.put(Float.TYPE, Float.class);
        wrapperTypes.put(Double.TYPE, Double.class);
        return Collections.unmodifiableMap(wrapperTypes);
    }

    private static Map<String, Class<?>> createClassNameMapping(Collection<Class<?>> classes) {
        HashMap map = new HashMap();
        for (Class<?> clazz : classes) {
            map.put(clazz.getName(), clazz);
        }
        return map;
    }

    private static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        IdentityHashMap<V, K> inverted = new IdentityHashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverted.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(inverted);
    }

    public static boolean isMethodInvocationConvertible(Class<?> callSiteType, Class<?> methodType) {
        if (methodType.isAssignableFrom(callSiteType)) {
            return true;
        }
        if (callSiteType.isPrimitive()) {
            if (methodType.isPrimitive()) {
                return TypeUtilities.isProperPrimitiveSubtype(callSiteType, methodType);
            }
            return methodType.isAssignableFrom(WRAPPER_TYPES.get(callSiteType));
        }
        if (methodType.isPrimitive()) {
            Class<?> unboxedCallSiteType = PRIMITIVE_TYPES.get(callSiteType);
            return unboxedCallSiteType != null && (unboxedCallSiteType == methodType || TypeUtilities.isProperPrimitiveSubtype(unboxedCallSiteType, methodType));
        }
        return false;
    }

    public static boolean isPotentiallyConvertible(Class<?> callSiteType, Class<?> methodType) {
        if (methodType.isAssignableFrom(callSiteType) || callSiteType.isAssignableFrom(methodType)) {
            return true;
        }
        if (callSiteType.isPrimitive()) {
            return methodType.isPrimitive() || TypeUtilities.isAssignableFromBoxedPrimitive(methodType);
        }
        if (methodType.isPrimitive()) {
            return TypeUtilities.isAssignableFromBoxedPrimitive(callSiteType);
        }
        return false;
    }

    public static boolean isSubtype(Class<?> subType, Class<?> superType) {
        if (superType.isAssignableFrom(subType)) {
            return true;
        }
        if (superType.isPrimitive() && subType.isPrimitive()) {
            return TypeUtilities.isProperPrimitiveSubtype(subType, superType);
        }
        return false;
    }

    private static boolean isProperPrimitiveSubtype(Class<?> subType, Class<?> superType) {
        if (superType == Boolean.TYPE || subType == Boolean.TYPE) {
            return false;
        }
        if (subType == Byte.TYPE) {
            return superType != Character.TYPE;
        }
        if (subType == Character.TYPE) {
            return superType != Short.TYPE && superType != Byte.TYPE;
        }
        if (subType == Short.TYPE) {
            return superType != Character.TYPE && superType != Byte.TYPE;
        }
        if (subType == Integer.TYPE) {
            return superType == Long.TYPE || superType == Float.TYPE || superType == Double.TYPE;
        }
        if (subType == Long.TYPE) {
            return superType == Float.TYPE || superType == Double.TYPE;
        }
        if (subType == Float.TYPE) {
            return superType == Double.TYPE;
        }
        return false;
    }

    private static Map<Class<?>, Class<?>> createWrapperToPrimitiveTypes() {
        IdentityHashMap classes = new IdentityHashMap();
        classes.put(Void.class, Void.TYPE);
        classes.put(Boolean.class, Boolean.TYPE);
        classes.put(Byte.class, Byte.TYPE);
        classes.put(Character.class, Character.TYPE);
        classes.put(Short.class, Short.TYPE);
        classes.put(Integer.class, Integer.TYPE);
        classes.put(Long.class, Long.TYPE);
        classes.put(Float.class, Float.TYPE);
        classes.put(Double.class, Double.TYPE);
        return classes;
    }

    private static Set<Class<?>> createPrimitiveWrapperTypes() {
        IdentityHashMap classes = new IdentityHashMap();
        TypeUtilities.addClassHierarchy(classes, Boolean.class);
        TypeUtilities.addClassHierarchy(classes, Byte.class);
        TypeUtilities.addClassHierarchy(classes, Character.class);
        TypeUtilities.addClassHierarchy(classes, Short.class);
        TypeUtilities.addClassHierarchy(classes, Integer.class);
        TypeUtilities.addClassHierarchy(classes, Long.class);
        TypeUtilities.addClassHierarchy(classes, Float.class);
        TypeUtilities.addClassHierarchy(classes, Double.class);
        return classes.keySet();
    }

    private static void addClassHierarchy(Map<Class<?>, Class<?>> map, Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        map.put(clazz, clazz);
        TypeUtilities.addClassHierarchy(map, clazz.getSuperclass());
        for (Class<?> itf : clazz.getInterfaces()) {
            TypeUtilities.addClassHierarchy(map, itf);
        }
    }

    private static boolean isAssignableFromBoxedPrimitive(Class<?> clazz) {
        return PRIMITIVE_WRAPPER_TYPES.contains(clazz);
    }

    public static Class<?> getPrimitiveTypeByName(String name) {
        return PRIMITIVE_TYPES_BY_NAME.get(name);
    }

    public static Class<?> getPrimitiveType(Class<?> wrapperType) {
        return WRAPPER_TO_PRIMITIVE_TYPES.get(wrapperType);
    }

    public static Class<?> getWrapperType(Class<?> primitiveType) {
        return WRAPPER_TYPES.get(primitiveType);
    }
}

