/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.beans.AbstractJavaLinker;
import org.dynalang.dynalink.beans.DynamicMethod;
import org.dynalang.dynalink.beans.FacetIntrospector;
import org.dynalang.dynalink.beans.SimpleDynamicMethod;
import org.dynalang.dynalink.beans.StaticClass;
import org.dynalang.dynalink.beans.StaticClassIntrospector;
import org.dynalang.dynalink.linker.GuardedInvocation;
import org.dynalang.dynalink.linker.GuardingDynamicLinker;
import org.dynalang.dynalink.linker.LinkRequest;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.linker.TypeBasedGuardingDynamicLinker;
import org.dynalang.dynalink.support.Lookup;

class StaticClassLinker
implements TypeBasedGuardingDynamicLinker {
    private final ClassValue<GuardingDynamicLinker> linkers = new ClassValue<GuardingDynamicLinker>(){

        @Override
        protected GuardingDynamicLinker computeValue(Class<?> clazz) {
            return new SingleClassStaticsLinker(clazz);
        }
    };
    static final MethodHandle GET_CLASS = new Lookup(MethodHandles.lookup()).findVirtual(StaticClass.class, "getRepresentedClass", MethodType.methodType(Class.class));
    static final MethodHandle IS_CLASS = new Lookup(MethodHandles.lookup()).findStatic(StaticClassLinker.class, "isClass", MethodType.methodType(Boolean.TYPE, Class.class, Object.class));
    static final MethodHandle ARRAY_CTOR = Lookup.PUBLIC.findStatic(Array.class, "newInstance", MethodType.methodType(Object.class, Class.class, Integer.TYPE));

    StaticClassLinker() {
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest request, LinkerServices linkerServices) throws Exception {
        Object receiver = request.getReceiver();
        if (receiver instanceof StaticClass) {
            return this.linkers.get(((StaticClass)receiver).getRepresentedClass()).getGuardedInvocation(request, linkerServices);
        }
        return null;
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return type == StaticClass.class;
    }

    private static boolean isClass(Class<?> clazz, Object obj) {
        return obj instanceof StaticClass && ((StaticClass)obj).getRepresentedClass() == clazz;
    }

    private static class SingleClassStaticsLinker
    extends AbstractJavaLinker {
        private final DynamicMethod constructor;

        SingleClassStaticsLinker(Class<?> clazz) {
            super(clazz, IS_CLASS.bindTo(clazz));
            this.setPropertyGetter("class", GET_CLASS, false);
            this.constructor = SingleClassStaticsLinker.createConstructorMethod(clazz);
        }

        private static DynamicMethod createConstructorMethod(Class<?> clazz) {
            if (clazz.isArray()) {
                MethodHandle boundArrayCtor = ARRAY_CTOR.bindTo(clazz.getComponentType());
                return new SimpleDynamicMethod(SingleClassStaticsLinker.drop(boundArrayCtor.asType(boundArrayCtor.type().changeReturnType(clazz))), clazz, "<init>");
            }
            Constructor<?>[] ctrs = clazz.getConstructors();
            ArrayList<MethodHandle> mhs = new ArrayList<MethodHandle>(ctrs.length);
            for (int i = 0; i < ctrs.length; ++i) {
                mhs.add(SingleClassStaticsLinker.drop(Lookup.PUBLIC.unreflectConstructor(ctrs[i])));
            }
            return SingleClassStaticsLinker.createDynamicMethod(mhs, clazz, "<init>");
        }

        private static MethodHandle drop(MethodHandle mh) {
            return MethodHandles.dropArguments(mh, 0, new Class[]{StaticClass.class});
        }

        @Override
        FacetIntrospector createFacetIntrospector() {
            return new StaticClassIntrospector(this.clazz);
        }

        @Override
        public GuardedInvocation getGuardedInvocation(LinkRequest request, LinkerServices linkerServices) throws Exception {
            MethodHandle ctorInvocation;
            GuardedInvocation gi = super.getGuardedInvocation(request, linkerServices);
            if (gi != null) {
                return gi;
            }
            CallSiteDescriptor desc = request.getCallSiteDescriptor();
            String op = desc.getNameToken(1);
            MethodType methodType = desc.getMethodType();
            if ("new" == op && this.constructor != null && (ctorInvocation = this.constructor.getInvocation(methodType, linkerServices)) != null) {
                return new GuardedInvocation(ctorInvocation, this.getClassGuard(methodType));
            }
            return null;
        }
    }
}

