/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import org.dynalang.dynalink.beans.DynamicMethod;
import org.dynalang.dynalink.linker.LinkerServices;
import org.dynalang.dynalink.support.Guards;

class SimpleDynamicMethod
extends DynamicMethod {
    private final MethodHandle target;

    SimpleDynamicMethod(MethodHandle target) {
        this(target, null);
    }

    SimpleDynamicMethod(MethodHandle target, Class<?> clazz, String name) {
        this(target, SimpleDynamicMethod.getName(target, clazz, name));
    }

    SimpleDynamicMethod(MethodHandle target, String name) {
        super(name);
        this.target = target;
    }

    private static String getName(MethodHandle target, Class<?> clazz, String name) {
        return SimpleDynamicMethod.getMethodNameWithSignature(target, SimpleDynamicMethod.getClassAndMethodName(clazz, name));
    }

    static String getMethodNameWithSignature(MethodHandle target, String methodName) {
        String typeStr = target.type().toString();
        int retTypeIndex = typeStr.lastIndexOf(41) + 1;
        int secondParamIndex = typeStr.indexOf(44) + 1;
        if (secondParamIndex == 0) {
            secondParamIndex = retTypeIndex - 1;
        }
        return typeStr.substring(retTypeIndex) + " " + methodName + "(" + typeStr.substring(secondParamIndex, retTypeIndex);
    }

    public MethodHandle getTarget() {
        return this.target;
    }

    @Override
    SimpleDynamicMethod getMethodForExactParamTypes(String paramTypes) {
        return SimpleDynamicMethod.typeMatchesDescription(paramTypes, this.target.type()) ? this : null;
    }

    @Override
    MethodHandle getInvocation(MethodType callSiteType, LinkerServices linkerServices) {
        MethodType methodType = this.target.type();
        int paramsLen = methodType.parameterCount();
        boolean varArgs = this.target.isVarargsCollector();
        MethodHandle fixTarget = varArgs ? this.target.asFixedArity() : this.target;
        int fixParamsLen = varArgs ? paramsLen - 1 : paramsLen;
        int argsLen = callSiteType.parameterCount();
        if (argsLen < fixParamsLen) {
            return null;
        }
        if (argsLen == fixParamsLen) {
            MethodHandle matchedMethod = varArgs ? MethodHandles.insertArguments(fixTarget, fixParamsLen, Array.newInstance(((Class)methodType.parameterType(fixParamsLen)).getComponentType(), 0)) : fixTarget;
            return SimpleDynamicMethod.createConvertingInvocation(matchedMethod, linkerServices, callSiteType);
        }
        if (!varArgs) {
            return null;
        }
        TypeDescriptor.OfField varArgType = methodType.parameterType(fixParamsLen);
        if (argsLen == paramsLen) {
            TypeDescriptor.OfField callSiteLastArgType = callSiteType.parameterType(fixParamsLen);
            if (((Class)varArgType).isAssignableFrom((Class<?>)callSiteLastArgType)) {
                return SimpleDynamicMethod.createConvertingInvocation(fixTarget, linkerServices, callSiteType);
            }
            if (!linkerServices.canConvert((Class<?>)callSiteLastArgType, (Class<?>)varArgType)) {
                return SimpleDynamicMethod.createConvertingInvocation(SimpleDynamicMethod.collectArguments(fixTarget, argsLen), linkerServices, callSiteType);
            }
            return MethodHandles.guardWithTest(Guards.isInstance(varArgType, fixParamsLen, callSiteType), SimpleDynamicMethod.createConvertingInvocation(fixTarget, linkerServices, callSiteType), SimpleDynamicMethod.createConvertingInvocation(SimpleDynamicMethod.collectArguments(fixTarget, argsLen), linkerServices, callSiteType));
        }
        return SimpleDynamicMethod.createConvertingInvocation(SimpleDynamicMethod.collectArguments(fixTarget, argsLen), linkerServices, callSiteType);
    }

    @Override
    public boolean contains(MethodHandle mh) {
        return this.target.type().parameterList().equals(mh.type().parameterList());
    }

    static MethodHandle collectArguments(MethodHandle target, int parameterCount) {
        MethodType methodType = target.type();
        int fixParamsLen = methodType.parameterCount() - 1;
        TypeDescriptor.OfField arrayType = methodType.parameterType(fixParamsLen);
        return target.asCollector((Class<?>)arrayType, parameterCount - fixParamsLen);
    }

    private static MethodHandle createConvertingInvocation(MethodHandle sizedMethod, LinkerServices linkerServices, MethodType callSiteType) {
        return linkerServices.asType(sizedMethod, callSiteType);
    }
}

