/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import org.dynalang.dynalink.beans.CheckRestrictedPackage;

class CheckRestrictedPackageInternal {
    private static final MethodHandle PACKAGE_ACCESS_CHECK = CheckRestrictedPackageInternal.getPackageAccessCheckMethod();
    private static final String TESTER_CLASS_NAME = "org.dynalang.dynalink.beans.RestrictedPackageTester";

    CheckRestrictedPackageInternal() {
    }

    static boolean isRestrictedPackageName(String pkgName) {
        try {
            if (PACKAGE_ACCESS_CHECK != null) {
                try {
                    PACKAGE_ACCESS_CHECK.invokeExact(pkgName);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            } else {
                System.getSecurityManager().checkPackageAccess(pkgName);
            }
            return false;
        }
        catch (SecurityException e) {
            return true;
        }
    }

    private static MethodHandle getPackageAccessCheckMethod() {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<MethodHandle>(){

                @Override
                public MethodHandle run() {
                    return CheckRestrictedPackageInternal.getPackageAccessCheckMethodInternal();
                }
            });
        }
        catch (SecurityException e) {
            return null;
        }
    }

    static MethodHandle getPackageAccessCheckMethodInternal() {
        try {
            Method m = CheckRestrictedPackageInternal.getTesterClass().getDeclaredMethod("checkPackageAccess", String.class);
            m.setAccessible(true);
            return MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Class<?> getTesterClass() {
        ClassLoader loader = CheckRestrictedPackageInternal.getTesterClassLoader();
        try {
            Class<?> checkerClass = Class.forName(TESTER_CLASS_NAME, true, loader);
            if (checkerClass.getClassLoader() != loader) {
                throw new AssertionError((Object)"org.dynalang.dynalink.beans.RestrictedPackageTester was loaded from a different class loader");
            }
            return checkerClass;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static ClassLoader getTesterClassLoader() {
        return new SecureClassLoader(null){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.equals(CheckRestrictedPackageInternal.TESTER_CLASS_NAME)) {
                    byte[] bytes = CheckRestrictedPackageInternal.getTesterClassBytes();
                    Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, new ProtectionDomain(null, new Permissions()));
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                return super.loadClass(name, resolve);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getTesterClassBytes() {
        byte[] byArray;
        InputStream in = CheckRestrictedPackage.class.getResourceAsStream("RestrictedPackageTester.class");
        try {
            int b;
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return byArray;
    }
}

