/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.dynalink.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.dynalang.dynalink.beans.FacetIntrospector;

class BeanIntrospector
extends FacetIntrospector {
    private final BeanInfo beanInfo;

    BeanIntrospector(Class<?> clazz) {
        super(clazz, true);
        try {
            this.beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    Collection<PropertyDescriptor> getProperties() {
        PropertyDescriptor[] descs = this.beanInfo.getPropertyDescriptors();
        ArrayList<PropertyDescriptor> ldescs = new ArrayList<PropertyDescriptor>(descs.length);
        for (PropertyDescriptor desc : descs) {
            Method readMethod = desc.getReadMethod();
            Method writeMethod = desc.getWriteMethod();
            Method accReadMethod = this.membersLookup.getAccessibleMethod(readMethod);
            Method accWriteMethod = this.membersLookup.getAccessibleMethod(writeMethod);
            if (readMethod == null && writeMethod == null) continue;
            if (accReadMethod == readMethod && accWriteMethod == writeMethod) {
                ldescs.add(desc);
                continue;
            }
            try {
                ldescs.add(new PropertyDescriptor(desc.getName(), accReadMethod, accWriteMethod));
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        return ldescs;
    }

    @Override
    Map<String, MethodHandle> getInnerClassGetters() {
        return Collections.emptyMap();
    }

    @Override
    boolean includeField(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    @Override
    Collection<Method> getMethods() {
        MethodDescriptor[] methods = this.beanInfo.getMethodDescriptors();
        ArrayList<Method> cmethods = new ArrayList<Method>(methods.length);
        for (MethodDescriptor methodDesc : methods) {
            Method accMethod;
            Method method = methodDesc.getMethod();
            if (Modifier.isStatic(method.getModifiers()) || (accMethod = this.membersLookup.getAccessibleMethod(method)) == null) continue;
            cmethods.add(accMethod);
        }
        return cmethods;
    }

    @Override
    public void close() {
        Introspector.flushFromCaches(this.clazz);
    }
}

