/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.SwitchPoint;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyHashMap;
import jdk.nashorn.internal.runtime.PropertyListener;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.UserAccessorProperty;
import jdk.nashorn.internal.scripts.JO$;

public final class PropertyMap
implements Iterable<Object>,
PropertyListener {
    public static final int IS_PROTOTYPE = 1;
    public static final int NOT_EXTENSIBLE = 2;
    private static final int CLONEABLE_FLAGS_MASK = 15;
    public static final int IS_LISTENER_ADDED = 16;
    private int flags;
    private final Class<?> structure;
    private final Context context;
    private final PropertyHashMap properties;
    private ScriptObject proto;
    private int spillLength;
    private Map<String, SwitchPoint> protoGetSwitches;
    private HashMap<Property, PropertyMap> history;
    private WeakHashMap<ScriptObject, WeakReference<PropertyMap>> protoHistory;
    private int hashCode;
    private static int count;
    private static int clonedCount;
    private static int historyHit;
    private static int protoInvalidations;
    private static int protoHistoryHit;
    private static int setProtoNewMapCount;

    PropertyMap(Class<?> structure, Context context, PropertyHashMap properties) {
        this.structure = structure;
        this.context = context;
        this.properties = properties;
        this.hashCode = this.computeHashCode();
        if (Context.DEBUG) {
            ++count;
        }
    }

    private PropertyMap(PropertyMap propertyMap, PropertyHashMap properties) {
        this.structure = propertyMap.structure;
        this.context = propertyMap.context;
        this.properties = properties;
        this.flags = propertyMap.getClonedFlags();
        this.proto = propertyMap.proto;
        this.spillLength = propertyMap.spillLength;
        this.hashCode = this.computeHashCode();
        if (Context.DEBUG) {
            ++count;
            ++clonedCount;
        }
    }

    public PropertyMap duplicate() {
        return new PropertyMap(this.structure, this.context, this.properties);
    }

    public static PropertyMap newMap(Class<?> structure, Collection<Property> properties) {
        Context context = Context.fromClass(structure);
        if (structure == JO$.class) {
            return context.emptyMap;
        }
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_MAP.immutableAdd(properties);
        return new PropertyMap(structure, context, newProperties);
    }

    public static PropertyMap newMap(Class<?> structure) {
        return PropertyMap.newMap(structure, null);
    }

    public static PropertyMap newEmptyMap(Context context) {
        return new PropertyMap(JO$.class, context, PropertyHashMap.EMPTY_MAP);
    }

    public int size() {
        return this.properties.size();
    }

    public SwitchPoint getProtoGetSwitchPoint(String key) {
        if (this.proto == null) {
            return null;
        }
        if (this.protoGetSwitches == null) {
            this.protoGetSwitches = new HashMap<String, SwitchPoint>();
            if (!this.isListenerAdded()) {
                this.proto.addPropertyListener(this);
                this.setIsListenerAdded();
            }
        }
        if (this.protoGetSwitches.containsKey(key)) {
            return this.protoGetSwitches.get(key);
        }
        SwitchPoint switchPoint = new SwitchPoint();
        this.protoGetSwitches.put(key, switchPoint);
        return switchPoint;
    }

    private void invalidateProtoGetSwitchPoint(Property property) {
        String key;
        SwitchPoint sp;
        if (this.protoGetSwitches != null && (sp = this.protoGetSwitches.get(key = property.getKey())) != null) {
            this.protoGetSwitches.put(key, new SwitchPoint());
            if (Context.DEBUG) {
                ++protoInvalidations;
            }
            SwitchPoint.invalidateAll(new SwitchPoint[]{sp});
        }
    }

    public PropertyMap newProperty(Property property) {
        return this.addProperty(property);
    }

    PropertyMap newPropertyBind(AccessorProperty property, ScriptObject bindTo) {
        return this.newProperty(new AccessorProperty(property, bindTo));
    }

    public PropertyMap newProperty(String key, int propertyFlags, int slot, MethodHandle getter, MethodHandle setter) {
        return this.newProperty(new AccessorProperty(key, propertyFlags, slot, getter, setter));
    }

    PropertyMap addProperty(Property property) {
        PropertyMap newMap = this.checkHistory(property);
        if (newMap == null) {
            PropertyHashMap newProperties = this.properties.immutableAdd(property);
            newMap = new PropertyMap(this, newProperties);
            this.addToHistory(property, newMap);
            newMap.spillLength += property.getSpillCount();
        }
        return newMap;
    }

    PropertyMap deleteProperty(Property property) {
        PropertyMap newMap = this.checkHistory(property);
        String key = property.getKey();
        if (newMap == null && this.properties.containsKey(key)) {
            PropertyHashMap newProperties = this.properties.immutableRemove(key);
            newMap = new PropertyMap(this, newProperties);
            this.addToHistory(property, newMap);
        }
        return newMap;
    }

    PropertyMap replaceProperty(Property oldProperty, Property newProperty) {
        boolean sameType;
        PropertyHashMap newProperties = this.properties.immutableAdd(newProperty);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        boolean bl = sameType = oldProperty.getClass() == newProperty.getClass();
        assert (sameType || oldProperty instanceof AccessorProperty && newProperty instanceof UserAccessorProperty) : "arbitrary replaceProperty attempted";
        newMap.flags = this.getClonedFlags();
        newMap.proto = this.proto;
        newMap.spillLength = this.spillLength + (sameType ? 0 : newProperty.getSpillCount());
        return newMap;
    }

    public Property findProperty(String key) {
        return this.properties.find(key);
    }

    public PropertyMap addAll(PropertyMap other) {
        assert (this != other) : "adding property map to itself";
        Property[] otherProperties = other.properties.getProperties();
        PropertyHashMap newProperties = this.properties.immutableAdd(otherProperties);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        for (Property property : otherProperties) {
            newMap.spillLength += property.getSpillCount();
        }
        return newMap;
    }

    public Property[] getProperties() {
        return this.properties.getProperties();
    }

    PropertyMap preventExtensions() {
        PropertyMap newMap = new PropertyMap(this, this.properties);
        newMap.flags |= 2;
        return newMap;
    }

    PropertyMap seal() {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_MAP;
        for (Property oldProperty : this.properties.getProperties()) {
            newProperties = newProperties.immutableAdd(oldProperty.addFlags(4));
        }
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.flags |= 2;
        return newMap;
    }

    PropertyMap freeze() {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_MAP;
        for (Property oldProperty : this.properties.getProperties()) {
            int propertyFlags = 4;
            if (!(oldProperty instanceof UserAccessorProperty)) {
                propertyFlags |= 1;
            }
            newProperties = newProperties.immutableAdd(oldProperty.addFlags(propertyFlags));
        }
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.flags |= 2;
        return newMap;
    }

    private boolean anyConfigurable() {
        for (Property property : this.properties.getProperties()) {
            if (!property.isConfigurable()) continue;
            return true;
        }
        return false;
    }

    private boolean allFrozen() {
        for (Property property : this.properties.getProperties()) {
            if (!(property instanceof UserAccessorProperty) && property.isWritable()) {
                return false;
            }
            if (!property.isConfigurable()) continue;
            return false;
        }
        return true;
    }

    private PropertyMap checkProtoHistory(ScriptObject newProto) {
        WeakReference<PropertyMap> weakMap;
        PropertyMap cachedMap = this.protoHistory != null ? ((weakMap = this.protoHistory.get(newProto)) != null ? (PropertyMap)weakMap.get() : null) : null;
        if (Context.DEBUG && cachedMap != null) {
            ++protoHistoryHit;
        }
        return cachedMap;
    }

    private void addToProtoHistory(ScriptObject newProto, PropertyMap newMap) {
        if (this.protoHistory == null) {
            this.protoHistory = new WeakHashMap();
        }
        this.protoHistory.put(newProto, new WeakReference<PropertyMap>(newMap));
    }

    private void addToHistory(Property property, PropertyMap newMap) {
        if (this.history == null) {
            this.history = new LinkedHashMap<Property, PropertyMap>();
        }
        this.history.put(property, newMap);
    }

    private PropertyMap checkHistory(Property property) {
        PropertyMap historicMap;
        if (this.history != null && (historicMap = this.history.get(property)) != null) {
            if (Context.DEBUG) {
                ++historyHit;
            }
            return historicMap;
        }
        return null;
    }

    private int computeHashCode() {
        int hash = this.structure.hashCode();
        if (this.proto != null) {
            hash ^= this.proto.hashCode();
        }
        for (Property property : this.getProperties()) {
            hash = hash << 7 ^ hash >> 7;
            hash ^= property.hashCode();
        }
        return hash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PropertyMap)) {
            return false;
        }
        PropertyMap otherMap = (PropertyMap)other;
        if (this.structure != otherMap.structure || this.proto != otherMap.proto || this.properties.size() != otherMap.properties.size()) {
            return false;
        }
        Iterator<Property> iter = this.properties.values().iterator();
        Iterator<Property> otherIter = otherMap.properties.values().iterator();
        while (iter.hasNext() && otherIter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        boolean isFirst = true;
        for (Property property : this.properties.values()) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(ScriptRuntime.safeToString(property.getKey()));
            Class<?> ctype = property.getCurrentType();
            sb.append(" <").append(property.getClass().getSimpleName()).append(':').append(ctype == null ? "undefined" : ctype.getSimpleName()).append('>');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<Object> iterator() {
        return new PropertyMapIterator(this);
    }

    Context getContext() {
        return this.context;
    }

    public boolean isPrototype() {
        return (this.flags & 1) != 0;
    }

    private void setIsPrototype() {
        this.flags |= 1;
    }

    public boolean isListenerAdded() {
        return (this.flags & 0x10) != 0;
    }

    boolean isExtensible() {
        return (this.flags & 2) == 0;
    }

    boolean isSealed() {
        return !this.isExtensible() && !this.anyConfigurable();
    }

    boolean isFrozen() {
        return !this.isExtensible() && this.allFrozen();
    }

    int getSpillLength() {
        return this.spillLength;
    }

    ScriptObject getProto() {
        return this.proto;
    }

    PropertyMap setProto(ScriptObject newProto) {
        ScriptObject oldProto = this.proto;
        if (oldProto == newProto) {
            return this;
        }
        PropertyMap nextMap = this.checkProtoHistory(newProto);
        if (nextMap != null) {
            return nextMap;
        }
        if (Context.DEBUG) {
            PropertyMap.incrementSetProtoNewMapCount();
        }
        PropertyMap newMap = new PropertyMap(this, this.properties);
        this.addToProtoHistory(newProto, newMap);
        newMap.proto = newProto;
        if (oldProto != null && newMap.isListenerAdded()) {
            oldProto.removePropertyListener(newMap);
        }
        if (newProto != null) {
            newProto.getMap().setIsPrototype();
        }
        return newMap;
    }

    private void setIsListenerAdded() {
        this.flags |= 0x10;
    }

    private int getClonedFlags() {
        return this.flags & 0xF;
    }

    @Override
    public void propertyAdded(ScriptObject object, Property prop) {
        this.invalidateProtoGetSwitchPoint(prop);
    }

    @Override
    public void propertyDeleted(ScriptObject object, Property prop) {
        this.invalidateProtoGetSwitchPoint(prop);
    }

    @Override
    public void propertyModified(ScriptObject object, Property oldProp, Property newProp) {
        this.invalidateProtoGetSwitchPoint(oldProp);
    }

    public static int getCount() {
        return count;
    }

    public static int getClonedCount() {
        return clonedCount;
    }

    public static int getHistoryHit() {
        return historyHit;
    }

    public static int getProtoInvalidations() {
        return protoInvalidations;
    }

    public static int getProtoHistoryHit() {
        return protoHistoryHit;
    }

    public static int getSetProtoNewMapCount() {
        return setProtoNewMapCount;
    }

    private static void incrementSetProtoNewMapCount() {
        ++setProtoNewMapCount;
    }

    private static class PropertyMapIterator
    implements Iterator<Object> {
        final Iterator<Property> iter;
        Property property;

        PropertyMapIterator(PropertyMap propertyMap) {
            this.iter = Arrays.asList(propertyMap.properties.getProperties()).iterator();
            this.property = this.iter.hasNext() ? this.iter.next() : null;
            this.skipNotEnumerable();
        }

        private void skipNotEnumerable() {
            while (this.property != null && !this.property.isEnumerable()) {
                this.property = this.iter.hasNext() ? this.iter.next() : null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.property != null;
        }

        @Override
        public Object next() {
            if (this.property == null) {
                throw new NoSuchElementException();
            }
            String key = this.property.getKey();
            this.property = this.iter.next();
            this.skipNotEnumerable();
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

