/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyListener;
import jdk.nashorn.internal.runtime.ScriptObject;

public class PropertyListenerManager
implements PropertyListener {
    private static int listenersAdded;
    private static int listenersRemoved;
    private static int listenersDead;
    private List<WeakReference<PropertyListener>> listeners;

    public static int getListenersAdded() {
        return listenersAdded;
    }

    public static int getListenersRemoved() {
        return listenersRemoved;
    }

    public static int getListenersDead() {
        return listenersDead;
    }

    public final void addPropertyListener(PropertyListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<WeakReference<PropertyListener>>();
        }
        if (Context.DEBUG) {
            ++listenersAdded;
        }
        this.listeners.add(new WeakReference<PropertyListener>(listener));
    }

    public final void removePropertyListener(PropertyListener listener) {
        if (this.listeners != null) {
            Iterator<WeakReference<PropertyListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                if (iter.next().get() != listener) continue;
                if (Context.DEBUG) {
                    ++listenersRemoved;
                }
                iter.remove();
            }
        }
    }

    protected final void notifyPropertyAdded(ScriptObject object, Property prop) {
        if (this.listeners != null) {
            Iterator<WeakReference<PropertyListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<PropertyListener> weakRef = iter.next();
                PropertyListener listener = (PropertyListener)weakRef.get();
                if (listener == null) {
                    if (Context.DEBUG) {
                        ++listenersDead;
                    }
                    iter.remove();
                    continue;
                }
                listener.propertyAdded(object, prop);
            }
        }
    }

    protected final void notifyPropertyDeleted(ScriptObject object, Property prop) {
        if (this.listeners != null) {
            Iterator<WeakReference<PropertyListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<PropertyListener> weakRef = iter.next();
                PropertyListener listener = (PropertyListener)weakRef.get();
                if (listener == null) {
                    if (Context.DEBUG) {
                        ++listenersDead;
                    }
                    iter.remove();
                    continue;
                }
                listener.propertyDeleted(object, prop);
            }
        }
    }

    protected final void notifyPropertyModified(ScriptObject object, Property oldProp, Property newProp) {
        if (this.listeners != null) {
            Iterator<WeakReference<PropertyListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<PropertyListener> weakRef = iter.next();
                PropertyListener listener = (PropertyListener)weakRef.get();
                if (listener == null) {
                    if (Context.DEBUG) {
                        ++listenersDead;
                    }
                    iter.remove();
                    continue;
                }
                listener.propertyModified(object, oldProp, newProp);
            }
        }
    }

    @Override
    public final void propertyAdded(ScriptObject object, Property prop) {
        this.notifyPropertyAdded(object, prop);
    }

    @Override
    public final void propertyDeleted(ScriptObject object, Property prop) {
        this.notifyPropertyDeleted(object, prop);
    }

    @Override
    public final void propertyModified(ScriptObject object, Property oldProp, Property newProp) {
        this.notifyPropertyModified(object, oldProp, newProp);
    }
}

