/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.tools.Shell;

abstract class NashornLoader
extends SecureClassLoader {
    private final Context context;

    final Context getContext() {
        return this.context;
    }

    NashornLoader(ClassLoader parent, Context context) {
        super(parent);
        this.context = context;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        NashornLoader.checkPackageAccess(name);
        return super.loadClass(name);
    }

    protected static void checkPackageAccess(String name) {
        SecurityManager sm;
        int i = name.lastIndexOf(46);
        if (i != -1 && (sm = System.getSecurityManager()) != null) {
            sm.checkPackageAccess(name.substring(0, i));
        }
    }

    static ClassLoader createClassLoader(String classPath) {
        ClassLoader parent = Shell.class.getClassLoader();
        URL[] urls = NashornLoader.pathToURLs(classPath);
        return URLClassLoader.newInstance(urls, parent);
    }

    private static URL[] pathToURLs(String path) {
        String[] components = path.split(File.pathSeparator);
        URL[] urls = new URL[components.length];
        int count = 0;
        while (count < components.length) {
            URL url = NashornLoader.fileToURL(new File(components[count]));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }
}

