/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.annotations.Ignore;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class ThrowNode
extends Node {
    private Node expression;
    @Ignore
    private final TryNode tryChain;

    public ThrowNode(Source source, long token, int finish, Node expression, TryNode tryChain) {
        super(source, token, finish);
        this.expression = expression;
        this.tryChain = tryChain;
        this.setIsTerminal(true);
    }

    private ThrowNode(ThrowNode throwNode, Node.CopyState cs) {
        super(throwNode);
        this.expression = cs.existingOrCopy(throwNode.expression);
        this.tryChain = (TryNode)cs.existingOrSame(throwNode.tryChain);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new ThrowNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.setExpression(this.expression.accept(visitor));
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("throw ");
        if (this.expression != null) {
            this.expression.toString(sb);
        }
    }

    public Node getExpression() {
        return this.expression;
    }

    public void setExpression(Node expression) {
        this.expression = expression;
    }

    public TryNode getTryChain() {
        return this.tryChain;
    }
}

