/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.types;

import java.lang.invoke.MethodHandle;
import jdk.internal.org.objectweb.asm.Handle;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.ArrayType;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Undefined;

class ObjectType
extends Type {
    protected ObjectType() {
        this(Object.class);
    }

    protected ObjectType(Class<?> clazz) {
        super("object", clazz, clazz == Object.class ? 20 : 10, 1);
    }

    @Override
    public String toString() {
        return "object" + (this.getTypeClass() != Object.class ? "<type=" + this.getTypeClass().getSimpleName() + '>' : "");
    }

    @Override
    public Type add(MethodVisitor method) {
        ObjectType.invokeStatic(method, ScriptRuntime.ADD);
        return Type.OBJECT;
    }

    @Override
    public Type load(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(25, slot);
        if (slot == CompilerConstants.THIS.slot()) {
            return Type.THIS;
        }
        return Type.OBJECT;
    }

    @Override
    public void store(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(58, slot);
    }

    @Override
    public Type loadUndefined(MethodVisitor method) {
        method.visitFieldInsn(178, CompilerConstants.className(ScriptRuntime.class), "UNDEFINED", CompilerConstants.typeDescriptor(Undefined.class));
        return OBJECT;
    }

    @Override
    public Type loadEmpty(MethodVisitor method) {
        method.visitFieldInsn(178, CompilerConstants.className(ScriptRuntime.class), "EMPTY", CompilerConstants.typeDescriptor(Undefined.class));
        return OBJECT;
    }

    @Override
    public Type ldc(MethodVisitor method, Object c) {
        if (c == null) {
            method.visitInsn(1);
        } else {
            if (c instanceof Undefined) {
                return this.loadUndefined(method);
            }
            if (c instanceof String) {
                method.visitLdcInsn(c);
                return STRING;
            }
            if (c instanceof Handle) {
                method.visitLdcInsn(c);
                return Type.typeFor(MethodHandle.class);
            }
            assert (false) : "implementation missing for class " + c.getClass() + " value=" + c;
        }
        return OBJECT;
    }

    @Override
    public Type convert(MethodVisitor method, Type to) {
        boolean toString = to.isString();
        if (!toString) {
            if (to.isArray()) {
                Type elemType = ((ArrayType)to).getElementType();
                if (elemType.isString()) {
                    method.visitTypeInsn(192, CompilerConstants.className(String[].class));
                } else if (elemType.isNumber()) {
                    method.visitTypeInsn(192, CompilerConstants.className(double[].class));
                } else if (elemType.isLong()) {
                    method.visitTypeInsn(192, CompilerConstants.className(long[].class));
                } else if (elemType.isInteger()) {
                    method.visitTypeInsn(192, CompilerConstants.className(int[].class));
                } else {
                    method.visitTypeInsn(192, CompilerConstants.className(Object[].class));
                }
                return to;
            }
            if (to.isObject()) {
                return to;
            }
        } else if (this.isString()) {
            return to;
        }
        if (to.isInteger()) {
            ObjectType.invokeStatic(method, JSType.TO_INT32);
        } else if (to.isNumber()) {
            ObjectType.invokeStatic(method, JSType.TO_NUMBER);
        } else if (to.isLong()) {
            ObjectType.invokeStatic(method, JSType.TO_INT64);
        } else if (to.isBoolean()) {
            ObjectType.invokeStatic(method, JSType.TO_BOOLEAN);
        } else if (to.isString()) {
            ObjectType.invokeStatic(method, JSType.TO_PRIMITIVE);
            ObjectType.invokeStatic(method, JSType.TO_STRING);
        } else assert (false) : "Illegal conversion " + this + " -> " + to + " " + this.isString() + " " + toString;
        return to;
    }

    @Override
    public void _return(MethodVisitor method) {
        method.visitInsn(176);
    }
}

