/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.types;

import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.JSType;

public final class BooleanType
extends Type {
    private static final CompilerConstants.Call VALUE_OF = CompilerConstants.staticCallNoLookup(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);

    protected BooleanType() {
        super("boolean", Boolean.TYPE, 1, 1);
    }

    @Override
    public Type nextWider() {
        return INT;
    }

    @Override
    public Class<?> getBoxedType() {
        return Boolean.class;
    }

    @Override
    public Type loadUndefined(MethodVisitor method) {
        method.visitLdcInsn(0);
        return BOOLEAN;
    }

    @Override
    public Type loadEmpty(MethodVisitor method) {
        assert (false) : "unsupported operation";
        return null;
    }

    @Override
    public void _return(MethodVisitor method) {
        method.visitInsn(172);
    }

    @Override
    public Type load(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(21, slot);
        return BOOLEAN;
    }

    @Override
    public void store(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(54, slot);
    }

    @Override
    public Type ldc(MethodVisitor method, Object c) {
        assert (c instanceof Boolean);
        method.visitInsn((Boolean)c != false ? 4 : 3);
        return BOOLEAN;
    }

    @Override
    public Type convert(MethodVisitor method, Type to) {
        if (this.isEquivalentTo(to)) {
            return to;
        }
        if (to.isNumber()) {
            this.convert(method, OBJECT);
            BooleanType.invokeStatic(method, JSType.TO_NUMBER);
        } else {
            if (to.isInteger()) {
                return to;
            }
            if (to.isLong()) {
                this.convert(method, OBJECT);
                BooleanType.invokeStatic(method, JSType.TO_UINT32);
            } else if (to.isLong()) {
                this.convert(method, OBJECT);
                BooleanType.invokeStatic(method, JSType.TO_LONG);
            } else if (to.isString()) {
                BooleanType.invokeStatic(method, VALUE_OF);
                BooleanType.invokeStatic(method, JSType.TO_PRIMITIVE);
                BooleanType.invokeStatic(method, JSType.TO_STRING);
            } else if (to.isObject()) {
                BooleanType.invokeStatic(method, VALUE_OF);
            } else assert (false) : "Illegal conversion " + this + " -> " + to;
        }
        return to;
    }

    @Override
    public Type add(MethodVisitor method) {
        assert (false) : "unsupported operation";
        return null;
    }
}

