(ns org.bituf.sqlrat.util
  "Common utility functions"
  (:use clojure.repl)
  (:import [clojure.lang IFn Keyword IPersistentMap IPersistentVector]))


(def *show-sql* true)
(def *show-sql-results* false)
(def *assert-args* true)


(defn bad-arg!
  "Throw IllegalArgumentException with specified arguments. Use this when you
   encounter bad/invalid parameters."
  [reason & more]
  (throw (IllegalArgumentException. (apply str reason more))))


(defn vstr
  "Verbose str"
  [s]
  (if-let [x s] x "<nil>"))


(defn arg
  "Apply f? (must return Boolean) to arg - return true when asserted true,
   throw exception otherwise."
  [f? arg]
  (if (f? arg) true
    (bad-arg! "Invalid argument " (vstr arg) " (Expected: " (:name (meta f?))
      ", Found: " (vstr (type arg)) ")")))


(defn assert-arg
  "Assert specified argument using the function f?, which must return Boolean."
  [f? param]
  (assert (arg f? param)))


(defn assert-as
  [item expected-type]
  (assert (instance? Class expected-type))
  (try
    (assert (isa? (type item) expected-type))
    (catch AssertionError e
      (throw (AssertionError. (str "Expected " expected-type " but found "
                                (type item)))))))


(defn as-vector
  "Convert anything to a vector and return the result"
  [anything]
  (if (vector? anything) anything
    (if (or (seq? anything) (set? anything)) (into [] anything)
      (if (map? anything) (into [] (vals anything))
        [anything]))))


(defn as-set
  "Convert anything to a set and return the result"
  [anything]
  (if (set? anything) anything
    (if (or (seq? anything) (vector? anything)) (into #{} anything)
      (if (map? anything) (into #{} (vals anything))
        [anything]))))


(defn as-map
  "Convert any collection to a map and return the result"
  [anything]
  (if (map? anything) anything
    (if (coll? anything) (apply array-map anything)
      (bad-arg! (str "Expected collection, but found " (type anything) ": "
                  anything)))))
