(ns org.bituf.sqlrat.clause.internal
  (:use org.bituf.sqlrat.util))


;; ======== Clause meta data ========

(def clause-key :sqlrat-sql-clause?)


(def clause-meta {clause-key true})


(defn assoc-clause-meta "Add clause meta data to specified object"
  [obj]
  (with-meta obj (merge (meta obj) clause-meta)))


;; ======== Keyword to String conversion ========

(defn str-name
  "Convert keyword/anything to a string (colname)."
  [k]
  (if (keyword? k) (name k)
    (str k)))

(defn str-clause-key
  "Convert a clause keyword to string.
   :where becomes \" WHERE \"
   :group-by becomes \" GROUP BY \"
   and so on."
  [clause-key key-prefix]
  (if *assert-args* (assert (keyword? clause-key)))
  (.toUpperCase
    (.replace
      (str key-prefix
        (name clause-key) \  )
      \- \  )))
