(ns leiningen.lb
  (:require [clojure.contrib.duck-streams :as ds]))

(def *version* "0.1 (uses Liquibase 2.0-RC6)")

(defn help
  []
  (println
    (str "
Lein-LB - Lein Liquibase plugin " *version* "

For help on Liquibase commands:

    $ lein lb help

For help on Lein-LB commands (notice that the command begins with a colon):

    $ lein lb :help

List of Lein-LB commands (they all begin with a colon):

    :help               prints this help screen
    :sample-properties  prints sample properties - put in liquibase.properties
"
      )))


(defn sample-props
  []
  (let [filename "/liquibase.properties"
        istream  (.getResourceAsStream String filename) ; returns InputStream
        owriter  (java.io.StringWriter.)]
    (ds/copy istream owriter)
    (println (.toString owriter))))


(defn execute-liquibase-cmd
  "Execute Liquibase as if using command-line arguments (String array)"
  [& args]
  (let [argv (into-array String args)]
    (liquibase.integration.commandline.Main/main argv)))


;; ----- Leiningen plugin command -----

(defn lb
  [& args]
  (let [argc (count args)
        cmd  (first args)]
    ;; check for lein-lb commands
    (cond
      (empty? args)                (help)
      (= cmd ":help")              (help)
      (= cmd ":sample-properties") (sample-props)
      :else                        (apply execute-liquibase-cmd args))))
